/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common.data;

import com.ibm.websphere.appserver.tools.jaxrpc.common.ReplaceRPCUtil;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.ServiceEndpointMethod;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.WSDLResource;
import java.util.ArrayList;
import java.util.List;

public class ServiceEndpointInterface {
    List<ServiceEndpointMethod> methodList = new ArrayList<ServiceEndpointMethod>();
    String seiName;
    String seiPath;
    String portComponentName;
    String basePath;
    WSDLResource wsdl;

    public ServiceEndpointInterface(String seiName) {
        this.seiName = seiName;
    }

    public ServiceEndpointInterface(String seiName, WSDLResource wsdl) {
        this.seiName = seiName;
        this.wsdl = wsdl;
    }

    public ServiceEndpointInterface(String seiName, String portComponentName, WSDLResource wsdl) {
        this(seiName, wsdl);
        this.portComponentName = portComponentName;
    }

    public String toString() {
        return "ServiceEndpointInterface[seiName: " + this.seiName + "]";
    }

    public String getSeiName() {
        return this.seiName;
    }

    public String getSeiPath() {
        return this.seiPath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setSeiPath(String path) {
        this.seiPath = path;
        this.basePath = this.seiPath.substring(0, this.seiPath.length() - this.seiName.length() - 6);
    }

    public void setPortComponentName(String name2) {
        this.portComponentName = name2;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public WSDLResource getWsdlResource() {
        return this.wsdl;
    }

    public void setWsdlResource(WSDLResource wsdl) {
        this.wsdl = wsdl;
    }

    public void addMethod(ServiceEndpointMethod method) {
        if (!this.methodList.contains(method)) {
            this.methodList.add(method);
        } else {
            ReplaceRPCUtil.getLogger().error("ServiceEndpointInterface: " + this.seiName + " contains duplicate method " + method.getMethodName());
        }
    }

    public List<ServiceEndpointMethod> getMethodList() {
        return this.methodList;
    }

    public String getTargetNamespace() {
        return this.wsdl == null ? null : this.wsdl.getTargetNamespace();
    }

    public String getSoapAddress(String portName) {
        return this.wsdl == null ? null : this.wsdl.getSoapAddress(portName);
    }
}

