/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.compare_comply.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.compare_comply.v1.model.Location;
import com.ibm.watson.compare_comply.v1.model.OriginalLabelsIn;
import com.ibm.watson.compare_comply.v1.model.ShortDoc;
import com.ibm.watson.compare_comply.v1.model.UpdatedLabelsIn;

public class FeedbackDataInput
extends GenericModel {
    @SerializedName(value="feedback_type")
    protected String feedbackType;
    protected ShortDoc document;
    @SerializedName(value="model_id")
    protected String modelId;
    @SerializedName(value="model_version")
    protected String modelVersion;
    protected Location location;
    protected String text;
    @SerializedName(value="original_labels")
    protected OriginalLabelsIn originalLabels;
    @SerializedName(value="updated_labels")
    protected UpdatedLabelsIn updatedLabels;

    protected FeedbackDataInput(Builder builder) {
        Validator.notNull((Object)builder.feedbackType, (String)"feedbackType cannot be null");
        Validator.notNull((Object)((Object)builder.location), (String)"location cannot be null");
        Validator.notNull((Object)builder.text, (String)"text cannot be null");
        Validator.notNull((Object)((Object)builder.originalLabels), (String)"originalLabels cannot be null");
        Validator.notNull((Object)((Object)builder.updatedLabels), (String)"updatedLabels cannot be null");
        this.feedbackType = builder.feedbackType;
        this.document = builder.document;
        this.modelId = builder.modelId;
        this.modelVersion = builder.modelVersion;
        this.location = builder.location;
        this.text = builder.text;
        this.originalLabels = builder.originalLabels;
        this.updatedLabels = builder.updatedLabels;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String feedbackType() {
        return this.feedbackType;
    }

    public ShortDoc document() {
        return this.document;
    }

    public String modelId() {
        return this.modelId;
    }

    public String modelVersion() {
        return this.modelVersion;
    }

    public Location location() {
        return this.location;
    }

    public String text() {
        return this.text;
    }

    public OriginalLabelsIn originalLabels() {
        return this.originalLabels;
    }

    public UpdatedLabelsIn updatedLabels() {
        return this.updatedLabels;
    }

    public static class Builder {
        private String feedbackType;
        private ShortDoc document;
        private String modelId;
        private String modelVersion;
        private Location location;
        private String text;
        private OriginalLabelsIn originalLabels;
        private UpdatedLabelsIn updatedLabels;

        private Builder(FeedbackDataInput feedbackDataInput) {
            this.feedbackType = feedbackDataInput.feedbackType;
            this.document = feedbackDataInput.document;
            this.modelId = feedbackDataInput.modelId;
            this.modelVersion = feedbackDataInput.modelVersion;
            this.location = feedbackDataInput.location;
            this.text = feedbackDataInput.text;
            this.originalLabels = feedbackDataInput.originalLabels;
            this.updatedLabels = feedbackDataInput.updatedLabels;
        }

        public Builder() {
        }

        public Builder(String feedbackType, Location location, String text, OriginalLabelsIn originalLabels, UpdatedLabelsIn updatedLabels) {
            this.feedbackType = feedbackType;
            this.location = location;
            this.text = text;
            this.originalLabels = originalLabels;
            this.updatedLabels = updatedLabels;
        }

        public FeedbackDataInput build() {
            return new FeedbackDataInput(this);
        }

        public Builder feedbackType(String feedbackType) {
            this.feedbackType = feedbackType;
            return this;
        }

        public Builder document(ShortDoc document) {
            this.document = document;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder originalLabels(OriginalLabelsIn originalLabels) {
            this.originalLabels = originalLabels;
            return this;
        }

        public Builder updatedLabels(UpdatedLabelsIn updatedLabels) {
            this.updatedLabels = updatedLabels;
            return this;
        }
    }
}

