/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.compare_comply.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class ExtractTablesOptions
extends GenericModel {
    protected InputStream file;
    protected String fileContentType;
    protected String model;

    protected ExtractTablesOptions(Builder builder) {
        Validator.notNull((Object)builder.file, (String)"file cannot be null");
        this.file = builder.file;
        this.fileContentType = builder.fileContentType;
        this.model = builder.model;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream file() {
        return this.file;
    }

    public String fileContentType() {
        return this.fileContentType;
    }

    public String model() {
        return this.model;
    }

    public static class Builder {
        private InputStream file;
        private String fileContentType;
        private String model;

        private Builder(ExtractTablesOptions extractTablesOptions) {
            this.file = extractTablesOptions.file;
            this.fileContentType = extractTablesOptions.fileContentType;
            this.model = extractTablesOptions.model;
        }

        public Builder() {
        }

        public Builder(InputStream file) {
            this.file = file;
        }

        public ExtractTablesOptions build() {
            return new ExtractTablesOptions(this);
        }

        public Builder file(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder fileContentType(String fileContentType) {
            this.fileContentType = fileContentType;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder file(File file) throws FileNotFoundException {
            this.file = new FileInputStream(file);
            return this;
        }
    }

    public static interface Model {
        public static final String CONTRACTS = "contracts";
        public static final String TABLES = "tables";
    }
}

