/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.compare_comply.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CompareDocumentsOptions
extends GenericModel {
    protected InputStream file1;
    protected InputStream file2;
    protected String file1ContentType;
    protected String file2ContentType;
    protected String file1Label;
    protected String file2Label;
    protected String model;

    protected CompareDocumentsOptions(Builder builder) {
        Validator.notNull((Object)builder.file1, (String)"file1 cannot be null");
        Validator.notNull((Object)builder.file2, (String)"file2 cannot be null");
        this.file1 = builder.file1;
        this.file2 = builder.file2;
        this.file1ContentType = builder.file1ContentType;
        this.file2ContentType = builder.file2ContentType;
        this.file1Label = builder.file1Label;
        this.file2Label = builder.file2Label;
        this.model = builder.model;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream file1() {
        return this.file1;
    }

    public InputStream file2() {
        return this.file2;
    }

    public String file1ContentType() {
        return this.file1ContentType;
    }

    public String file2ContentType() {
        return this.file2ContentType;
    }

    public String file1Label() {
        return this.file1Label;
    }

    public String file2Label() {
        return this.file2Label;
    }

    public String model() {
        return this.model;
    }

    public static class Builder {
        private InputStream file1;
        private InputStream file2;
        private String file1ContentType;
        private String file2ContentType;
        private String file1Label;
        private String file2Label;
        private String model;

        private Builder(CompareDocumentsOptions compareDocumentsOptions) {
            this.file1 = compareDocumentsOptions.file1;
            this.file2 = compareDocumentsOptions.file2;
            this.file1ContentType = compareDocumentsOptions.file1ContentType;
            this.file2ContentType = compareDocumentsOptions.file2ContentType;
            this.file1Label = compareDocumentsOptions.file1Label;
            this.file2Label = compareDocumentsOptions.file2Label;
            this.model = compareDocumentsOptions.model;
        }

        public Builder() {
        }

        public Builder(InputStream file1, InputStream file2) {
            this.file1 = file1;
            this.file2 = file2;
        }

        public CompareDocumentsOptions build() {
            return new CompareDocumentsOptions(this);
        }

        public Builder file1(InputStream file1) {
            this.file1 = file1;
            return this;
        }

        public Builder file2(InputStream file2) {
            this.file2 = file2;
            return this;
        }

        public Builder file1ContentType(String file1ContentType) {
            this.file1ContentType = file1ContentType;
            return this;
        }

        public Builder file2ContentType(String file2ContentType) {
            this.file2ContentType = file2ContentType;
            return this;
        }

        public Builder file1Label(String file1Label) {
            this.file1Label = file1Label;
            return this;
        }

        public Builder file2Label(String file2Label) {
            this.file2Label = file2Label;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder file1(File file1) throws FileNotFoundException {
            this.file1 = new FileInputStream(file1);
            return this;
        }

        public Builder file2(File file2) throws FileNotFoundException {
            this.file2 = new FileInputStream(file2);
            return this;
        }
    }

    public static interface Model {
        public static final String CONTRACTS = "contracts";
        public static final String TABLES = "tables";
    }
}

