/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.types.generics.Signature;
import com.ibm.wala.types.generics.TypeSignature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class TypeArgument
extends Signature {
    private final TypeSignature sig;
    private final WildcardIndicator w;
    private static final TypeArgument WILDCARD = new TypeArgument("*"){

        @Override
        public boolean isWildcard() {
            return true;
        }

        @Override
        public String toString() {
            return "*";
        }
    };

    private TypeArgument(String s) {
        super(s);
        this.sig = null;
        this.w = null;
    }

    private TypeArgument(TypeSignature sig, WildcardIndicator w) {
        super(sig.rawString());
        this.sig = sig;
        this.w = w;
    }

    public boolean isWildcard() {
        return false;
    }

    public static TypeArgument[] make(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (s.length() == 0 || s.charAt(0) != '<') {
            throw new IllegalArgumentException(s);
        }
        if (s.charAt(s.length() - 1) != '>') {
            throw new IllegalArgumentException(s);
        }
        String[] args = TypeArgument.parseForTypeArguments(s);
        TypeArgument[] result = new TypeArgument[args.length];
        Arrays.setAll(result, i -> TypeArgument.makeTypeArgument(args[i]));
        return result;
    }

    private static TypeArgument makeTypeArgument(String s) {
        switch (s.charAt(0)) {
            case '*': {
                return WILDCARD;
            }
            case '+': {
                TypeSignature sig = TypeSignature.make(s.substring(1));
                return new TypeArgument(sig, WildcardIndicator.PLUS);
            }
            case '-': {
                TypeSignature sig = TypeSignature.make(s.substring(1));
                return new TypeArgument(sig, WildcardIndicator.MINUS);
            }
        }
        TypeSignature sig = TypeSignature.make(s);
        return new TypeArgument(sig, null);
    }

    static String[] parseForTypeArguments(String typeArgs) {
        ArrayList<String> args = new ArrayList<String>(10);
        int i = 1;
        block7: while (true) {
            switch (typeArgs.charAt(i++)) {
                case 'L': {
                    int off = i - 1;
                    int depth = 0;
                    while (typeArgs.charAt(i++) != ';' || depth > 0) {
                        if (typeArgs.charAt(i - 1) == '<') {
                            ++depth;
                        }
                        if (typeArgs.charAt(i - 1) != '>') continue;
                        --depth;
                    }
                    args.add(typeArgs.substring(off, i));
                    continue block7;
                }
                case '[': {
                    int off = i - 1;
                    while (typeArgs.charAt(i) == '[') {
                        ++i;
                    }
                    if (typeArgs.charAt(i) == 'L') {
                        while (typeArgs.charAt(i++) != ';') {
                        }
                    } else if (typeArgs.charAt(i++) == 'T') {
                        while (typeArgs.charAt(i++) != ';') {
                        }
                    }
                    args.add(typeArgs.substring(off, i));
                    continue block7;
                }
                case '+': 
                case '-': 
                case 'T': {
                    int off = i - 1;
                    while (typeArgs.charAt(i++) != ';') {
                    }
                    args.add(typeArgs.substring(off, i));
                    continue block7;
                }
                case '*': {
                    args.add("*");
                    continue block7;
                }
                case '>': {
                    int size = args.size();
                    if (size == 0) {
                        return null;
                    }
                    Iterator it = args.iterator();
                    String[] result = new String[size];
                    for (int j = 0; j < size; ++j) {
                        result[j] = (String)it.next();
                    }
                    return result;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError((Object)("bad type argument list " + typeArgs));
    }

    public TypeSignature getFieldTypeSignature() {
        return this.sig;
    }

    @Override
    public String toString() {
        if (this.w == null) {
            return this.sig.toString();
        }
        if (this.w.equals((Object)WildcardIndicator.PLUS)) {
            return "+" + this.sig.toString();
        }
        return "-" + this.sig.toString();
    }

    private static enum WildcardIndicator {
        PLUS,
        MINUS;

    }
}

