/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.intset.IntIterator;

public class SSASwitchInstruction
extends SSAInstruction {
    private final int val;
    private final int defaultLabel;
    private final int[] casesAndLabels;

    public SSASwitchInstruction(int iindex, int val, int defaultLabel, int[] casesAndLabels) {
        super(iindex);
        this.val = val;
        this.defaultLabel = defaultLabel;
        this.casesAndLabels = casesAndLabels;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        assert (uses == null || uses.length == 1);
        for (int i = 1; i < this.casesAndLabels.length; i += 2) {
            assert (this.casesAndLabels[i] != this.iIndex()) : "do not branch to self: " + this;
        }
        return insts.SwitchInstruction(this.iIndex(), uses == null ? this.val : uses[0], this.defaultLabel, this.casesAndLabels);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        StringBuilder result = new StringBuilder(this.iIndex() + ": switch ");
        result.append(this.getValueString(symbolTable, this.val));
        result.append(" [");
        for (int i = 0; i < this.casesAndLabels.length - 1; ++i) {
            result.append(this.casesAndLabels[i]);
            result.append("->");
            result.append(this.casesAndLabels[++i]);
            if (i >= this.casesAndLabels.length - 2) continue;
            result.append(',');
        }
        result.append("] default: ").append(this.defaultLabel);
        return result.toString();
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitSwitch(this);
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getUse(int j) {
        assert (j <= 1);
        return this.val;
    }

    public int getTarget(int caseValue) {
        for (int i = 0; i < this.casesAndLabels.length; i += 2) {
            if (caseValue != this.casesAndLabels[i]) continue;
            return this.casesAndLabels[i + 1];
        }
        return this.defaultLabel;
    }

    public int getDefault() {
        return this.defaultLabel;
    }

    public int[] getCasesAndLabels() {
        return this.casesAndLabels;
    }

    public IntIterator iterateLabels() {
        return new IntIterator(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < SSASwitchInstruction.this.casesAndLabels.length;
            }

            public int next() {
                int v = SSASwitchInstruction.this.casesAndLabels[this.i];
                this.i += 2;
                return v;
            }
        };
    }

    @Override
    public int hashCode() {
        return this.val * 1663 + 3499;
    }

    @Override
    public boolean isFallThrough() {
        return false;
    }
}

