/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.IVisitorWithAddresses;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

public class SSAAddressOfInstruction
extends SSAInstruction {
    private final int lval;
    private final int addressVal;
    private final int indexVal;
    private final FieldReference field;
    private final TypeReference pointeeType;

    public SSAAddressOfInstruction(int iindex, int lval, int local, TypeReference pointeeType) {
        super(iindex);
        if (local <= 0) {
            throw new IllegalArgumentException("Invalid local address load of " + local);
        }
        this.lval = lval;
        this.addressVal = local;
        this.indexVal = -1;
        this.field = null;
        this.pointeeType = pointeeType;
    }

    public SSAAddressOfInstruction(int iindex, int lval, int basePointer, int indexVal, TypeReference pointeeType) {
        super(iindex);
        this.lval = lval;
        this.addressVal = basePointer;
        this.indexVal = indexVal;
        this.field = null;
        this.pointeeType = pointeeType;
    }

    public SSAAddressOfInstruction(int iindex, int lval, int basePointer, FieldReference field, TypeReference pointeeType) {
        super(iindex);
        this.lval = lval;
        this.addressVal = basePointer;
        this.indexVal = -1;
        this.field = field;
        this.pointeeType = pointeeType;
    }

    public TypeReference getType() {
        return this.pointeeType;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        Assertions.UNREACHABLE((String)"not yet implemented.  to be nuked");
        return null;
    }

    @Override
    public int hashCode() {
        return this.lval * 99701 + this.addressVal;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.lval) + " (" + this.pointeeType.getName() + ")  = &" + this.getValueString(symbolTable, this.addressVal) + (String)(this.indexVal != -1 ? "[" + this.getValueString(symbolTable, this.indexVal) + "]" : (this.field != null ? "." + this.field.getName().toString() : ""));
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        assert (v instanceof IVisitorWithAddresses) : "expected an instance of IVisitorWithAddresses";
        ((IVisitorWithAddresses)v).visitAddressOf(this);
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public int getDef(int i) {
        assert (i == 0);
        return this.lval;
    }

    @Override
    public int getDef() {
        return this.lval;
    }

    @Override
    public int getNumberOfUses() {
        return this.indexVal == -1 ? 1 : 2;
    }

    @Override
    public int getUse(int i) {
        assert (i == 0 || i == 1 && this.indexVal != -1);
        if (i == 0) {
            return this.addressVal;
        }
        return this.indexVal;
    }
}

