/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.ArrayList;
import java.util.Map;

public class MethodSummary {
    protected static final SSAInstruction[] NO_STATEMENTS = new SSAInstruction[0];
    private final MethodReference method;
    private ArrayList<SSAInstruction> statements;
    private Map<Integer, ConstantValue> constantValues;
    private String poison;
    private byte poisonLevel;
    private boolean isStatic = false;
    private boolean isFactory = false;
    private final int numberOfParameters;
    private Map<Integer, Atom> valueNames = null;

    public MethodSummary(MethodReference method) {
        this(method, -1);
    }

    public MethodSummary(MethodReference method, int numberOfParameters) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        this.numberOfParameters = numberOfParameters;
        this.method = method;
    }

    public void setValueNames(Map<Integer, Atom> nameTable) {
        this.valueNames = nameTable;
    }

    public Map<Integer, Atom> getValueNames() {
        return this.valueNames;
    }

    public Atom getValue(Integer v) {
        return this.valueNames != null && this.valueNames.containsKey(v) ? this.valueNames.get(v) : null;
    }

    public int getNumberOfStatements() {
        return this.statements == null ? 0 : this.statements.size();
    }

    public void addStatement(SSAInstruction statement) {
        if (this.statements == null) {
            this.statements = new ArrayList();
        }
        this.statements.add(statement);
    }

    public void addConstant(Integer vn, ConstantValue value) {
        if (this.constantValues == null) {
            this.constantValues = HashMapFactory.make((int)5);
        }
        this.constantValues.put(vn, value);
    }

    public MethodReference getMethod() {
        return this.method;
    }

    public boolean isNative() {
        return false;
    }

    public void addPoison(String reason) {
        this.poison = reason;
    }

    public boolean hasPoison() {
        return this.poison != null;
    }

    public String getPoison() {
        return this.poison;
    }

    public void setPoisonLevel(byte b) {
        this.poisonLevel = b;
        assert (b == 0 || b == 1 || b == 2);
    }

    public byte getPoisonLevel() {
        return this.poisonLevel;
    }

    public SSAInstruction[] getStatements() {
        return this.statements == null ? NO_STATEMENTS : this.statements.toArray(new SSAInstruction[0]);
    }

    public Map<Integer, ConstantValue> getConstants() {
        return this.constantValues;
    }

    public int getNumberOfParameters() {
        if (this.numberOfParameters >= 0) {
            return this.numberOfParameters;
        }
        return this.isStatic() ? this.method.getNumberOfParameters() : this.method.getNumberOfParameters() + 1;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean b) {
        this.isStatic = b;
    }

    public TypeReference getReturnType() {
        return this.method.getReturnType();
    }

    public String toString() {
        return "[Summary: " + this.method + "]";
    }

    public TypeReference getParameterType(int i) {
        if (this.isStatic()) {
            return this.method.getParameterType(i);
        }
        if (i == 0) {
            return this.method.getDeclaringClass();
        }
        return this.method.getParameterType(i - 1);
    }

    public void setFactory(boolean b) {
        this.isFactory = b;
    }

    public boolean isFactory() {
        return this.isFactory;
    }
}

