/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.analysis.reflection.ReflectionContextInterpreter;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.DefaultContextSelector;
import com.ibm.wala.ipa.callgraph.impl.DelegatingContextSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.callgraph.propagation.ClassBasedInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.IPointsToSolver;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.StandardSolver;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultPointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultSSAInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DelegatingSSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.rta.DelegatingExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.rta.TypeBasedPointerAnalysis;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractRTABuilder
extends PropagationCallGraphBuilder {
    protected static final int DEBUG_LEVEL = 0;
    protected static final boolean DEBUG = false;
    private static final int VERBOSE_INTERVAL = 10000;
    private static final int PERIODIC_MAINTAIN_INTERVAL = 10000;
    protected final boolean clone2Assign = true;
    protected final Set<IClass> clinitProcessed = HashSetFactory.make();
    protected final HashSet<IClass> allocatedClasses = HashSetFactory.make();
    private static final TypeReference[] PRE_ALLOC = new TypeReference[]{TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/Object"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ArithmeticException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ArrayStoreException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ClassCastException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ClassNotFoundException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/IndexOutOfBoundsException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/NegativeArraySizeException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ExceptionInInitializerError"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/NullPointerException")};

    protected AbstractRTABuilder(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache, ContextSelector appContextSelector, SSAContextInterpreter appContextInterpreter) {
        super(Language.JAVA.getFakeRootMethod(cha, options, cache), options, cache, new DefaultPointerKeyFactory());
        this.setInstanceKeys(new ClassBasedInstanceKeys(options, cha));
        this.setContextSelector(this.makeContextSelector(appContextSelector));
        this.setContextInterpreter(this.makeContextInterpreter(appContextInterpreter));
    }

    protected RTAContextInterpreter getRTAContextInterpreter() {
        return this.getContextInterpreter();
    }

    @Override
    protected boolean addConstraintsFromNode(CGNode node, MonitorUtil.IProgressMonitor monitor) {
        if (this.haveAlreadyVisited(node)) {
            return false;
        }
        this.markAlreadyVisited(node);
        this.addNewConstraints(node);
        this.addCallConstraints(node);
        this.addFieldConstraints(node);
        return true;
    }

    private void addNewConstraints(CGNode node) {
        for (NewSiteReference n : Iterator2Iterable.make(this.getRTAContextInterpreter().iterateNewSites(node))) {
            this.visitNew(node, n);
        }
    }

    private void addCallConstraints(CGNode node) {
        for (CallSiteReference c : Iterator2Iterable.make(this.getRTAContextInterpreter().iterateCallSites(node))) {
            this.visitInvoke(node, c);
        }
    }

    private void addFieldConstraints(CGNode node) {
        for (FieldReference f : Iterator2Iterable.make(this.getRTAContextInterpreter().iterateFieldsRead(node))) {
            this.processFieldAccess(f);
        }
        for (FieldReference f : Iterator2Iterable.make(this.getRTAContextInterpreter().iterateFieldsWritten(node))) {
            this.processFieldAccess(f);
        }
    }

    private void processFieldAccess(FieldReference f) {
        TypeReference t = f.getDeclaringClass();
        IClass klass = this.getClassHierarchy().lookupClass(t);
        if (klass != null) {
            this.processClassInitializer(klass);
        }
    }

    protected void processClassInitializer(IClass klass) {
        if (!this.clinitProcessed.add(klass)) {
            return;
        }
        if (klass.getClassInitializer() != null) {
            CGNode target;
            FakeWorldClinitMethod fakeWorldClinitMethod = (FakeWorldClinitMethod)this.callGraph.getFakeWorldClinitNode().getMethod();
            MethodReference m = klass.getClassInitializer().getReference();
            CallSiteReference site = CallSiteReference.make(1, m, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
            IMethod targetMethod = this.options.getMethodTargetSelector().getCalleeTarget(this.callGraph.getFakeRootNode(), site, null);
            if (targetMethod != null && (target = this.callGraph.getNode(targetMethod, Everywhere.EVERYWHERE)) == null) {
                SSAAbstractInvokeInstruction s = fakeWorldClinitMethod.addInvocation(null, site);
                try {
                    target = this.callGraph.findOrCreateNode(targetMethod, Everywhere.EVERYWHERE);
                    this.processResolvedCall(this.callGraph.getFakeWorldClinitNode(), s.getCallSite(), target);
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
            }
        }
        if ((klass = klass.getSuperclass()) != null && !this.clinitProcessed.contains(klass)) {
            this.processClassInitializer(klass);
        }
    }

    public void visitInvoke(CGNode node, CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        IInvokeInstruction.IDispatch code = site.getInvocationCode();
        if (code == IInvokeInstruction.Dispatch.STATIC) {
            CGNode n = this.getTargetForCall(node, site, null, null);
            if (n != null) {
                this.processResolvedCall(node, site, n);
                this.processClassInitializer(this.cha.lookupClass(site.getDeclaredTarget().getDeclaringClass()));
            }
        } else {
            PointerKey selector = this.getKeyForSite(site);
            if (selector == null) {
                return;
            }
            UnaryOperator<PointsToSetVariable> dispatchOperator = this.makeDispatchOperator(site, node);
            this.system.newSideEffect(dispatchOperator, selector);
        }
    }

    protected abstract UnaryOperator<PointsToSetVariable> makeDispatchOperator(CallSiteReference var1, CGNode var2);

    protected abstract PointerKey getKeyForSite(CallSiteReference var1);

    void processResolvedCall(CGNode caller, CallSiteReference site, CGNode target) {
        caller.addTarget(site, target);
        if (caller.equals(this.callGraph.getFakeRootNode()) && this.entrypointCallSites.contains(site)) {
            this.callGraph.registerEntrypoint(target);
        }
        if (!this.haveAlreadyVisited(target)) {
            this.markDiscovered(target);
        }
    }

    public void visitNew(CGNode node, NewSiteReference newSite) {
        if (newSite == null) {
            throw new IllegalArgumentException("newSite is null");
        }
        InstanceKey iKey = this.getInstanceKeyForAllocation(node, newSite);
        if (iKey == null) {
            return;
        }
        IClass klass = iKey.getConcreteType();
        if (klass == null) {
            return;
        }
        if (!this.allocatedClasses.add(klass)) {
            return;
        }
        this.updateSetsForNewClass(klass, iKey, node, newSite);
        this.processClassInitializer(klass);
    }

    protected abstract void updateSetsForNewClass(IClass var1, InstanceKey var2, CGNode var3, NewSiteReference var4);

    @Override
    protected void customInit() {
        super.customInit();
        FakeRootMethod m = (FakeRootMethod)this.getCallGraph().getFakeRootNode().getMethod();
        for (TypeReference element : PRE_ALLOC) {
            SSANewInstruction n = m.addAllocation(element);
            this.visitNew(this.getCallGraph().getFakeRootNode(), n.getNewSite());
        }
    }

    public Set<IClass> getAllocatedTypes() {
        return (Set)this.allocatedClasses.clone();
    }

    @Override
    protected IPointsToSolver makeSolver() {
        return new StandardSolver(this.system, this);
    }

    protected ContextSelector makeContextSelector(ContextSelector appContextSelector) {
        DefaultContextSelector def = new DefaultContextSelector(this.options, this.cha);
        ContextSelector contextSelector = appContextSelector == null ? def : new DelegatingContextSelector(appContextSelector, def);
        return contextSelector;
    }

    protected SSAContextInterpreter makeContextInterpreter(SSAContextInterpreter appContextInterpreter) {
        SSAContextInterpreter defI = new DefaultSSAInterpreter(this.getOptions(), this.getAnalysisCache());
        defI = new DelegatingSSAContextInterpreter(ReflectionContextInterpreter.createReflectionContextInterpreter(this.cha, this.getOptions(), this.getAnalysisCache()), defI);
        SSAContextInterpreter contextInterpreter = appContextInterpreter == null ? defI : new DelegatingSSAContextInterpreter(appContextInterpreter, defI);
        return contextInterpreter;
    }

    @Override
    protected boolean unconditionallyAddConstraintsFromNode(CGNode node, MonitorUtil.IProgressMonitor monitor) {
        this.addNewConstraints(node);
        this.addCallConstraints(node);
        this.addFieldConstraints(node);
        this.markAlreadyVisited(node);
        return true;
    }

    @Override
    protected ExplicitCallGraph createEmptyCallGraph(IMethod fakeRootClass, AnalysisOptions options) {
        return new DelegatingExplicitCallGraph(fakeRootClass, options, this.getAnalysisCache());
    }

    @Override
    protected PropagationSystem makeSystem(AnalysisOptions options) {
        PropagationSystem result = super.makeSystem(options);
        result.setVerboseInterval(10000);
        result.setPeriodicMaintainInterval(10000);
        return result;
    }

    @Override
    public PointerAnalysis<InstanceKey> getPointerAnalysis() {
        return TypeBasedPointerAnalysis.make(this.getOptions(), this.allocatedClasses, this.getCallGraph());
    }
}

