/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.DelegatingContext;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSite;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.AllocationString;
import com.ibm.wala.ipa.callgraph.propagation.cfa.AllocationStringContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ContainerContextSelector;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;

public class nObjContextSelector
implements ContextSelector {
    public static final ContextKey ALLOCATION_STRING_KEY = new ContextKey(){

        public String toString() {
            return "ALLOCATION_STRING_KEY";
        }
    };
    private final int n;
    private final ContextSelector base;
    private static final IntSet thisParameter = IntSetUtil.make((int[])new int[]{0});

    public nObjContextSelector(int n, ContextSelector base) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be a positive number");
        }
        this.n = n;
        this.base = base;
    }

    @Override
    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] actualParameters) {
        InstanceKey receiver;
        Context calleeContext = Everywhere.EVERYWHERE;
        InstanceKey instanceKey = receiver = actualParameters != null && actualParameters.length > 0 && actualParameters[0] != null ? actualParameters[0] : null;
        if (site.isStatic()) {
            calleeContext = this.getCalleeTargetForStaticCall(caller, site, callee);
        } else if (receiver instanceof AllocationSiteInNode) {
            AllocationString allocationString = this.assemblyReceiverAllocString((AllocationSiteInNode)receiver);
            calleeContext = new AllocationStringContext(allocationString);
        }
        Context baseContext = this.base.getCalleeTarget(caller, site, callee, actualParameters);
        return this.appendBaseContext(calleeContext, baseContext);
    }

    private AllocationString assemblyReceiverAllocString(AllocationSiteInNode receiver) {
        Context receiverHeapContext = receiver.getNode().getContext();
        AllocationSite receiverAllocSite = new AllocationSite(receiver.getNode().getMethod(), receiver.getSite(), receiver.getConcreteType());
        if (receiverHeapContext.get(ALLOCATION_STRING_KEY) != null) {
            AllocationString receiverAllocString = (AllocationString)receiverHeapContext.get(ALLOCATION_STRING_KEY);
            int siteLength = Math.min(this.n, receiverAllocString.getLength() + 1);
            AllocationSite[] sites = new AllocationSite[siteLength];
            sites[0] = receiverAllocSite;
            System.arraycopy(receiverAllocString.getAllocationSites(), 0, sites, 1, siteLength - 1);
            return new AllocationString(sites);
        }
        return new AllocationString(receiverAllocSite);
    }

    protected Context getCalleeTargetForStaticCall(CGNode caller, CallSiteReference site, IMethod callee) {
        return ContainerContextSelector.isWellKnownStaticFactory(callee.getReference()) ? new CallerSiteContext(caller, site) : caller.getContext();
    }

    private Context appendBaseContext(Context curr, Context base) {
        if (curr == Everywhere.EVERYWHERE) {
            return base;
        }
        return base == Everywhere.EVERYWHERE ? curr : new DelegatingContext(curr, base);
    }

    @Override
    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        if (site.isDispatch()) {
            return thisParameter;
        }
        return EmptyIntSet.instance;
    }
}

