/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyClassTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyMethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXContainerCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.cfa.nCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.nObjBuilder;
import com.ibm.wala.ipa.callgraph.propagation.rta.BasicRTABuilder;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.BypassClassTargetSelector;
import com.ibm.wala.ipa.summaries.BypassMethodTargetSelector;
import com.ibm.wala.ipa.summaries.LambdaMethodTargetSelector;
import com.ibm.wala.ipa.summaries.XMLMethodSummaryReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Util {
    public static String nativeSpec = "natives.xml";

    public static void setNativeSpec(String xmlFile) {
        nativeSpec = xmlFile;
    }

    public static String getNativeSpec() {
        return nativeSpec;
    }

    public static void addDefaultSelectors(AnalysisOptions options, IClassHierarchy cha) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        options.setSelector(new LambdaMethodTargetSelector(new ClassHierarchyMethodTargetSelector(cha)));
        options.setSelector(new ClassHierarchyClassTargetSelector(cha));
    }

    @Deprecated
    public static void addBypassLogic(AnalysisOptions options, AnalysisScope scope, ClassLoader cl, String xmlFile, IClassHierarchy cha) throws IllegalArgumentException {
        Util.addBypassLogic(options, cl, xmlFile, cha);
    }

    public static void addBypassLogic(AnalysisOptions options, ClassLoader cl, String xmlFile, IClassHierarchy cha) throws IllegalArgumentException {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("cl is null");
        }
        if (cha == null) {
            throw new IllegalArgumentException("cha cannot be null");
        }
        try (InputStream s = cl.getResourceAsStream(xmlFile);){
            XMLMethodSummaryReader summary = new XMLMethodSummaryReader(s, cha.getScope());
            Util.addBypassLogic(options, cl, summary, cha);
        }
        catch (IOException e) {
            System.err.println("Could not close XML method summary reader: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void addBypassLogic(AnalysisOptions options, AnalysisScope scope, ClassLoader cl, XMLMethodSummaryReader summary, IClassHierarchy cha) throws IllegalArgumentException {
        Util.addBypassLogic(options, cl, summary, cha);
    }

    public static void addBypassLogic(AnalysisOptions options, ClassLoader cl, XMLMethodSummaryReader summary, IClassHierarchy cha) throws IllegalArgumentException {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("cl is null");
        }
        if (cha == null) {
            throw new IllegalArgumentException("cha cannot be null");
        }
        BypassMethodTargetSelector ms = new BypassMethodTargetSelector(options.getMethodTargetSelector(), summary.getSummaries(), summary.getIgnoredPackages(), cha);
        options.setSelector(ms);
        BypassClassTargetSelector cs = new BypassClassTargetSelector(options.getClassTargetSelector(), summary.getAllocatableClasses(), cha, cha.getLoader(cha.getScope().getLoader(Atom.findOrCreateUnicodeAtom("Synthetic"))));
        options.setSelector(cs);
    }

    @Deprecated
    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        return Util.makeMainEntrypoints(cha);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(IClassHierarchy cha) {
        return Util.makeMainEntrypoints(cha.getScope().getApplicationLoader(), cha);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(ClassLoaderReference clr, IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        Atom mainMethod = Atom.findOrCreateAsciiAtom("main");
        HashSet result = HashSetFactory.make();
        for (IClass klass : cha) {
            MethodReference mainRef;
            IMethod m;
            if (!klass.getClassLoader().getReference().equals(clr) || (m = klass.getMethod((mainRef = MethodReference.findOrCreate(klass.getReference(), mainMethod, Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V"))).getSelector())) == null) continue;
            result.add(new DefaultEntrypoint(m, cha));
        }
        return result::iterator;
    }

    @Deprecated
    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope scope, IClassHierarchy cha, String className) {
        return Util.makeMainEntrypoints(scope, cha, new String[]{className});
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(IClassHierarchy cha, String className) {
        return Util.makeMainEntrypoints(cha, new String[]{className});
    }

    @Deprecated
    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope scope, IClassHierarchy cha, String[] classNames) {
        return Util.makeMainEntrypoints(cha, classNames);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(IClassHierarchy cha, String[] classNames) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        return Util.makeMainEntrypoints(cha.getScope().getApplicationLoader(), cha, classNames);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(final ClassLoaderReference loaderRef, final IClassHierarchy cha, final String[] classNames) throws IllegalArgumentException {
        if (classNames == null) {
            throw new IllegalArgumentException("classNames == null");
        }
        if (classNames.length == 0) {
            throw new IllegalArgumentException("classNames.length == 0");
        }
        if (classNames[0] == null && 0 < classNames.length) {
            throw new IllegalArgumentException("(0 < classNames.length) and (classNames[0] == null)");
        }
        for (String className : classNames) {
            if (className.indexOf(76) != 0) {
                throw new IllegalArgumentException("Expected class name to start with L " + className);
            }
            if (className.indexOf(46) <= 0) continue;
            Assertions.productionAssertion((boolean)false, (String)("Expected class name formatted with /, not . " + className));
        }
        return () -> {
            final Atom mainMethod = Atom.findOrCreateAsciiAtom("main");
            return new Iterator<Entrypoint>(){
                private int index = 0;

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }

                @Override
                public boolean hasNext() {
                    return this.index < classNames.length;
                }

                @Override
                public Entrypoint next() {
                    TypeReference T = TypeReference.findOrCreate(loaderRef, TypeName.string2TypeName(classNames[this.index++]));
                    MethodReference mainRef = MethodReference.findOrCreate(T, mainMethod, Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V"));
                    return new DefaultEntrypoint(mainRef, cha);
                }
            };
        };
    }

    public static <T> Set<T> setify(Iterator<? extends T> x) {
        if (x == null) {
            throw new IllegalArgumentException("Null x");
        }
        HashSet y = HashSetFactory.make();
        while (x.hasNext()) {
            y.add(x.next());
        }
        return y;
    }

    public static <T> void checkGraphSubset(Graph<T> supG, Graph<T> subG) {
        if (supG == null) {
            throw new IllegalArgumentException("supG is null");
        }
        if (subG == null) {
            throw new IllegalArgumentException("subG is null");
        }
        Set<T> nodeDiff = Util.setify(subG.iterator());
        nodeDiff.removeAll(Util.setify(supG.iterator()));
        if (!nodeDiff.isEmpty()) {
            System.err.println("supergraph: ");
            System.err.println(supG);
            System.err.println("subgraph: ");
            System.err.println(subG);
            System.err.println("nodeDiff: ");
            for (T t : nodeDiff) {
                System.err.println(t.toString());
            }
            Assertions.productionAssertion((boolean)nodeDiff.isEmpty(), (String)"bad superset, see tracefile\n");
        }
        for (Object m : subG) {
            Set<T> succDiff = Util.setify(subG.getSuccNodes(m));
            succDiff.removeAll(Util.setify(supG.getSuccNodes(m)));
            if (!succDiff.isEmpty()) {
                Assertions.productionAssertion((boolean)succDiff.isEmpty(), (String)("bad superset for successors of " + m + ":" + succDiff));
            }
            Set<T> predDiff = Util.setify(subG.getPredNodes(m));
            predDiff.removeAll(Util.setify(supG.getPredNodes(m)));
            if (predDiff.isEmpty()) continue;
            System.err.println("supergraph: ");
            System.err.println(supG);
            System.err.println("subgraph: ");
            System.err.println(subG);
            System.err.println("predDiff: ");
            for (T t : predDiff) {
                System.err.println(t.toString());
            }
            Assertions.UNREACHABLE((String)("bad superset for predecessors of " + m + ":" + predDiff));
        }
    }

    @Deprecated
    public static CallGraphBuilder<InstanceKey> makeRTABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeRTABuilder(options, cache, cha);
    }

    public static CallGraphBuilder<InstanceKey> makeRTABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) {
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, cha.getScope(), Util.class.getClassLoader(), cha);
        return new BasicRTABuilder(cha, options, cache, null, null);
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeZeroCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeZeroCFABuilder(l, options, cache, cha);
    }

    public static SSAPropagationCallGraphBuilder makeZeroCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) {
        return Util.makeZeroCFABuilder(l, options, cache, cha, null, null);
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeZeroCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        return Util.makeZeroCFABuilder(l, options, cache, cha, customSelector, customInterpreter);
    }

    public static SSAPropagationCallGraphBuilder makeZeroCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, Util.class.getClassLoader(), cha);
        return ZeroXCFABuilder.make(l, cha, options, cache, customSelector, customInterpreter, 0);
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeZeroOneCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeZeroOneCFABuilder(l, options, cache, cha, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) {
        return Util.makeZeroOneCFABuilder(l, options, cache, cha, null, null);
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView analysisCache, IClassHierarchy cha, AnalysisScope scope, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        return Util.makeVanillaZeroOneCFABuilder(l, options, analysisCache, cha, customSelector, customInterpreter);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView analysisCache, IClassHierarchy cha, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, Util.class.getClassLoader(), cha);
        return ZeroXCFABuilder.make(l, cha, options, analysisCache, customSelector, customInterpreter, 33);
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView analysisCache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeVanillaZeroOneCFABuilder(l, options, analysisCache, cha, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView analysisCache, IClassHierarchy cha) {
        return Util.makeVanillaZeroOneCFABuilder(l, options, analysisCache, cha, null, null);
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeZeroOneCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        return Util.makeZeroOneCFABuilder(l, options, cache, cha, customSelector, customInterpreter);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneCFABuilder(Language l, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, Util.class.getClassLoader(), cha);
        return ZeroXCFABuilder.make(l, cha, options, cache, customSelector, customInterpreter, 31);
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeZeroContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeZeroContainerCFABuilder(options, cache, cha);
    }

    public static SSAPropagationCallGraphBuilder makeZeroContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        return new ZeroXContainerCFABuilder(cha, options, cache, appSelector, appInterpreter, 0);
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeZeroOneContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeZeroOneContainerCFABuilder(options, cache, cha);
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeZeroOneContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope, ContextSelector appSelector, SSAContextInterpreter appInterpreter) {
        return Util.makeZeroOneContainerCFABuilder(options, cache, cha, appSelector, appInterpreter);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) {
        return Util.makeZeroOneContainerCFABuilder(options, cache, cha, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, ContextSelector appSelector, SSAContextInterpreter appInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, Util.class.getClassLoader(), cha);
        return new ZeroXContainerCFABuilder(cha, options, cache, appSelector, appInterpreter, 31);
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeNCFABuilder(int n, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeNCFABuilder(n, options, cache, cha);
    }

    public static SSAPropagationCallGraphBuilder makeNCFABuilder(int n, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        nCFABuilder result = new nCFABuilder(n, Language.JAVA.getFakeRootMethod(cha, options, cache), options, cache, appSelector, appInterpreter);
        result.setInstanceKeys(new ZeroXInstanceKeys(options, cha, result.getContextInterpreter(), 31));
        return result;
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeNObjBuilder(int n, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeNObjBuilder(n, options, cache, cha);
    }

    public static SSAPropagationCallGraphBuilder makeNObjBuilder(int n, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        nObjBuilder result = new nObjBuilder(n, cha, options, cache, appSelector, appInterpreter, 31);
        return result;
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeVanillaNObjBuilder(int n, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeVanillaNCFABuilder(n, options, cache, cha);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaNObjBuilder(int n, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        nObjBuilder result = new nObjBuilder(n, cha, options, cache, appSelector, appInterpreter, 1);
        return result;
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeVanillaNCFABuilder(int n, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeVanillaNCFABuilder(n, options, cache, cha);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaNCFABuilder(int n, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        nCFABuilder result = new nCFABuilder(n, Language.JAVA.getFakeRootMethod(cha, options, cache), options, cache, appSelector, appInterpreter);
        result.setInstanceKeys(new ZeroXInstanceKeys(options, cha, result.getContextInterpreter(), 33));
        return result;
    }

    @Deprecated
    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeVanillaZeroOneContainerCFABuilder(options, cache, cha);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        options.setUseConstantSpecificKeys(true);
        return new ZeroXContainerCFABuilder(cha, options, cache, appSelector, appInterpreter, 1);
    }

    @Deprecated
    public static void addDefaultBypassLogic(AnalysisOptions options, AnalysisScope scope, ClassLoader cl, IClassHierarchy cha) {
        Util.addDefaultBypassLogic(options, cl, cha);
    }

    public static void addDefaultBypassLogic(AnalysisOptions options, ClassLoader cl, IClassHierarchy cha) {
        if (nativeSpec == null) {
            return;
        }
        if (cl.getResourceAsStream(nativeSpec) != null) {
            Util.addBypassLogic(options, cl, nativeSpec, cha);
        } else {
            try (BufferedInputStream bIn = new BufferedInputStream(new FileInputStream(nativeSpec));){
                XMLMethodSummaryReader reader = new XMLMethodSummaryReader(bIn, cha.getScope());
                Util.addBypassLogic(options, cl, reader, cha);
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not load natives xml file from: " + nativeSpec);
                e.printStackTrace();
            }
            catch (IOException e) {
                System.err.println("Could not close natives xml file " + nativeSpec);
                e.printStackTrace();
            }
        }
    }
}

