/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.cha;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.cha.CHAContextInterpreter;
import com.ibm.wala.ipa.callgraph.cha.ContextInsensitiveCHAContextInterpreter;
import com.ibm.wala.ipa.callgraph.impl.BasicCallGraph;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.ExplicitPredecessorsEdgeManager;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.ComposedIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class CHACallGraph
extends BasicCallGraph<CHAContextInterpreter> {
    private final IClassHierarchy cha;
    private final AnalysisOptions options;
    private final IAnalysisCacheView cache;
    private final boolean applicationOnly;
    private boolean isInitialized = false;
    private final Map<CallSiteReference, Set<IMethod>> targetCache = HashMapFactory.make();
    private int clinitPC = 0;
    private final ArrayDeque<CGNode> newNodes = new ArrayDeque();
    private final CHACallGraphEdgeManager edgeManager = new CHACallGraphEdgeManager();

    public CHACallGraph(IClassHierarchy cha) {
        this(cha, false);
    }

    public CHACallGraph(IClassHierarchy cha, boolean applicationOnly) {
        this.cha = cha;
        this.options = new AnalysisOptions();
        this.cache = new AnalysisCacheImpl();
        this.applicationOnly = applicationOnly;
        this.setInterpreter(new ContextInsensitiveCHAContextInterpreter());
    }

    public void init(Iterable<Entrypoint> entrypoints) throws CancelException {
        super.init();
        CGNode root = this.getFakeRootNode();
        int programCounter = 0;
        for (Entrypoint e : entrypoints) {
            root.addTarget(e.makeSite(programCounter++), null);
        }
        this.newNodes.push(root);
        this.closure();
        this.isInitialized = true;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    private Iterator<IMethod> getPossibleTargets(CallSiteReference site) {
        Set<IMethod> result = this.targetCache.get(site);
        if (result == null) {
            IMethod m;
            result = site.isDispatch() ? this.cha.getPossibleTargets(site.getDeclaredTarget()) : ((m = this.cha.resolveMethod(site.getDeclaredTarget())) != null ? Collections.singleton(m) : Collections.emptySet());
            this.targetCache.put(site, result);
        }
        return result.iterator();
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site) {
        return Iterator2Collection.toSet((Iterator)new MapIterator((Iterator)new FilterIterator(this.getPossibleTargets(site), this::isRelevantMethod), object -> {
            try {
                return this.findOrCreateNode((IMethod)object, Everywhere.EVERYWHERE);
            }
            catch (CancelException e) {
                assert (false) : e.toString();
                return null;
            }
        }));
    }

    @Override
    public int getNumberOfTargets(CGNode node, CallSiteReference site) {
        return IteratorUtil.count(this.getPossibleTargets(site));
    }

    @Override
    public Iterator<CallSiteReference> getPossibleSites(CGNode src, CGNode target) {
        return new FilterIterator(((CHAContextInterpreter)this.getInterpreter(src)).iterateCallSites(src), o -> this.getPossibleTargets(src, (CallSiteReference)o).contains(target));
    }

    @Override
    protected CGNode makeFakeRootNode() throws CancelException {
        return new CHARootNode(Language.JAVA.getFakeRootMethod(this.cha, this.options, this.cache), Everywhere.EVERYWHERE);
    }

    @Override
    protected CGNode makeFakeWorldClinitNode() throws CancelException {
        return new CHARootNode(new FakeWorldClinitMethod(Language.JAVA.getFakeRootMethod(this.cha, this.options, this.cache).getDeclaringClass(), this.options, this.cache), Everywhere.EVERYWHERE);
    }

    @Override
    public CGNode findOrCreateNode(IMethod method, Context C) throws CancelException {
        assert (C.equals(Everywhere.EVERYWHERE));
        assert (!method.isAbstract());
        CGNode n = this.getNode(method, C);
        if (n == null) {
            assert (!this.isInitialized);
            n = this.makeNewNode(method, C);
            IMethod clinit = method.getDeclaringClass().getClassInitializer();
            if (clinit != null && this.getNode(clinit, Everywhere.EVERYWHERE) == null) {
                CGNode cln = this.makeNewNode(clinit, Everywhere.EVERYWHERE);
                CGNode clinits = this.getFakeWorldClinitNode();
                clinits.addTarget(CallSiteReference.make(this.clinitPC++, clinit.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC), cln);
                this.edgeManager.addEdge(clinits, cln);
            }
        }
        return n;
    }

    private void closure() throws CancelException {
        while (!this.newNodes.isEmpty()) {
            CGNode n = this.newNodes.pop();
            for (CallSiteReference site : Iterator2Iterable.make(n.iterateCallSites())) {
                Iterator<IMethod> methods = this.getPossibleTargets(site);
                while (methods.hasNext()) {
                    IMethod target = methods.next();
                    if (!this.isRelevantMethod(target)) continue;
                    CGNode callee = this.getNode(target, Everywhere.EVERYWHERE);
                    if (callee == null) {
                        callee = this.findOrCreateNode(target, Everywhere.EVERYWHERE);
                        if (n == this.getFakeRootNode()) {
                            this.registerEntrypoint(callee);
                        }
                    }
                    this.edgeManager.addEdge(n, callee);
                }
            }
        }
    }

    private boolean isRelevantMethod(IMethod target) {
        return !target.isAbstract() && (!this.applicationOnly || this.cha.getScope().isApplicationLoader(target.getDeclaringClass().getClassLoader()));
    }

    private CGNode makeNewNode(IMethod method, Context C) {
        BasicCallGraph.Key k = new BasicCallGraph.Key(method, C);
        CHANode n = new CHANode(method, C);
        this.registerNode(k, n);
        this.newNodes.push(n);
        return n;
    }

    protected NumberedEdgeManager<CGNode> getEdgeManager() {
        return this.edgeManager;
    }

    private class CHACallGraphEdgeManager
    extends ExplicitPredecessorsEdgeManager {
        protected CHACallGraphEdgeManager() {
            super((NumberedNodeManager<CGNode>)CHACallGraph.this);
        }

        public Iterator<CGNode> getSuccNodes(final CGNode n) {
            return new FilterIterator((Iterator)new ComposedIterator<CallSiteReference, CGNode>(n.iterateCallSites()){

                public Iterator<? extends CGNode> makeInner(CallSiteReference outer) {
                    return CHACallGraph.this.getPossibleTargets(n, outer).iterator();
                }
            }, (Predicate)new Predicate<CGNode>(){
                private final MutableIntSet nodes = IntSetUtil.make();

                @Override
                public boolean test(CGNode o) {
                    if (this.nodes.contains(o.getGraphNodeId())) {
                        return false;
                    }
                    this.nodes.add(o.getGraphNodeId());
                    return true;
                }
            });
        }

        public int getSuccNodeCount(CGNode N) {
            return IteratorUtil.count(this.getSuccNodes(N));
        }

        public void addEdge(CGNode src, CGNode dst) {
            int x = CHACallGraph.this.getNumber(src);
            int y = CHACallGraph.this.getNumber(dst);
            this.predecessors.add(y, x);
        }

        public void removeEdge(CGNode src, CGNode dst) throws UnsupportedOperationException {
            assert (false);
        }

        public void removeAllIncidentEdges(CGNode node) throws UnsupportedOperationException {
            assert (false);
        }

        public void removeIncomingEdges(CGNode node) throws UnsupportedOperationException {
            assert (false);
        }

        public void removeOutgoingEdges(CGNode node) throws UnsupportedOperationException {
            assert (false);
        }

        public boolean hasEdge(CGNode src, CGNode dst) {
            return CHACallGraph.this.getPossibleSites(src, dst).hasNext();
        }

        public IntSet getSuccNodeNumbers(CGNode node) {
            MutableIntSet result = IntSetUtil.make();
            for (CGNode s : Iterator2Iterable.make(this.getSuccNodes(node))) {
                result.add(s.getGraphNodeId());
            }
            return result;
        }
    }

    private class CHARootNode
    extends CHANode {
        private final Set<CallSiteReference> calls;

        protected CHARootNode(IMethod method, Context C) {
            super(method, C);
            this.calls = HashSetFactory.make();
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites() {
            return this.calls.iterator();
        }

        @Override
        public boolean addTarget(CallSiteReference reference, CGNode target) {
            return this.calls.add(reference);
        }
    }

    private class CHANode
    extends BasicCallGraph.NodeImpl {
        protected CHANode(IMethod method, Context C) {
            super(method, C);
        }

        @Override
        public IR getIR() {
            return CHACallGraph.this.cache.getIR(this.method);
        }

        @Override
        public DefUse getDU() {
            return CHACallGraph.this.cache.getDefUse(CHACallGraph.this.cache.getIR(this.method));
        }

        @Override
        public Iterator<NewSiteReference> iterateNewSites() {
            return ((CHAContextInterpreter)CHACallGraph.this.getInterpreter(this)).iterateNewSites(this);
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites() {
            return ((CHAContextInterpreter)CHACallGraph.this.getInterpreter(this)).iterateCallSites(this);
        }

        @Override
        public boolean equals(Object obj) {
            return obj.getClass() == this.getClass() && this.getMethod().equals(((CHANode)obj).getMethod());
        }

        @Override
        public int hashCode() {
            return this.getMethod().hashCode();
        }

        @Override
        public boolean addTarget(CallSiteReference reference, CGNode target) {
            return false;
        }
    }
}

