/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.core.util.CancelRuntimeException;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.modref.GenReach;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public class CallGraphTransitiveClosure {
    public static <T> Map<CGNode, OrdinalSet<T>> transitiveClosure(CallGraph cg, Map<CGNode, Collection<T>> nodeResults) {
        try {
            GenReach<CGNode, T> gr = new GenReach<CGNode, T>((Graph<CGNode>)GraphInverter.invert((NumberedGraph)cg), nodeResults);
            BitVectorSolver solver = new BitVectorSolver(gr);
            solver.solve(null);
            HashMap result = HashMapFactory.make();
            Iterator iterator = cg.iterator();
            while (iterator.hasNext()) {
                CGNode n = (CGNode)iterator.next();
                BitVectorVariable bv = (BitVectorVariable)solver.getOut((Object)n);
                result.put(n, new OrdinalSet(bv.getValue(), gr.getLatticeValues()));
            }
            return result;
        }
        catch (CancelException e) {
            throw new CancelRuntimeException((Exception)((Object)e));
        }
    }

    public static <T> Map<CGNode, Collection<T>> collectNodeResults(CallGraph cg, Function<CGNode, Collection<T>> nodeResultComputer) {
        HashMap result = HashMapFactory.make();
        Iterator iterator = cg.iterator();
        while (iterator.hasNext()) {
            CGNode n = (CGNode)iterator.next();
            result.put(n, nodeResultComputer.apply(n));
        }
        return result;
    }
}

