/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CallGraphStats {
    public static CGStats getCGStats(CallGraph cg) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Set reachableNodes = DFS.getReachableNodes((Graph)cg, Collections.singleton(cg.getFakeRootNode()));
        int nNodes = 0;
        int nEdges = 0;
        for (CGNode n : reachableNodes) {
            ++nNodes;
            nEdges += cg.getSuccNodeCount(n);
        }
        return new CGStats(nNodes, nEdges, CallGraphStats.collectMethods(cg).size(), CallGraphStats.countBytecodeBytes(cg));
    }

    public static String getStats(CallGraph cg) {
        return CallGraphStats.getCGStats(cg).toString();
    }

    public static int countBytecodeBytes(CallGraph cg) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        int ret = 0;
        HashSet counted = HashSetFactory.make();
        Iterator iterator = cg.iterator();
        while (iterator.hasNext()) {
            byte[] bytecodes;
            CGNode node = (CGNode)iterator.next();
            IMethod method = node.getMethod();
            if (!counted.add(method) || !(method instanceof ShrikeCTMethod) || (bytecodes = ((ShrikeCTMethod)method).getBytecodes()) == null) continue;
            ret += bytecodes.length;
        }
        return ret;
    }

    public static Set<MethodReference> collectMethods(CallGraph cg) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        HashSet result = HashSetFactory.make();
        Iterator iterator = cg.iterator();
        while (iterator.hasNext()) {
            CGNode N = (CGNode)iterator.next();
            result.add(N.getMethod().getReference());
        }
        return result;
    }

    public static class CGStats {
        private final int nNodes;
        private final int nEdges;
        private final int nMethods;
        private final int bytecodeBytes;

        private CGStats(int nodes, int edges, int methods, int bytecodeBytes) {
            this.nNodes = nodes;
            this.nEdges = edges;
            this.nMethods = methods;
            this.bytecodeBytes = bytecodeBytes;
        }

        public int getNNodes() {
            return this.nNodes;
        }

        public int getNEdges() {
            return this.nEdges;
        }

        public int getNMethods() {
            return this.nMethods;
        }

        public int getBytecodeBytes() {
            return this.bytecodeBytes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bytecodeBytes;
            result = 31 * result + this.nEdges;
            result = 31 * result + this.nMethods;
            result = 31 * result + this.nNodes;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CGStats other = (CGStats)obj;
            if (this.bytecodeBytes != other.bytecodeBytes) {
                return false;
            }
            if (this.nEdges != other.nEdges) {
                return false;
            }
            if (this.nMethods != other.nMethods) {
                return false;
            }
            return this.nNodes == other.nNodes;
        }

        public String toString() {
            return "Call graph stats:\n  Nodes: " + this.nNodes + "\n  Edges: " + this.nEdges + "\n  Methods: " + this.nMethods + "\n  Bytecode Bytes: " + this.bytecodeBytes + "\n";
        }
    }
}

