/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.drivers;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.util.config.AnalysisScopeReader;
import com.ibm.wala.core.util.io.FileProvider;
import com.ibm.wala.core.viz.PDFViewUtil;
import com.ibm.wala.examples.drivers.PDFSDG;
import com.ibm.wala.examples.properties.WalaExamplesProperties;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.util.CallGraphSearchUtil;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.ParamCallee;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.SlicerUtil;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphIntegrity;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.util.io.CommandLine;
import com.ibm.wala.util.viz.DotUtil;
import com.ibm.wala.util.viz.NodeDecorator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class PDFSlice {
    private static final String PDF_FILE = "slice.pdf";

    public static void main(String[] args) throws IllegalArgumentException, CancelException, IOException {
        PDFSlice.run(args);
    }

    public static Process run(String[] args) throws IllegalArgumentException, CancelException, IOException {
        Properties p = CommandLine.parse((String[])args);
        PDFSlice.validateCommandLine(p);
        return PDFSlice.run(p.getProperty("appJar"), p.getProperty("mainClass"), p.getProperty("srcCaller"), p.getProperty("srcCallee"), PDFSlice.goBackward(p), PDFSDG.getDataDependenceOptions(p), PDFSDG.getControlDependenceOptions(p));
    }

    private static boolean goBackward(Properties p) {
        return !p.getProperty("dir", "backward").equals("forward");
    }

    public static Process run(String appJar, String mainClass, String srcCaller, String srcCallee, boolean goBackward, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions) throws IllegalArgumentException, CancelException, IOException {
        try {
            PointerAnalysis pointerAnalysis;
            AnalysisScope scope = AnalysisScopeReader.instance.makeJavaBinaryAnalysisScope(appJar, new FileProvider().getFile(CallGraphTestUtil.REGRESSION_EXCLUSIONS));
            ClassHierarchy cha = ClassHierarchyFactory.make(scope);
            Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints((IClassHierarchy)cha, mainClass);
            AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
            SSAPropagationCallGraphBuilder builder = Util.makeVanillaZeroOneCFABuilder(Language.JAVA, options, new AnalysisCacheImpl(), cha);
            CallGraph cg = builder.makeCallGraph(options, null);
            SDG<InstanceKey> sdg = new SDG<InstanceKey>(cg, builder.getPointerAnalysis(), dOptions, cOptions);
            CGNode callerNode = CallGraphSearchUtil.findMethod(cg, srcCaller);
            Statement s = SlicerUtil.findCallTo(callerNode, srcCallee);
            System.err.println("Statement: " + s);
            Collection<Statement> slice = null;
            if (goBackward) {
                pointerAnalysis = builder.getPointerAnalysis();
                slice = Slicer.computeBackwardSlice(s, cg, pointerAnalysis, dOptions, cOptions);
            } else {
                s = PDFSlice.getReturnStatementForCall(s);
                pointerAnalysis = builder.getPointerAnalysis();
                slice = Slicer.computeForwardSlice(s, cg, pointerAnalysis, dOptions, cOptions);
            }
            SlicerUtil.dumpSlice(slice);
            Graph<Statement> g = PDFSlice.pruneSDG(sdg, slice);
            PDFSlice.sanityCheck(slice, g);
            Properties p = null;
            try {
                p = WalaExamplesProperties.loadProperties();
                p.putAll((Map<?, ?>)WalaProperties.loadProperties());
            }
            catch (WalaException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            String psFile = p.getProperty("output_dir") + File.separatorChar + PDF_FILE;
            String dotExe = p.getProperty("dot_exe");
            DotUtil.dotify(g, PDFSlice.makeNodeDecorator(), (String)"temp.dt", (String)psFile, (String)dotExe);
            String gvExe = p.getProperty("pdfview_exe");
            return PDFViewUtil.launchPDFView(psFile, gvExe);
        }
        catch (WalaException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void sanityCheck(Collection<Statement> slice, Graph<Statement> g) {
        try {
            GraphIntegrity.check(g);
        }
        catch (GraphIntegrity.UnsoundGraphException e1) {
            e1.printStackTrace();
            Assertions.UNREACHABLE();
        }
        Assertions.productionAssertion((g.getNumberOfNodes() == slice.size() ? 1 : 0) != 0, (String)("panic " + g.getNumberOfNodes() + " " + slice.size()));
    }

    public static Statement getReturnStatementForCall(Statement s) {
        if (s.getKind() == Statement.Kind.NORMAL) {
            NormalStatement n = (NormalStatement)s;
            SSAInstruction st = n.getInstruction();
            if (st instanceof SSAInvokeInstruction) {
                SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)st;
                if (call.getCallSite().getDeclaredTarget().getReturnType().equals(TypeReference.Void)) {
                    throw new IllegalArgumentException("this driver computes forward slices from the return value of calls.\nMethod " + call.getCallSite().getDeclaredTarget().getSignature() + " returns void.");
                }
                return new NormalReturnCaller(s.getNode(), n.getInstructionIndex());
            }
            return s;
        }
        return s;
    }

    public static Graph<Statement> pruneSDG(SDG<InstanceKey> sdg, Collection<Statement> slice) {
        return GraphSlicer.prune(sdg, slice::contains);
    }

    public static NodeDecorator<Statement> makeNodeDecorator() {
        return s -> {
            switch (s.getKind()) {
                case HEAP_PARAM_CALLEE: 
                case HEAP_PARAM_CALLER: 
                case HEAP_RET_CALLEE: 
                case HEAP_RET_CALLER: {
                    HeapStatement h = (HeapStatement)s;
                    return s.getKind() + "\\n" + h.getNode() + "\\n" + h.getLocation();
                }
                case NORMAL: {
                    NormalStatement n = (NormalStatement)s;
                    return n.getInstruction() + "\\n" + n.getNode().getMethod().getSignature();
                }
                case PARAM_CALLEE: {
                    ParamCallee paramCallee = (ParamCallee)s;
                    return s.getKind() + " " + paramCallee.getValueNumber() + "\\n" + s.getNode().getMethod().getName();
                }
                case PARAM_CALLER: {
                    ParamCaller paramCaller = (ParamCaller)s;
                    return s.getKind() + " " + paramCaller.getValueNumber() + "\\n" + s.getNode().getMethod().getName() + "\\n" + paramCaller.getInstruction().getCallSite().getDeclaredTarget().getName();
                }
            }
            return s.toString();
        };
    }

    static void validateCommandLine(Properties p) {
        if (p.get("appJar") == null) {
            throw new UnsupportedOperationException("expected command-line to include -appJar");
        }
        if (p.get("mainClass") == null) {
            throw new UnsupportedOperationException("expected command-line to include -mainClass");
        }
        if (p.get("srcCallee") == null) {
            throw new UnsupportedOperationException("expected command-line to include -srcCallee");
        }
        if (p.get("srcCaller") == null) {
            throw new UnsupportedOperationException("expected command-line to include -srcCaller");
        }
    }
}

