/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.drivers;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.util.config.AnalysisScopeReader;
import com.ibm.wala.core.util.io.FileProvider;
import com.ibm.wala.core.viz.PDFViewUtil;
import com.ibm.wala.examples.drivers.PDFTypeHierarchy;
import com.ibm.wala.examples.properties.WalaExamplesProperties;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphStats;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.io.CommandLine;
import com.ibm.wala.util.io.FileUtil;
import com.ibm.wala.util.viz.DotUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;

public class PDFCallGraph {
    private static final String PDF_FILE = "cg.pdf";

    public static boolean isDirectory(String appJar) {
        return new File(appJar).isDirectory();
    }

    public static String findJarFiles(String[] directories) {
        HashSet result = HashSetFactory.make();
        for (String directorie : directories) {
            for (File f : FileUtil.listFiles((String)directorie, (String)".*\\.jar", (boolean)true)) {
                result.add(f.getAbsolutePath());
            }
        }
        return PDFCallGraph.composeString(result);
    }

    private static String composeString(Collection<String> s) {
        StringBuilder result = new StringBuilder();
        Iterator<String> it = s.iterator();
        for (int i = 0; i < s.size() - 1; ++i) {
            result.append(it.next());
            result.append(File.pathSeparator);
        }
        if (it.hasNext()) {
            result.append(it.next());
        }
        return result.toString();
    }

    public static void main(String[] args) throws IllegalArgumentException, CancelException {
        PDFCallGraph.run(args);
    }

    public static Process run(String[] args) throws IllegalArgumentException, CancelException {
        Properties p = CommandLine.parse((String[])args);
        PDFCallGraph.validateCommandLine(p);
        return PDFCallGraph.run(p.getProperty("appJar"), p.getProperty("exclusionFile", CallGraphTestUtil.REGRESSION_EXCLUSIONS));
    }

    public static Process run(String appJar, String exclusionFile) throws IllegalArgumentException, CancelException {
        try {
            Graph<CGNode> g = PDFCallGraph.buildPrunedCallGraph(appJar, new FileProvider().getFile(exclusionFile));
            Properties p = null;
            try {
                p = WalaExamplesProperties.loadProperties();
                p.putAll((Map<?, ?>)WalaProperties.loadProperties());
            }
            catch (WalaException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            String pdfFile = p.getProperty("output_dir") + File.separatorChar + PDF_FILE;
            String dotExe = p.getProperty("dot_exe");
            DotUtil.dotify(g, null, (String)"temp.dt", (String)pdfFile, (String)dotExe);
            String gvExe = p.getProperty("pdfview_exe");
            return PDFViewUtil.launchPDFView(pdfFile, gvExe);
        }
        catch (WalaException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Graph<CGNode> buildPrunedCallGraph(String appJar, File exclusionFile) throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = AnalysisScopeReader.instance.makeJavaBinaryAnalysisScope(appJar, exclusionFile != null ? exclusionFile : new File(CallGraphTestUtil.REGRESSION_EXCLUSIONS));
        ClassHierarchy cha = ClassHierarchyFactory.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(cha);
        AnalysisOptions options = new AnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroCFABuilder(Language.JAVA, options, new AnalysisCacheImpl(), cha);
        CallGraph cg = builder.makeCallGraph(options, null);
        System.err.println(CallGraphStats.getStats(cg));
        Graph<CGNode> g = PDFCallGraph.pruneForAppLoader(cg);
        return g;
    }

    public static Graph<CGNode> pruneForAppLoader(CallGraph g) {
        return PDFTypeHierarchy.pruneGraph(g, new ApplicationLoaderFilter());
    }

    public static void validateCommandLine(Properties p) {
        if (p.get("appJar") == null) {
            throw new UnsupportedOperationException("expected command-line to include -appJar");
        }
    }

    private static class ApplicationLoaderFilter
    implements Predicate<CGNode> {
        private ApplicationLoaderFilter() {
        }

        @Override
        public boolean test(CGNode o) {
            if (o == null) {
                return false;
            }
            return o.getMethod().getDeclaringClass().getClassLoader().getReference().equals(ClassLoaderReference.Application);
        }
    }
}

