/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.analysis.dataflow;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorFramework;
import com.ibm.wala.dataflow.graph.BitVectorIdentity;
import com.ibm.wala.dataflow.graph.BitVectorKillGen;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.analysis.ExplodedControlFlowGraph;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class IntraprocReachingDefs {
    private final ExplodedControlFlowGraph ecfg;
    private final OrdinalSetMapping<Integer> putInstrNumbering;
    private final IClassHierarchy cha;
    private final Map<IField, BitVector> staticField2DefStatements = HashMapFactory.make();
    private static final boolean VERBOSE = true;

    public IntraprocReachingDefs(ExplodedControlFlowGraph ecfg, IClassHierarchy cha) {
        this.ecfg = ecfg;
        this.cha = cha;
        this.putInstrNumbering = this.numberPutStatics();
    }

    private OrdinalSetMapping<Integer> numberPutStatics() {
        ArrayList<Integer> putInstrs = new ArrayList<Integer>();
        IR ir = this.ecfg.getIR();
        SSAInstruction[] instructions = ir.getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            SSAInstruction instruction = instructions[i];
            if (!(instruction instanceof SSAPutInstruction) || !((SSAPutInstruction)instruction).isStatic()) continue;
            SSAPutInstruction putInstr = (SSAPutInstruction)instruction;
            int instrNum = putInstrs.size();
            putInstrs.add(i);
            IField field = this.cha.resolveField(putInstr.getDeclaredField());
            assert (field != null);
            BitVector bv = this.staticField2DefStatements.get(field);
            if (bv == null) {
                bv = new BitVector();
                this.staticField2DefStatements.put(field, bv);
            }
            bv.set(instrNum);
        }
        return new ObjectArrayMapping((Object[])putInstrs.toArray(new Integer[0]));
    }

    public BitVectorSolver<IExplodedBasicBlock> analyze() {
        BitVectorSolver solver;
        block3: {
            BitVectorFramework framework = new BitVectorFramework((Graph)this.ecfg, (ITransferFunctionProvider)new TransferFunctions(), this.putInstrNumbering);
            solver = new BitVectorSolver((IKilldallFramework)framework);
            try {
                solver.solve(null);
            }
            catch (CancelException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        Iterator<IExplodedBasicBlock> iterator = this.ecfg.iterator();
        while (iterator.hasNext()) {
            IExplodedBasicBlock ebb = iterator.next();
            System.out.println(ebb);
            System.out.println(ebb.getInstruction());
            System.out.println(solver.getIn((Object)ebb));
            System.out.println(solver.getOut((Object)ebb));
        }
        return solver;
    }

    private class TransferFunctions
    implements ITransferFunctionProvider<IExplodedBasicBlock, BitVectorVariable> {
        private TransferFunctions() {
        }

        public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(IExplodedBasicBlock src, IExplodedBasicBlock dst) {
            throw new UnsupportedOperationException();
        }

        public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
            return BitVectorUnion.instance();
        }

        public UnaryOperator<BitVectorVariable> getNodeTransferFunction(IExplodedBasicBlock node) {
            SSAInstruction instruction = node.getInstruction();
            int instructionIndex = node.getFirstInstructionIndex();
            if (instruction instanceof SSAPutInstruction && ((SSAPutInstruction)instruction).isStatic()) {
                SSAPutInstruction putInstr = (SSAPutInstruction)instruction;
                IField field = IntraprocReachingDefs.this.cha.resolveField(putInstr.getDeclaredField());
                assert (field != null);
                BitVector kill = IntraprocReachingDefs.this.staticField2DefStatements.get(field);
                BitVector gen = new BitVector();
                gen.set(IntraprocReachingDefs.this.putInstrNumbering.getMappedIndex((Object)instructionIndex));
                return new BitVectorKillGen(kill, gen);
            }
            return BitVectorIdentity.instance();
        }

        public boolean hasEdgeTransferFunctions() {
            return false;
        }

        public boolean hasNodeTransferFunctions() {
            return true;
        }
    }
}

