/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.analysis.dataflow;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.dataflow.IFDS.ICFGSupergraph;
import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.dataflow.IFDS.IPartiallyBalancedFlowFunctions;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.IdentityFlowFunction;
import com.ibm.wala.dataflow.IFDS.KillEverything;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationProblem;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationSolver;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ContextSensitiveReachingDefs {
    private final IClassHierarchy cha;
    private final ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> supergraph;
    private final ReachingDefsDomain domain = new ReachingDefsDomain();

    public ContextSensitiveReachingDefs(CallGraph cg) {
        this.cha = cg.getClassHierarchy();
        this.supergraph = ICFGSupergraph.make(cg);
    }

    public TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, Pair<CGNode, Integer>> analyze() {
        TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, Pair<CGNode, Integer>> result;
        block2: {
            PartiallyBalancedTabulationSolver<BasicBlockInContext<IExplodedBasicBlock>, CGNode, Pair<CGNode, Integer>> solver = PartiallyBalancedTabulationSolver.createPartiallyBalancedTabulationSolver(new ReachingDefsProblem(), null);
            result = null;
            try {
                result = solver.solve();
            }
            catch (CancelException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    public ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> getSupergraph() {
        return this.supergraph;
    }

    public TabulationDomain<Pair<CGNode, Integer>, BasicBlockInContext<IExplodedBasicBlock>> getDomain() {
        return this.domain;
    }

    private class ReachingDefsProblem
    implements PartiallyBalancedTabulationProblem<BasicBlockInContext<IExplodedBasicBlock>, CGNode, Pair<CGNode, Integer>> {
        private final ReachingDefsFlowFunctions flowFunctions;
        private final Collection<PathEdge<BasicBlockInContext<IExplodedBasicBlock>>> initialSeeds;

        private ReachingDefsProblem() {
            this.flowFunctions = new ReachingDefsFlowFunctions(ContextSensitiveReachingDefs.this.domain);
            this.initialSeeds = this.collectInitialSeeds();
        }

        @Override
        public BasicBlockInContext<IExplodedBasicBlock> getFakeEntry(BasicBlockInContext<IExplodedBasicBlock> node) {
            CGNode cgNode = node.getNode();
            return this.getFakeEntry(cgNode);
        }

        @Override
        private BasicBlockInContext<IExplodedBasicBlock> getFakeEntry(CGNode cgNode) {
            BasicBlockInContext<IExplodedBasicBlock>[] entriesForProcedure = ContextSensitiveReachingDefs.this.supergraph.getEntriesForProcedure(cgNode);
            assert (entriesForProcedure.length == 1);
            return entriesForProcedure[0];
        }

        private Collection<PathEdge<BasicBlockInContext<IExplodedBasicBlock>>> collectInitialSeeds() {
            HashSet result = HashSetFactory.make();
            Iterator iterator = ContextSensitiveReachingDefs.this.supergraph.iterator();
            while (iterator.hasNext()) {
                SSAPutInstruction putInstr;
                BasicBlockInContext bb = (BasicBlockInContext)iterator.next();
                IExplodedBasicBlock ebb = (IExplodedBasicBlock)bb.getDelegate();
                SSAInstruction instruction = ebb.getInstruction();
                if (!(instruction instanceof SSAPutInstruction) || !(putInstr = (SSAPutInstruction)instruction).isStatic()) continue;
                CGNode cgNode = bb.getNode();
                Pair fact = Pair.make((Object)cgNode, (Object)ebb.getFirstInstructionIndex());
                int factNum = ContextSensitiveReachingDefs.this.domain.add(fact);
                BasicBlockInContext<IExplodedBasicBlock> fakeEntry = this.getFakeEntry(cgNode);
                result.add(PathEdge.createPathEdge(fakeEntry, factNum, bb, factNum));
            }
            return result;
        }

        @Override
        public IPartiallyBalancedFlowFunctions<BasicBlockInContext<IExplodedBasicBlock>> getFunctionMap() {
            return this.flowFunctions;
        }

        @Override
        public TabulationDomain<Pair<CGNode, Integer>, BasicBlockInContext<IExplodedBasicBlock>> getDomain() {
            return ContextSensitiveReachingDefs.this.domain;
        }

        @Override
        public IMergeFunction getMergeFunction() {
            return null;
        }

        @Override
        public ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> getSupergraph() {
            return ContextSensitiveReachingDefs.this.supergraph;
        }

        @Override
        public Collection<PathEdge<BasicBlockInContext<IExplodedBasicBlock>>> initialSeeds() {
            return this.initialSeeds;
        }
    }

    private class ReachingDefsFlowFunctions
    implements IPartiallyBalancedFlowFunctions<BasicBlockInContext<IExplodedBasicBlock>> {
        private final ReachingDefsDomain domain;

        protected ReachingDefsFlowFunctions(ReachingDefsDomain domain) {
            this.domain = domain;
        }

        @Override
        public IFlowFunction getUnbalancedReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
            return IdentityFlowFunction.identity();
        }

        @Override
        public IUnaryFlowFunction getCallFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest, BasicBlockInContext<IExplodedBasicBlock> ret) {
            return IdentityFlowFunction.identity();
        }

        @Override
        public IUnaryFlowFunction getCallNoneToReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
            return IdentityFlowFunction.identity();
        }

        @Override
        public IUnaryFlowFunction getCallToReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
            return KillEverything.singleton();
        }

        @Override
        public IUnaryFlowFunction getNormalFlowFunction(final BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
            SSAPutInstruction putInstr;
            final IExplodedBasicBlock ebb = src.getDelegate();
            SSAInstruction instruction = ebb.getInstruction();
            if (instruction instanceof SSAPutInstruction && (putInstr = (SSAPutInstruction)instruction).isStatic()) {
                return new IUnaryFlowFunction(){

                    @Override
                    public IntSet getTargets(int d1) {
                        int factNum = ReachingDefsFlowFunctions.this.domain.getMappedIndex(Pair.make((Object)src.getNode(), (Object)ebb.getFirstInstructionIndex()));
                        assert (factNum != -1);
                        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
                        result.add(factNum);
                        if (d1 != factNum) {
                            IField staticField = ContextSensitiveReachingDefs.this.cha.resolveField(putInstr.getDeclaredField());
                            assert (staticField != null);
                            Pair otherPutInstrAndNode = (Pair)ReachingDefsFlowFunctions.this.domain.getMappedObject(d1);
                            SSAPutInstruction otherPutInstr = (SSAPutInstruction)((CGNode)otherPutInstrAndNode.fst).getIR().getInstructions()[(Integer)otherPutInstrAndNode.snd];
                            IField otherStaticField = ContextSensitiveReachingDefs.this.cha.resolveField(otherPutInstr.getDeclaredField());
                            if (!staticField.equals(otherStaticField)) {
                                result.add(d1);
                            }
                        }
                        return result;
                    }

                    public String toString() {
                        return "Reaching Defs Normal Flow";
                    }
                };
            }
            return IdentityFlowFunction.identity();
        }

        @Override
        public IFlowFunction getReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> call, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
            return IdentityFlowFunction.identity();
        }
    }

    private static class ReachingDefsDomain
    extends MutableMapping<Pair<CGNode, Integer>>
    implements TabulationDomain<Pair<CGNode, Integer>, BasicBlockInContext<IExplodedBasicBlock>> {
        private static final long serialVersionUID = 4014252274660361965L;

        private ReachingDefsDomain() {
        }

        @Override
        public boolean hasPriorityOver(PathEdge<BasicBlockInContext<IExplodedBasicBlock>> p1, PathEdge<BasicBlockInContext<IExplodedBasicBlock>> p2) {
            return false;
        }
    }
}

