/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.analysis.dataflow;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorFramework;
import com.ibm.wala.dataflow.graph.BitVectorIdentity;
import com.ibm.wala.dataflow.graph.BitVectorKillAll;
import com.ibm.wala.dataflow.graph.BitVectorKillGen;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cfg.ExplodedInterproceduralCFG;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ContextInsensitiveReachingDefs {
    private final ExplodedInterproceduralCFG icfg;
    private final OrdinalSetMapping<Pair<CGNode, Integer>> putInstrNumbering;
    private final IClassHierarchy cha;
    private final Map<IField, BitVector> staticField2DefStatements = HashMapFactory.make();
    private static final boolean VERBOSE = true;

    public ContextInsensitiveReachingDefs(ExplodedInterproceduralCFG icfg, IClassHierarchy cha) {
        this.icfg = icfg;
        this.cha = cha;
        this.putInstrNumbering = this.numberPutStatics();
    }

    private OrdinalSetMapping<Pair<CGNode, Integer>> numberPutStatics() {
        ArrayList<Pair> putInstrs = new ArrayList<Pair>();
        Iterator iterator = this.icfg.getCallGraph().iterator();
        while (iterator.hasNext()) {
            CGNode node = (CGNode)iterator.next();
            IR ir = node.getIR();
            if (ir == null) continue;
            SSAInstruction[] instructions = ir.getInstructions();
            for (int i = 0; i < instructions.length; ++i) {
                SSAInstruction instruction = instructions[i];
                if (!(instruction instanceof SSAPutInstruction) || !((SSAPutInstruction)instruction).isStatic()) continue;
                SSAPutInstruction putInstr = (SSAPutInstruction)instruction;
                int instrNum = putInstrs.size();
                putInstrs.add(Pair.make((Object)node, (Object)i));
                IField field = this.cha.resolveField(putInstr.getDeclaredField());
                assert (field != null);
                BitVector bv = this.staticField2DefStatements.get(field);
                if (bv == null) {
                    bv = new BitVector();
                    this.staticField2DefStatements.put(field, bv);
                }
                bv.set(instrNum);
            }
        }
        ObjectArrayMapping result = new ObjectArrayMapping((Object[])putInstrs.toArray(new Pair[0]));
        return result;
    }

    public BitVectorSolver<BasicBlockInContext<IExplodedBasicBlock>> analyze() {
        BitVectorSolver solver;
        block3: {
            BitVectorFramework framework = new BitVectorFramework((Graph)this.icfg, (ITransferFunctionProvider)new TransferFunctions(), this.putInstrNumbering);
            solver = new BitVectorSolver((IKilldallFramework)framework);
            try {
                solver.solve(null);
            }
            catch (CancelException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        Iterator iterator = this.icfg.iterator();
        while (iterator.hasNext()) {
            BasicBlockInContext ebb = iterator.next();
            System.out.println(ebb);
            System.out.println(((IExplodedBasicBlock)ebb.getDelegate()).getInstruction());
            System.out.println(solver.getIn(ebb));
            System.out.println(solver.getOut(ebb));
        }
        return solver;
    }

    public Pair<CGNode, Integer> getNodeAndInstrForNumber(int num) {
        return (Pair)this.putInstrNumbering.getMappedObject(num);
    }

    private class TransferFunctions
    implements ITransferFunctionProvider<BasicBlockInContext<IExplodedBasicBlock>, BitVectorVariable> {
        private TransferFunctions() {
        }

        public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
            return BitVectorUnion.instance();
        }

        public UnaryOperator<BitVectorVariable> getNodeTransferFunction(BasicBlockInContext<IExplodedBasicBlock> node) {
            IExplodedBasicBlock ebb = node.getDelegate();
            SSAInstruction instruction = ebb.getInstruction();
            int instructionIndex = ebb.getFirstInstructionIndex();
            CGNode cgNode = node.getNode();
            if (instruction instanceof SSAPutInstruction && ((SSAPutInstruction)instruction).isStatic()) {
                SSAPutInstruction putInstr = (SSAPutInstruction)instruction;
                IField field = ContextInsensitiveReachingDefs.this.cha.resolveField(putInstr.getDeclaredField());
                assert (field != null);
                BitVector kill = ContextInsensitiveReachingDefs.this.staticField2DefStatements.get(field);
                BitVector gen = new BitVector();
                gen.set(ContextInsensitiveReachingDefs.this.putInstrNumbering.getMappedIndex((Object)Pair.make((Object)cgNode, (Object)instructionIndex)));
                return new BitVectorKillGen(kill, gen);
            }
            return BitVectorIdentity.instance();
        }

        public boolean hasEdgeTransferFunctions() {
            return true;
        }

        public boolean hasNodeTransferFunctions() {
            return true;
        }

        public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dst) {
            if (this.isCallToReturnEdge(src, dst)) {
                return BitVectorKillAll.instance();
            }
            return BitVectorIdentity.instance();
        }

        private boolean isCallToReturnEdge(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dst) {
            SSAInstruction srcInst = src.getDelegate().getInstruction();
            return srcInst instanceof SSAAbstractInvokeInstruction && src.getNode().equals(dst.getNode());
        }
    }
}

