/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

public final class PathEdge<T> {
    final T entry;
    final int d1;
    final T target;
    final int d2;

    public static <T> PathEdge<T> createPathEdge(T s_p, int d1, T n, int d2) {
        if (s_p == null) {
            throw new IllegalArgumentException("null s_p");
        }
        if (n == null) {
            throw new IllegalArgumentException("null n");
        }
        return new PathEdge<T>(s_p, d1, n, d2);
    }

    private PathEdge(T s_p, int d1, T n, int d2) {
        this.entry = s_p;
        this.d1 = d1;
        this.target = n;
        this.d2 = d2;
    }

    public String toString() {
        return "<" + this.entry.toString() + "," + this.d1 + "> -> <" + this.target + "," + this.d2 + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.d1;
        result = 31 * result + this.d2;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathEdge other = (PathEdge)obj;
        if (this.d1 != other.d1) {
            return false;
        }
        if (this.d2 != other.d2) {
            return false;
        }
        if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
            return false;
        }
        return !(this.entry == null ? other.entry != null : !this.entry.equals(other.entry));
    }

    public int getD1() {
        return this.d1;
    }

    public int getD2() {
        return this.d2;
    }

    public T getEntry() {
        return this.entry;
    }

    public T getTarget() {
        return this.target;
    }
}

