/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Iterator;

public class LocalPathEdges {
    private static final boolean PARANOID = false;
    private final SparseVector<IBinaryNaturalRelation> paths = new SparseVector(1, 1.1f);
    private final SparseVector<IBinaryNaturalRelation> altPaths;
    private final SparseVector<IntSet> identityPaths = new SparseVector(1, 1.1f);
    private final SparseVector<IntSet> zeroPaths = new SparseVector(1, 1.1f);

    public LocalPathEdges(boolean fastMerge) {
        this.altPaths = fastMerge ? new SparseVector(1, 1.1f) : null;
    }

    public void addPathEdge(int i, int n, int j) {
        if (i == 0) {
            this.addZeroPathEdge(n, j);
        } else if (i == j) {
            this.addIdentityPathEdge(i, n);
        } else {
            IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.paths.get(j);
            if (R == null) {
                R = new BasicNaturalRelation(new byte[]{2}, 1);
                this.paths.set(j, (Object)R);
            }
            R.add(n, i);
            if (this.altPaths != null) {
                IBinaryNaturalRelation R2 = (IBinaryNaturalRelation)this.altPaths.get(i);
                if (R2 == null) {
                    R2 = new BasicNaturalRelation(new byte[]{2}, 1);
                    this.altPaths.set(i, (Object)R2);
                }
                R2.add(n, j);
            }
        }
    }

    private void addIdentityPathEdge(int i, int n) {
        BitVectorIntSet s = (BitVectorIntSet)this.identityPaths.get(i);
        if (s == null) {
            s = new BitVectorIntSet();
            this.identityPaths.set(i, (Object)s);
        }
        s.add(n);
        if (this.altPaths != null) {
            IBinaryNaturalRelation R2 = (IBinaryNaturalRelation)this.altPaths.get(i);
            if (R2 == null) {
                R2 = new BasicNaturalRelation(new byte[]{2}, 1);
                this.altPaths.set(i, (Object)R2);
            }
            R2.add(n, i);
        }
    }

    private void addZeroPathEdge(int n, int j) {
        BitVectorIntSet z = (BitVectorIntSet)this.zeroPaths.get(j);
        if (z == null) {
            z = new BitVectorIntSet();
            this.zeroPaths.set(j, (Object)z);
        }
        z.add(n);
        if (this.altPaths != null) {
            IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.altPaths.get(0);
            if (R == null) {
                R = new BasicNaturalRelation(new byte[]{2}, 1);
                this.altPaths.set(0, (Object)R);
            }
            R.add(n, j);
        }
    }

    public IntSet getInverse(int n, int d2) {
        IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.paths.get(d2);
        BitVectorIntSet s = (BitVectorIntSet)this.identityPaths.get(d2);
        BitVectorIntSet z = (BitVectorIntSet)this.zeroPaths.get(d2);
        if (R == null) {
            if (s == null) {
                if (z == null) {
                    return null;
                }
                return z.contains(n) ? SparseIntSet.singleton((int)0) : null;
            }
            if (s.contains(n)) {
                if (z == null) {
                    return SparseIntSet.singleton((int)d2);
                }
                return z.contains(n) ? SparseIntSet.pair((int)0, (int)d2) : SparseIntSet.singleton((int)d2);
            }
            return null;
        }
        if (s == null) {
            if (z == null) {
                return R.getRelated(n);
            }
            if (z.contains(n)) {
                IntSet related = R.getRelated(n);
                if (related == null) {
                    return SparseIntSet.singleton((int)0);
                }
                MutableSparseIntSet result = MutableSparseIntSet.make((IntSet)related);
                result.add(0);
                return result;
            }
            return R.getRelated(n);
        }
        if (s.contains(n)) {
            IntSet related = R.getRelated(n);
            if (related == null) {
                if (z == null || !z.contains(n)) {
                    return SparseIntSet.singleton((int)d2);
                }
                return SparseIntSet.pair((int)0, (int)d2);
            }
            MutableSparseIntSet result = MutableSparseIntSet.make((IntSet)related);
            result.add(d2);
            if (z != null && z.contains(n)) {
                result.add(0);
            }
            return result;
        }
        if (z == null || !z.contains(n)) {
            return R.getRelated(n);
        }
        IntSet related = R.getRelated(n);
        MutableSparseIntSet result = related == null ? MutableSparseIntSet.makeEmpty() : MutableSparseIntSet.make((IntSet)related);
        result.add(0);
        return result;
    }

    public boolean contains(int i, int n, int j) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid n: " + n);
        }
        if (i == 0) {
            BitVectorIntSet z = (BitVectorIntSet)this.zeroPaths.get(j);
            return z != null && z.contains(n);
        }
        if (i == j) {
            BitVectorIntSet s = (BitVectorIntSet)this.identityPaths.get(i);
            return s != null && s.contains(n);
        }
        IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.paths.get(j);
        if (R == null) {
            return false;
        }
        return R.contains(n, i);
    }

    public IntSet getReachable(int n, int d1) {
        return this.altPaths == null ? this.getReachableSlow(n, d1) : this.getReachableFast(n, d1);
    }

    private IntSet getReachableSlow(int n, int d1) {
        BitVectorIntSet s;
        int d2;
        IntIterator it;
        Iterator contents;
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        if (this.paths.size() > 0) {
            contents = this.paths.iterator();
            it = this.paths.iterateIndices();
            while (it.hasNext()) {
                d2 = it.next();
                IBinaryNaturalRelation R = (IBinaryNaturalRelation)contents.next();
                if (R == null || !R.contains(n, d1)) continue;
                result.add(d2);
            }
        }
        if (this.identityPaths.size() > 0 && (s = (BitVectorIntSet)this.identityPaths.get(d1)) != null && s.contains(n)) {
            result.add(d1);
        }
        if (d1 == 0 && this.zeroPaths.size() > 0) {
            contents = this.zeroPaths.iterator();
            it = this.zeroPaths.iterateIndices();
            while (it.hasNext()) {
                d2 = it.next();
                IntSet s2 = (IntSet)contents.next();
                if (s2 == null || !s2.contains(n)) continue;
                result.add(d2);
            }
        }
        return result;
    }

    private IntSet getReachableFast(int n, int d1) {
        IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.altPaths.get(d1);
        if (R != null) {
            return R.getRelated(n);
        }
        return null;
    }

    public IntSet getReachable(int n) {
        IntSet s;
        int d2;
        IntIterator it;
        Iterator contents;
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        if (this.paths.size() > 0) {
            contents = this.paths.iterator();
            it = this.paths.iterateIndices();
            while (it.hasNext()) {
                d2 = it.next();
                IBinaryNaturalRelation R = (IBinaryNaturalRelation)contents.next();
                if (R == null || !R.anyRelated(n)) continue;
                result.add(d2);
            }
        }
        if (this.identityPaths.size() > 0) {
            contents = this.identityPaths.iterator();
            it = this.identityPaths.iterateIndices();
            while (it.hasNext()) {
                int d1 = it.next();
                s = (IntSet)contents.next();
                if (s == null || !s.contains(n)) continue;
                result.add(d1);
            }
        }
        if (this.zeroPaths.size() > 0) {
            contents = this.zeroPaths.iterator();
            it = this.zeroPaths.iterateIndices();
            while (it.hasNext()) {
                d2 = it.next();
                s = (IntSet)contents.next();
                if (s == null || !s.contains(n)) continue;
                result.add(d2);
            }
        }
        return result;
    }

    public IntSet getReachedNodeNumbers() {
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        if (this.paths.size() > 0) {
            for (IBinaryNaturalRelation R : this.paths) {
                for (IntPair p : R) {
                    result.add(p.getX());
                }
            }
        }
        if (this.identityPaths.size() > 0) {
            for (IntSet s : this.identityPaths) {
                result.addAll(s);
            }
        }
        if (this.zeroPaths.size() > 0) {
            for (IntSet s : this.zeroPaths) {
                result.addAll(s);
            }
        }
        return result;
    }
}

