/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.viz.viewer;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.collections.HashMapFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IrViewer
extends JPanel {
    private static final long serialVersionUID = -5668847442988389016L;
    private final JTextField methodName;
    private final DefaultListModel<String> irLineList = new DefaultListModel();
    private final JList<String> irLines;
    private Map<Integer, Integer> lineToPosition = null;
    private Map<Integer, Integer> pcToLine = null;
    private Map<Integer, Integer> lineToPc = null;
    Set<SelectedPcListner> selectedPcListners = new HashSet<SelectedPcListner>();
    static final int NA = -1;

    public IrViewer() {
        super(new BorderLayout());
        this.irLines = new JList<String>(this.irLineList);
        this.methodName = new JTextField("IR");
        this.add((Component)this.methodName, "First");
        this.add((Component)new JScrollPane(this.irLines, 20, 30), "Center");
        this.irLines.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = IrViewer.this.irLines.getSelectedIndex();
                Integer pc = IrViewer.this.lineToPc.get(index);
                if (pc == null) {
                    pc = -1;
                }
                for (SelectedPcListner selectedPcListner : IrViewer.this.selectedPcListners) {
                    selectedPcListner.valueChanged(pc);
                }
            }
        });
    }

    public void setIR(IR ir) {
        int firstLineWithPosition;
        block8: {
            this.lineToPosition = HashMapFactory.make();
            this.pcToLine = HashMapFactory.make();
            this.lineToPc = HashMapFactory.make();
            firstLineWithPosition = -1;
            try {
                String line;
                this.methodName.setText("IR: " + ir.getMethod());
                this.irLineList.clear();
                BufferedReader br = new BufferedReader(new StringReader(ir.toString()));
                int lineNum = 0;
                int position = -1;
                while ((line = br.readLine()) != null) {
                    this.irLineList.addElement(line);
                    int pc = IrViewer.parseIrLine(line);
                    if (pc != -1) {
                        IMethod m = ir.getMethod();
                        int newPosition = m.getLineNumber(pc);
                        if (newPosition != -1) {
                            position = newPosition;
                        }
                        this.lineToPc.put(lineNum, pc);
                        this.pcToLine.put(pc, lineNum);
                        if (position != -1) {
                            this.lineToPosition.put(lineNum, position);
                            if (firstLineWithPosition == -1) {
                                firstLineWithPosition = lineNum;
                            }
                        }
                    }
                    ++lineNum;
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        if (firstLineWithPosition != -1) {
            this.irLines.setSelectedIndex(firstLineWithPosition);
            this.irLines.ensureIndexIsVisible(firstLineWithPosition);
        }
    }

    private static int parseIrLine(String line) {
        int firstSpace = line.indexOf(32);
        if (firstSpace > 0) {
            String pcString = line.substring(0, firstSpace);
            try {
                return Integer.parseInt(pcString);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public void addSelectedPcListner(SelectedPcListner selectedPcListner) {
        this.selectedPcListners.add(selectedPcListner);
    }

    public void setPc(int pc) {
        Integer lineNum = this.pcToLine.get(pc);
        if (lineNum != null) {
            this.irLines.ensureIndexIsVisible(lineNum);
            this.irLines.setSelectedIndex(lineNum);
        } else {
            this.removeSelection();
        }
    }

    public void setIRAndPc(IR ir, int pc) {
        this.setIR(ir);
        if (pc != -1) {
            this.setPc(pc);
        } else {
            this.removeSelection();
        }
    }

    private void removeSelection() {
        int curSelectedIndex = this.irLines.getSelectedIndex();
        this.irLines.removeSelectionInterval(curSelectedIndex, curSelectedIndex);
    }

    public static interface SelectedPcListner {
        public void valueChanged(int var1);
    }
}

