/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.util.strings;

import com.ibm.wala.core.util.strings.UTF8Convert;

public final class ImmutableByteArray {
    final byte[] b;

    public ImmutableByteArray(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        this.b = b;
    }

    public ImmutableByteArray(byte[] b, int start, int length) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (start < 0) {
            throw new IllegalArgumentException("invalid start: " + start);
        }
        if (length < 0) {
            throw new IllegalArgumentException("null length");
        }
        this.b = new byte[length];
        try {
            System.arraycopy(b, start, this.b, 0, length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("illegal parameters " + b.length + " " + start + " " + length, e);
        }
    }

    public int length() {
        return this.b.length;
    }

    public byte get(int i) throws IllegalArgumentException {
        if (i < 0 || i >= this.b.length) {
            throw new IllegalArgumentException("index out of bounds " + this.b.length + " " + i);
        }
        return this.b[i];
    }

    public byte[] substring(int i, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("illegal length: " + length);
        }
        if (i < 0) {
            throw new IllegalArgumentException("illegal i: " + i);
        }
        byte[] result = new byte[length];
        try {
            System.arraycopy(this.b, i, result, 0, length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid combination: " + i + " " + length, e);
        }
        return result;
    }

    public static ImmutableByteArray concat(byte b, ImmutableByteArray b1) {
        if (b1 == null) {
            throw new IllegalArgumentException("b1 is null");
        }
        byte[] arr = new byte[b1.length() + 1];
        arr[0] = b;
        System.arraycopy(b1.b, 0, arr, 1, b1.b.length);
        return new ImmutableByteArray(arr);
    }

    public String toString() {
        return new String(this.b);
    }

    public static ImmutableByteArray make(String s) {
        return new ImmutableByteArray(UTF8Convert.toUTF8(s));
    }
}

