/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.util.ssa;

import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;

public class SSAValue {
    protected final int number;
    protected final TypeReference type;
    public final VariableKey key;
    protected final MethodReference mRef;
    private boolean isAssigned;

    public SSAValue(int number, TypeReference type, MethodReference validIn, VariableKey key) {
        if (number < 0) {
            throw new IllegalArgumentException("A SSA-Value can't have a negative number, " + number + "given");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type for the SSA-Variable may not be null");
        }
        if (type.equals(TypeReference.Void)) {
            throw new IllegalArgumentException("You can't create a SSA-Variable of type void");
        }
        this.type = type;
        this.number = number;
        this.key = key;
        this.mRef = validIn;
        this.isAssigned = false;
    }

    public SSAValue(int number, TypeReference type, MethodReference validIn, String variableName) {
        this(number, type, validIn, variableName == null ? new TypeKey(type.getName()) : new NamedKey(type.getName(), variableName));
    }

    public SSAValue(int number, TypeReference type, MethodReference validIn) {
        this(number, type, validIn, new UniqueKey());
    }

    public SSAValue(int number, SSAValue copyFrom) {
        this(number, copyFrom.type, copyFrom.mRef, copyFrom.key);
    }

    public int getNumber() {
        return this.number;
    }

    public TypeReference getType() {
        return this.type;
    }

    public boolean isAssigned() {
        return this.isAssigned;
    }

    public void setAssigned() {
        if (this.isAssigned) {
            throw new IllegalStateException("The SSA-Variable " + this + " was assigned to twice.");
        }
        this.isAssigned = true;
    }

    public MethodReference getValidIn() {
        return this.mRef;
    }

    public String getVariableName() {
        if (this.key instanceof NamedKey) {
            return ((NamedKey)this.key).name;
        }
        return null;
    }

    public String toString() {
        return "<SSAValue " + this.number + " type=" + this.type + " validIn=" + this.mRef + ">";
    }

    public boolean equals(Object o) {
        if (o instanceof SSAValue) {
            SSAValue other = (SSAValue)o;
            return this.number == other.number && this.mRef.equals(other.mRef) && this.type.equals(other.type);
        }
        throw new IllegalArgumentException("Can't compare SSAValue to " + o.getClass());
    }

    public int hashCode() {
        return 157 * this.number * this.mRef.hashCode() * this.type.hashCode();
    }

    public static class NamedKey
    implements VariableKey {
        public final String name;
        public final TypeName type;

        public NamedKey(TypeName type, String name) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof NamedKey) {
                NamedKey other = (NamedKey)o;
                return this.type.equals(other.type) && this.name.equals(other.name);
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode() * (this.name == null ? 1 : this.name.hashCode());
        }

        public String toString() {
            return "<NamedKey type=\"" + this.type + "\" name=\"" + this.name + "\" />";
        }
    }

    public static class WeaklyNamedKey
    extends NamedKey {
        public WeaklyNamedKey(TypeName type, String name) {
            super(type, name);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof NamedKey) {
                NamedKey other = (NamedKey)o;
                return this.type.equals(other.type) && this.name.equals(other.name);
            }
            if (o instanceof TypeKey) {
                TypeKey other = (TypeKey)o;
                return this.type.equals(other.type);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.type.hashCode() * (this.name == null ? 1 : this.name.hashCode());
        }

        @Override
        public String toString() {
            return "<WaklyNamedKey type=\"" + this.type + "\" name=\"" + this.name + "\" />";
        }
    }

    public static class TypeKey
    implements VariableKey {
        public final TypeName type;

        public TypeKey(TypeName type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof TypeKey) {
                TypeKey other = (TypeKey)o;
                return this.type.equals(other.type);
            }
            if (o instanceof WeaklyNamedKey) {
                WeaklyNamedKey other = (WeaklyNamedKey)o;
                return this.type.equals(other.type);
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return "<TypeKey type=\"" + this.type + "\" />";
        }
    }

    public static class UniqueKey
    implements VariableKey {
    }

    public static interface VariableKey {
    }
}

