/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.util.scope;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.core.util.strings.StringStuff;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class JUnitEntryPoints {
    private static final Logger logger = Logger.getLogger(JUnitEntryPoints.class.getName());
    private static final Set<String> TEST_ENTRY_POINT_ANNOTATION_NAMES = new HashSet<String>(Arrays.asList("org.junit.After", "org.junit.AfterClass", "org.junit.Before", "org.junit.BeforeClass", "org.junit.ClassRule", "org.junit.Rule", "org.junit.Test", "org.junit.runners.Parameterized.Parameters", "org.junit.jupiter.api.AfterAll", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.Test"));

    public static Iterable<Entrypoint> make(IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        HashSet result = HashSetFactory.make();
        for (IClass klass : cha) {
            IMethod iMethod;
            IClassLoader classLoader = klass.getClassLoader();
            ClassLoaderReference reference = classLoader.getReference();
            if (!reference.equals(ClassLoaderReference.Application)) continue;
            if (JUnitEntryPoints.isJUnitTestCase(klass)) {
                Set<IMethod> setUpTearDowns;
                logger.fine(() -> "application class: " + klass);
                Collection<? extends IMethod> methods = klass.getAllMethods();
                for (IMethod iMethod2 : methods) {
                    if (!JUnitEntryPoints.isJUnitMethod(iMethod2)) continue;
                    result.add(new DefaultEntrypoint(iMethod2, cha));
                    logger.fine(() -> "- adding test method as entry point: " + m.getName().toString());
                }
                try {
                    setUpTearDowns = JUnitEntryPoints.getSetUpTearDownMethods(klass);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Can't find test method entry points using class hierarchy: " + cha, exception);
                }
                Iterator iterator = setUpTearDowns.iterator();
                while (iterator.hasNext()) {
                    IMethod m = (IMethod)iterator.next();
                    result.add(new DefaultEntrypoint(m, cha));
                }
                continue;
            }
            boolean isTestClass = false;
            for (IMethod iMethod3 : klass.getDeclaredMethods()) {
                if (!(iMethod3 instanceof ShrikeCTMethod)) continue;
                for (Annotation annotation : ((ShrikeCTMethod)iMethod3).getAnnotations()) {
                    if (!JUnitEntryPoints.isTestEntryPoint(annotation.getType().getName())) continue;
                    result.add(new DefaultEntrypoint(iMethod3, cha));
                    isTestClass = true;
                }
            }
            if (!isTestClass) continue;
            IMethod classInitializer = klass.getClassInitializer();
            if (classInitializer != null) {
                result.add(new DefaultEntrypoint(classInitializer, cha));
            }
            if ((iMethod = klass.getMethod(MethodReference.initSelector)) == null) continue;
            result.add(new DefaultEntrypoint(iMethod, cha));
        }
        return result::iterator;
    }

    private static boolean isTestEntryPoint(TypeName typeName) {
        String javaName = StringStuff.jvmToReadableType(typeName.getPackage() + "." + typeName.getClassName());
        return TEST_ENTRY_POINT_ANNOTATION_NAMES.contains(javaName);
    }

    public static Iterable<Entrypoint> makeOne(IClassHierarchy cha, String targetPackageName, String targetSimpleClassName, String targetMethodName) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        Atom targetPackageAtom = Atom.findOrCreateAsciiAtom(targetPackageName);
        Atom targetSimpleClassAtom = Atom.findOrCreateAsciiAtom(targetSimpleClassName);
        TypeName targetType = TypeName.findOrCreateClass(targetPackageAtom, targetSimpleClassAtom);
        Atom targetMethodAtom = Atom.findOrCreateAsciiAtom(targetMethodName);
        logger.finer("finding entrypoint " + targetMethodAtom + " in " + targetType);
        HashSet entryPts = HashSetFactory.make();
        for (IClass klass : cha) {
            TypeName klassType = klass.getName();
            if (!klassType.equals(targetType) || !JUnitEntryPoints.isJUnitTestCase(klass)) continue;
            logger.finer("found test class");
            for (IMethod iMethod : klass.getDeclaredMethods()) {
                Atom methodAtom = iMethod.getName();
                if (!methodAtom.equals(targetMethodAtom)) continue;
                entryPts.add(new DefaultEntrypoint(iMethod, cha));
                logger.fine(() -> "- adding entry point of the call graph: " + methodAtom);
            }
            Set<IMethod> setUpTearDowns = JUnitEntryPoints.getSetUpTearDownMethods(klass);
            for (IMethod m : setUpTearDowns) {
                entryPts.add(new DefaultEntrypoint(m, cha));
            }
        }
        return entryPts::iterator;
    }

    public static boolean isJUnitTestCase(IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        Atom junitPackage = Atom.findOrCreateAsciiAtom("junit/framework");
        Atom junitClass = Atom.findOrCreateAsciiAtom("TestCase");
        Atom junitSuite = Atom.findOrCreateAsciiAtom("TestSuite");
        TypeName junitTestCaseType = TypeName.findOrCreateClass(junitPackage, junitClass);
        TypeName junitTestSuiteType = TypeName.findOrCreateClass(junitPackage, junitSuite);
        for (IClass ancestor = klass.getSuperclass(); ancestor != null; ancestor = ancestor.getSuperclass()) {
            TypeName t = ancestor.getName();
            if (!t.equals(junitTestCaseType) && !t.equals(junitTestSuiteType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJUnitMethod(IMethod m) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (!JUnitEntryPoints.isJUnitTestCase(m.getDeclaringClass())) {
            return false;
        }
        Atom method = m.getName();
        String methodName = method.toString();
        return methodName.startsWith("test") || methodName.equals("setUp") || methodName.equals("tearDown");
    }

    public static Set<IMethod> getSetUpTearDownMethods(IClass testClass) {
        Atom junitPackage = Atom.findOrCreateAsciiAtom("junit/framework");
        Atom junitClass = Atom.findOrCreateAsciiAtom("TestCase");
        Atom junitSuite = Atom.findOrCreateAsciiAtom("TestSuite");
        TypeName junitTestCaseType = TypeName.findOrCreateClass(junitPackage, junitClass);
        TypeName junitTestSuiteType = TypeName.findOrCreateClass(junitPackage, junitSuite);
        Atom setUpMethodAtom = Atom.findOrCreateAsciiAtom("setUp");
        Atom tearDownMethodAtom = Atom.findOrCreateAsciiAtom("tearDown");
        HashSet result = HashSetFactory.make();
        for (IClass currClass = testClass; currClass != null && !currClass.getName().equals(junitTestCaseType) && !currClass.getName().equals(junitTestSuiteType); currClass = currClass.getSuperclass()) {
            for (IMethod iMethod : currClass.getDeclaredMethods()) {
                Atom methodAtom = iMethod.getName();
                if (!methodAtom.equals(setUpMethodAtom) && !methodAtom.equals(tearDownMethodAtom) && !iMethod.isClinit() && !iMethod.isInit()) continue;
                result.add(iMethod);
            }
        }
        return result;
    }
}

