/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.util.ref;

import com.ibm.wala.util.debug.Assertions;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public final class CacheReference {
    private static final byte SOFT = 0;
    private static final byte WEAK = 1;
    private static final byte HARD = 2;
    private static final byte choice = 0;

    public static Object make(Object referent) {
        switch (0) {
            case 0: {
                return new SoftReference<Object>(referent);
            }
            case 1: {
                return new WeakReference<Object>(referent);
            }
            case 2: {
                return referent;
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public static Object get(Object reference) throws IllegalArgumentException {
        if (reference == null) {
            return null;
        }
        switch (0) {
            case 0: {
                if (!(reference instanceof SoftReference)) {
                    throw new IllegalArgumentException("not ( reference instanceof java.lang.ref.SoftReference ) ");
                }
                return ((SoftReference)reference).get();
            }
            case 1: {
                return ((WeakReference)reference).get();
            }
            case 2: {
                return reference;
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }
}

