/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.util.config;

import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.ClassFileURLModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.core.util.io.FileProvider;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.jar.JarFile;

public class AnalysisScopeReader {
    public static AnalysisScopeReader instance = new AnalysisScopeReader();
    protected final ClassLoader MY_CLASSLOADER;
    protected final String BASIC_FILE;

    protected static void setScopeReader(AnalysisScopeReader reader) {
        instance = reader;
    }

    protected AnalysisScopeReader() {
        this(AnalysisScopeReader.class.getClassLoader(), "primordial.txt");
    }

    protected AnalysisScopeReader(ClassLoader myLoader, String basicFile) {
        this.MY_CLASSLOADER = myLoader;
        this.BASIC_FILE = basicFile;
    }

    public AnalysisScope readJavaScope(String scopeFileName, File exclusionsFile, ClassLoader javaLoader) throws IOException {
        AnalysisScope scope = AnalysisScope.createJavaAnalysisScope();
        return this.read(scope, scopeFileName, exclusionsFile, javaLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisScope read(AnalysisScope scope, String scopeFileName, File exclusionsFile, ClassLoader javaLoader) throws IOException {
        block18: {
            BufferedReader r = null;
            try {
                String line;
                File scopeFile = new File(scopeFileName);
                if (scopeFile.exists()) {
                    r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(scopeFile), "UTF-8"));
                } else {
                    InputStream inFromJar = javaLoader.getResourceAsStream(scopeFileName);
                    if (inFromJar == null) {
                        throw new IllegalArgumentException("Unable to retreive " + scopeFileName + " from the jar using " + javaLoader);
                    }
                    r = new BufferedReader(new InputStreamReader(inFromJar));
                }
                while ((line = r.readLine()) != null) {
                    this.processScopeDefLine(scope, javaLoader, line);
                }
                if (exclusionsFile == null) break block18;
                try (InputStream fs = exclusionsFile.exists() ? new FileInputStream(exclusionsFile) : FileProvider.class.getClassLoader().getResourceAsStream(exclusionsFile.getName());){
                    scope.setExclusions((SetOfClasses)new FileOfClasses(fs));
                }
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnalysisScope read(AnalysisScope scope, URI scopeFileURI, File exclusionsFile, ClassLoader javaLoader) throws IOException {
        block16: {
            BufferedReader r = null;
            try {
                String line;
                InputStream inStream = scopeFileURI.toURL().openStream();
                if (inStream == null) {
                    throw new IllegalArgumentException("Unable to retrieve URI " + scopeFileURI);
                }
                r = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                while ((line = r.readLine()) != null) {
                    this.processScopeDefLine(scope, javaLoader, line);
                }
                if (exclusionsFile == null) break block16;
                try (InputStream fs = exclusionsFile.exists() ? new FileInputStream(exclusionsFile) : FileProvider.class.getClassLoader().getResourceAsStream(exclusionsFile.getName());){
                    scope.setExclusions((SetOfClasses)new FileOfClasses(fs));
                }
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return scope;
    }

    public void processScopeDefLine(AnalysisScope scope, ClassLoader javaLoader, String line) throws IOException {
        if (line == null) {
            throw new IllegalArgumentException("null line");
        }
        StringTokenizer toks = new StringTokenizer(line, "\n,");
        if (!toks.hasMoreTokens()) {
            return;
        }
        Atom loaderName = Atom.findOrCreateUnicodeAtom(toks.nextToken());
        ClassLoaderReference walaLoader = scope.getLoader(loaderName);
        String language = toks.nextToken();
        String entryType = toks.nextToken();
        String entryPathname = toks.nextToken();
        FileProvider fp = new FileProvider();
        if ("classFile".equals(entryType)) {
            File cf = fp.getFile(entryPathname, javaLoader);
            try {
                scope.addClassFileToScope(walaLoader, cf);
            }
            catch (InvalidClassFileException e) {
                Assertions.UNREACHABLE((String)e.toString());
            }
        } else if ("classUrl".equals(entryType)) {
            URL cls = fp.getResource(entryPathname);
            assert (cls != null) : "cannot find " + entryPathname;
            try {
                scope.addToScope(walaLoader, new ClassFileURLModule(cls));
            }
            catch (InvalidClassFileException e) {
                Assertions.UNREACHABLE((String)e.toString());
            }
        } else if ("sourceFile".equals(entryType)) {
            File sf = fp.getFile(entryPathname, javaLoader);
            scope.addSourceFileToScope(walaLoader, sf, entryPathname);
        } else if ("binaryDir".equals(entryType)) {
            File bd = fp.getFile(entryPathname, javaLoader);
            assert (bd.isDirectory());
            scope.addToScope(walaLoader, new BinaryDirectoryTreeModule(bd));
        } else if ("sourceDir".equals(entryType)) {
            File sd = fp.getFile(entryPathname, javaLoader);
            assert (sd.isDirectory());
            scope.addToScope(walaLoader, new SourceDirectoryTreeModule(sd));
        } else if ("jarFile".equals(entryType)) {
            Module M = fp.getJarFileModule(entryPathname, javaLoader);
            scope.addToScope(walaLoader, M);
        } else if ("loaderImpl".equals(entryType)) {
            scope.setLoaderImpl(walaLoader, entryPathname);
        } else if ("stdlib".equals(entryType)) {
            String[] stdlibs;
            boolean justBase = entryPathname.equals("base");
            for (String stdlib : stdlibs = WalaProperties.getJDKLibraryFiles(justBase)) {
                scope.addToScope(walaLoader, new JarFile(stdlib, false));
            }
        } else if ("jdkModule".equals(entryType)) {
            scope.addJDKModuleToScope(entryPathname);
        } else if (!this.handleInSubclass(scope, walaLoader, language, entryType, entryPathname)) {
            Assertions.UNREACHABLE();
        }
    }

    protected boolean handleInSubclass(AnalysisScope scope, ClassLoaderReference walaLoader, String language, String entryType, String entryPathname) {
        return false;
    }

    public AnalysisScope makePrimordialScope(File exclusionsFile) throws IOException {
        return this.readJavaScope(this.BASIC_FILE, exclusionsFile, this.MY_CLASSLOADER);
    }

    public AnalysisScope makeBasePrimordialScope(File exclusionsFile) throws IOException {
        return this.readJavaScope("primordial-base.txt", exclusionsFile, this.MY_CLASSLOADER);
    }

    public AnalysisScope makeJavaBinaryAnalysisScope(String classPath, File exclusionsFile) throws IOException {
        if (classPath == null) {
            throw new IllegalArgumentException("classPath null");
        }
        AnalysisScope scope = this.makePrimordialScope(exclusionsFile);
        ClassLoaderReference loader = scope.getLoader(AnalysisScope.APPLICATION);
        this.addClassPathToScope(classPath, scope, loader);
        return scope;
    }

    public void addClassPathToScope(String classPath, AnalysisScope scope, ClassLoaderReference loader) {
        if (classPath == null) {
            throw new IllegalArgumentException("null classPath");
        }
        try {
            StringTokenizer paths = new StringTokenizer(classPath, File.pathSeparator);
            while (paths.hasMoreTokens()) {
                String path = paths.nextToken();
                if (path.endsWith(".jar")) {
                    JarFile jar = new JarFile(path, false);
                    scope.addToScope(loader, jar);
                    try {
                        String cp;
                        if (jar.getManifest() == null || (cp = jar.getManifest().getMainAttributes().getValue("Class-Path")) == null) continue;
                        for (String cpEntry : cp.split(" ")) {
                            this.addClassPathToScope(new File(path).getParent() + File.separator + cpEntry, scope, loader);
                        }
                        continue;
                    }
                    catch (RuntimeException e) {
                        System.err.println("warning: trouble processing class path of " + path);
                        continue;
                    }
                }
                File f = new File(path);
                if (f.isDirectory()) {
                    scope.addToScope(loader, new BinaryDirectoryTreeModule(f));
                    continue;
                }
                scope.addClassFileToScope(loader, f);
            }
        }
        catch (InvalidClassFileException | IOException e) {
            Assertions.UNREACHABLE((String)e.toString());
        }
    }
}

