/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.java11;

import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.core.util.shrike.ShrikeClassReaderHandle;
import com.ibm.wala.core.util.strings.ImmutableByteArray;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;

public class JrtModule
implements Module {
    final Path root;

    public JrtModule(String module) throws IOException {
        this.root = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap()).getPath("modules", module);
    }

    public String toString() {
        return "[module " + this.root.toString() + "]";
    }

    private Stream<? extends ModuleEntry> rec(Path pp) {
        Stream stream;
        block9: {
            JrtModule me = this;
            Stream<Path> list = Files.list(pp);
            try {
                stream = list.flatMap(s -> {
                    if (Files.isDirectory(s, new LinkOption[0])) {
                        return this.rec((Path)s);
                    }
                    return Stream.of(new ModuleEntry((Path)s, me){
                        private String className = null;
                        final /* synthetic */ Path val$s;
                        final /* synthetic */ Module val$me;
                        {
                            this.val$s = path;
                            this.val$me = module;
                        }

                        public String toString() {
                            StringBuilder sb = new StringBuilder("[");
                            if (this.isClassFile()) {
                                sb.append("class");
                            } else if (this.isSourceFile()) {
                                sb.append("source");
                            } else {
                                sb.append("file");
                            }
                            sb.append(" ").append(this.getName());
                            return sb.toString();
                        }

                        @Override
                        public String getName() {
                            return this.val$s.toString().substring(JrtModule.this.root.toString().length() + 1);
                        }

                        @Override
                        public boolean isClassFile() {
                            return this.getName().endsWith(".class");
                        }

                        @Override
                        public boolean isSourceFile() {
                            return this.getName().endsWith(".java");
                        }

                        @Override
                        public InputStream getInputStream() {
                            try {
                                return new ByteArrayInputStream(Files.readAllBytes(this.val$s));
                            }
                            catch (IOException e) {
                                assert (false) : e;
                                return null;
                            }
                        }

                        @Override
                        public boolean isModuleFile() {
                            return false;
                        }

                        @Override
                        public Module asModule() {
                            assert (false);
                            return null;
                        }

                        @Override
                        public String getClassName() {
                            block4: {
                                assert (this.isClassFile());
                                if (this.className == null) {
                                    ShrikeClassReaderHandle reader = new ShrikeClassReaderHandle(this);
                                    try {
                                        ImmutableByteArray name = ImmutableByteArray.make(reader.get().getName());
                                        this.className = name.toString();
                                    }
                                    catch (InvalidClassFileException e) {
                                        e.printStackTrace();
                                        if ($assertionsDisabled) break block4;
                                        throw new AssertionError();
                                    }
                                }
                            }
                            return this.className;
                        }

                        @Override
                        public Module getContainer() {
                            return this.val$me;
                        }
                    });
                });
                if (list == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    assert (false);
                    return null;
                }
            }
            list.close();
        }
        return stream;
    }

    @Override
    public Iterator<? extends ModuleEntry> getEntries() {
        return this.rec(this.root).iterator();
    }
}

