/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.DirectoryTreeModule;
import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.classLoader.SourceFileModule;
import java.io.File;

public class SourceDirectoryTreeModule
extends DirectoryTreeModule {
    String fileExt = "java";

    public SourceDirectoryTreeModule(File root) {
        super(root);
    }

    public SourceDirectoryTreeModule(File root, String fileExt) {
        super(root);
        if (fileExt != null) {
            this.fileExt = fileExt;
        }
    }

    @Override
    protected boolean includeFile(File file) {
        return file.getName().endsWith(this.fileExt);
    }

    @Override
    protected FileModule makeFile(File file) {
        Object rootPath = this.root.getAbsolutePath();
        if (!((String)rootPath).endsWith(File.separator)) {
            rootPath = (String)rootPath + File.separator;
        }
        String filePath = file.getAbsolutePath();
        assert (filePath.startsWith((String)rootPath));
        return new SourceFileModule(file, filePath.substring(((String)rootPath).length()), this);
    }

    @Override
    public String toString() {
        return "SourceDirectoryTreeModule:" + this.getPath();
    }
}

