/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.BytecodeLanguage;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.core.util.bytecode.BytecodeStream;
import com.ibm.wala.core.util.shrike.ShrikeUtil;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.core.util.strings.ImmutableByteArray;
import com.ibm.wala.shrike.shrikeBT.BytecodeConstants;
import com.ibm.wala.shrike.shrikeBT.Decoder;
import com.ibm.wala.shrike.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrike.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrike.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrike.shrikeBT.IGetInstruction;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrike.shrikeBT.IPutInstruction;
import com.ibm.wala.shrike.shrikeBT.ITypeTestInstruction;
import com.ibm.wala.shrike.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrike.shrikeBT.NewInstruction;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class ShrikeBTMethod
implements IMethod,
BytecodeConstants {
    private static final boolean verbose = false;
    private static int methodsParsed = 0;
    protected final IClass declaringClass;
    private MethodReference methodReference;
    private SoftReference<BytecodeInfo> bcInfo;

    public ShrikeBTMethod(IClass klass) {
        this.declaringClass = klass;
    }

    protected synchronized BytecodeInfo getBCInfo() throws InvalidClassFileException {
        BytecodeInfo result = null;
        if (this.bcInfo != null) {
            result = this.bcInfo.get();
        }
        if (result == null) {
            result = this.computeBCInfo();
            this.bcInfo = new SoftReference<BytecodeInfo>(result);
        }
        return result;
    }

    public int getBytecodeIndex(int instructionIndex) throws InvalidClassFileException {
        return this.getBCInfo().pcMap[instructionIndex];
    }

    public int getInstructionIndex(int bcIndex) throws InvalidClassFileException {
        if (this.isNative()) {
            throw new UnsupportedOperationException("getInstructionIndex(int bcIndex) is only supported for non-native bytecode");
        }
        BytecodeInfo info = this.getBCInfo();
        if (info.decoder.containsSubroutines()) {
            return -1;
        }
        int[] pcMap = info.pcMap;
        assert (ShrikeBTMethod.isSorted(pcMap));
        int iindex = Arrays.binarySearch(pcMap, bcIndex);
        if (iindex < 0) {
            return -1;
        }
        while (iindex > 0 && pcMap[iindex - 1] == bcIndex) {
            --iindex;
        }
        return iindex;
    }

    private static boolean isSorted(int[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (a[i + 1] >= a[i]) continue;
            return false;
        }
        return true;
    }

    public int getNumShrikeInstructions() throws InvalidClassFileException {
        return this.getBCInfo().pcMap.length;
    }

    public Collection<CallSiteReference> getCallSites() throws InvalidClassFileException {
        return this.isNative() || this.getBCInfo().callSites == null ? Collections.emptySet() : Collections.unmodifiableCollection(Arrays.asList(this.getBCInfo().callSites));
    }

    public Collection<NewSiteReference> getNewSites() throws InvalidClassFileException {
        return this.isNative() || this.getBCInfo().newSites == null ? Collections.emptySet() : Collections.unmodifiableCollection(Arrays.asList(this.getBCInfo().newSites));
    }

    public Collection<TypeReference> getImplicitExceptionTypes() throws InvalidClassFileException {
        if (this.isNative()) {
            return Collections.emptySet();
        }
        return this.getBCInfo().implicitExceptions == null ? Collections.emptyList() : Arrays.asList(this.getBCInfo().implicitExceptions);
    }

    private BytecodeInfo computeBCInfo() throws InvalidClassFileException {
        BytecodeInfo result = new BytecodeInfo();
        result.exceptionTypes = this.computeDeclaredExceptions();
        if (this.isNative()) {
            return result;
        }
        this.processBytecodesWithShrikeBT(result);
        return result;
    }

    public boolean hasMonitorOp() throws InvalidClassFileException {
        if (this.isNative()) {
            return false;
        }
        return this.getBCInfo().hasMonitorOp;
    }

    public Iterator<FieldReference> getFieldsWritten() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        if (this.getBCInfo().fieldsWritten == null) {
            return EmptyIterator.instance();
        }
        List<FieldReference> l = Arrays.asList(this.getBCInfo().fieldsWritten);
        return l.iterator();
    }

    public Iterator<FieldReference> getFieldsRead() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        if (this.getBCInfo().fieldsRead == null) {
            return EmptyIterator.instance();
        }
        List<FieldReference> l = Arrays.asList(this.getBCInfo().fieldsRead);
        return l.iterator();
    }

    public Iterator<TypeReference> getArraysRead() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        return this.getBCInfo().arraysRead == null ? EmptyIterator.instance() : Arrays.asList(this.getBCInfo().arraysRead).iterator();
    }

    public Iterator<TypeReference> getArraysWritten() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        if (this.getBCInfo().fieldsRead == null) {
            return EmptyIterator.instance();
        }
        List<TypeReference> list = Arrays.asList(this.getBCInfo().arraysWritten);
        return list.iterator();
    }

    public Iterator<TypeReference> getCastTypes() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        return this.getBCInfo().castTypes == null ? EmptyIterator.instance() : Arrays.asList(this.getBCInfo().castTypes).iterator();
    }

    protected abstract byte[] getBytecodes();

    public BytecodeStream getBytecodeStream() {
        byte[] bytecodes = this.getBytecodes();
        if (bytecodes == null) {
            return null;
        }
        return new BytecodeStream(this, bytecodes);
    }

    protected abstract String getMethodName() throws InvalidClassFileException;

    protected abstract String getMethodSignature() throws InvalidClassFileException;

    private MethodReference computeMethodReference() {
        try {
            Atom name = Atom.findOrCreateUnicodeAtom(this.getMethodName());
            ImmutableByteArray desc = ImmutableByteArray.make(this.getMethodSignature());
            Descriptor D = Descriptor.findOrCreate(this.declaringClass.getClassLoader().getLanguage(), desc);
            return MethodReference.findOrCreate(this.declaringClass.getReference(), name, D);
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public MethodReference getReference() {
        if (this.methodReference == null) {
            this.methodReference = this.computeMethodReference();
        }
        return this.methodReference;
    }

    @Override
    public boolean isClinit() {
        return this.getReference().getSelector().equals(MethodReference.clinitSelector);
    }

    @Override
    public boolean isInit() {
        return this.getReference().getName().equals(MethodReference.initAtom);
    }

    protected abstract int getModifiers();

    @Override
    public boolean isNative() {
        return (this.getModifiers() & 0x100) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    @Override
    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    @Override
    public boolean isSynchronized() {
        return (this.getModifiers() & 0x20) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isModule() {
        return (this.getModifiers() & 0x8000) != 0;
    }

    @Override
    public boolean isWalaSynthetic() {
        return false;
    }

    @Override
    public IClass getDeclaringClass() {
        return this.declaringClass;
    }

    protected abstract Decoder makeDecoder();

    protected abstract void processDebugInfo(BytecodeInfo var1) throws InvalidClassFileException;

    private void processBytecodesWithShrikeBT(BytecodeInfo info) throws InvalidClassFileException {
        info.decoder = this.makeDecoder();
        if (!this.isAbstract() && info.decoder == null) {
            throw new InvalidClassFileException(-1, "non-abstract method " + this.getReference() + " has no bytecodes");
        }
        if (info.decoder == null) {
            return;
        }
        info.pcMap = info.decoder.getInstructionsToBytecodes();
        this.processDebugInfo(info);
        SimpleVisitor simpleVisitor = new SimpleVisitor(info);
        BytecodeLanguage lang = (BytecodeLanguage)this.getDeclaringClass().getClassLoader().getLanguage();
        IInstruction[] instructions = info.decoder.getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            Collection<TypeReference> t;
            simpleVisitor.setInstructionIndex(i);
            instructions[i].visit((IInstruction.Visitor)simpleVisitor);
            if (!instructions[i].isPEI() || (t = lang.getImplicitExceptionTypes(instructions[i])) == null) continue;
            simpleVisitor.implicitExceptions.addAll(t);
        }
        ShrikeBTMethod.copyVisitorSetsToArrays(simpleVisitor, info);
    }

    private static void copyVisitorSetsToArrays(SimpleVisitor simpleVisitor, BytecodeInfo info) {
        info.newSites = new NewSiteReference[simpleVisitor.newSites.size()];
        int i = 0;
        for (NewSiteReference newSiteReference : simpleVisitor.newSites) {
            info.newSites[i++] = newSiteReference;
        }
        info.fieldsRead = new FieldReference[simpleVisitor.fieldsRead.size()];
        i = 0;
        for (FieldReference fieldReference : simpleVisitor.fieldsRead) {
            info.fieldsRead[i++] = fieldReference;
        }
        info.fieldsRead = new FieldReference[simpleVisitor.fieldsRead.size()];
        i = 0;
        for (FieldReference fieldReference : simpleVisitor.fieldsRead) {
            info.fieldsRead[i++] = fieldReference;
        }
        info.fieldsWritten = new FieldReference[simpleVisitor.fieldsWritten.size()];
        i = 0;
        for (FieldReference fieldReference : simpleVisitor.fieldsWritten) {
            info.fieldsWritten[i++] = fieldReference;
        }
        info.callSites = new CallSiteReference[simpleVisitor.callSites.size()];
        i = 0;
        for (CallSiteReference callSiteReference : simpleVisitor.callSites) {
            info.callSites[i++] = callSiteReference;
        }
        info.arraysRead = new TypeReference[simpleVisitor.arraysRead.size()];
        i = 0;
        for (TypeReference typeReference : simpleVisitor.arraysRead) {
            info.arraysRead[i++] = typeReference;
        }
        info.arraysWritten = new TypeReference[simpleVisitor.arraysWritten.size()];
        i = 0;
        for (TypeReference typeReference : simpleVisitor.arraysWritten) {
            info.arraysWritten[i++] = typeReference;
        }
        info.implicitExceptions = new TypeReference[simpleVisitor.implicitExceptions.size()];
        i = 0;
        for (TypeReference typeReference : simpleVisitor.implicitExceptions) {
            info.implicitExceptions[i++] = typeReference;
        }
        info.castTypes = new TypeReference[simpleVisitor.castTypes.size()];
        i = 0;
        for (TypeReference typeReference : simpleVisitor.castTypes) {
            info.castTypes[i++] = typeReference;
        }
        info.hasMonitorOp = simpleVisitor.hasMonitorOp;
    }

    public String toString() {
        return this.getReference().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShrikeBTMethod) {
            ShrikeBTMethod that = (ShrikeBTMethod)obj;
            return this.getDeclaringClass().equals(that.getDeclaringClass()) && this.getReference().equals(that.getReference());
        }
        return false;
    }

    public int hashCode() {
        return 9661 * this.getReference().hashCode();
    }

    public abstract int getMaxLocals();

    public abstract int getMaxStackHeight();

    @Override
    public Atom getName() {
        return this.getReference().getName();
    }

    @Override
    public Descriptor getDescriptor() {
        return this.getReference().getDescriptor();
    }

    public IInstruction[] getInstructions() throws InvalidClassFileException {
        if (this.getBCInfo().decoder == null) {
            return null;
        }
        return this.getBCInfo().decoder.getInstructions();
    }

    public ExceptionHandler[][] getHandlers() throws InvalidClassFileException {
        if (this.getBCInfo().decoder == null) {
            return null;
        }
        return this.getBCInfo().decoder.getHandlers();
    }

    @Override
    public TypeReference getParameterType(int i) {
        if (!this.isStatic()) {
            if (i == 0) {
                return this.declaringClass.getReference();
            }
            return this.getReference().getParameterType(i - 1);
        }
        return this.getReference().getParameterType(i);
    }

    @Override
    public int getNumberOfParameters() {
        if (this.isStatic() || this.isClinit()) {
            return this.getReference().getNumberOfParameters();
        }
        return this.getReference().getNumberOfParameters() + 1;
    }

    @Override
    public abstract boolean hasExceptionHandler();

    @Override
    public TypeReference[] getDeclaredExceptions() throws InvalidClassFileException {
        return this.getBCInfo().exceptionTypes == null ? new TypeReference[]{} : this.getBCInfo().exceptionTypes;
    }

    protected abstract String[] getDeclaredExceptionTypeNames() throws InvalidClassFileException;

    private TypeReference[] computeDeclaredExceptions() {
        try {
            String[] strings = this.getDeclaredExceptionTypeNames();
            if (strings == null) {
                return null;
            }
            ClassLoaderReference loader = this.getDeclaringClass().getClassLoader().getReference();
            TypeReference[] result = new TypeReference[strings.length];
            Arrays.setAll(result, i -> TypeReference.findOrCreate(loader, TypeName.findOrCreate(ImmutableByteArray.make("L" + strings[i]))));
            return result;
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public IMethod.SourcePosition getSourcePosition(int bcIndex) throws InvalidClassFileException {
        return this.getBCInfo().positionMap == null ? null : this.getBCInfo().positionMap[bcIndex];
    }

    @Override
    public IMethod.SourcePosition getParameterSourcePosition(int paramNum) throws InvalidClassFileException {
        return this.getBCInfo().paramPositionMap == null ? null : this.getBCInfo().paramPositionMap[paramNum];
    }

    @Override
    public int getLineNumber(int bcIndex) {
        try {
            return this.getBCInfo().lineNumberMap == null ? -1 : this.getBCInfo().lineNumberMap[bcIndex];
        }
        catch (InvalidClassFileException e) {
            return -1;
        }
    }

    public Set<TypeReference> getCaughtExceptionTypes() throws InvalidClassFileException {
        ExceptionHandler[][] handlers = this.getHandlers();
        if (handlers == null) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make((int)10);
        ClassLoaderReference loader = this.getReference().getDeclaringClass().getClassLoader();
        ExceptionHandler[][] exceptionHandlerArray = handlers;
        int n = exceptionHandlerArray.length;
        for (int i = 0; i < n; ++i) {
            ExceptionHandler[] handler;
            for (ExceptionHandler element : handler = exceptionHandlerArray[i]) {
                TypeReference t = ShrikeUtil.makeTypeReference(loader, element.getCatchClass());
                if (t == null) {
                    t = TypeReference.JavaLangThrowable;
                }
                result.add(t);
            }
        }
        return result;
    }

    @Override
    public String getSignature() {
        return this.getReference().getSignature();
    }

    @Override
    public Selector getSelector() {
        return this.getReference().getSelector();
    }

    @Override
    public abstract String getLocalVariableName(int var1, int var2);

    @Override
    public abstract boolean hasLocalVariableTable();

    public void clearCaches() {
        this.bcInfo = null;
    }

    private class SimpleVisitor
    extends IInstruction.Visitor {
        private final BytecodeInfo info;
        final Set<CallSiteReference> callSites = HashSetFactory.make((int)5);
        final Set<FieldReference> fieldsWritten = HashSetFactory.make((int)5);
        final Set<FieldReference> fieldsRead = HashSetFactory.make((int)5);
        final Set<NewSiteReference> newSites = HashSetFactory.make((int)5);
        final Set<TypeReference> arraysRead = HashSetFactory.make((int)5);
        final Set<TypeReference> arraysWritten = HashSetFactory.make((int)5);
        final Set<TypeReference> implicitExceptions = HashSetFactory.make((int)5);
        final Set<TypeReference> castTypes = HashSetFactory.make((int)5);
        boolean hasMonitorOp;
        private int instructionIndex;

        public SimpleVisitor(BytecodeInfo info) {
            this.info = info;
        }

        public void setInstructionIndex(int i) {
            this.instructionIndex = i;
        }

        public int getProgramCounter() {
            return this.info.pcMap[this.instructionIndex];
        }

        public void visitMonitor(MonitorInstruction instruction) {
            this.hasMonitorOp = true;
        }

        public void visitNew(NewInstruction instruction) {
            ClassLoaderReference loader = ShrikeBTMethod.this.getReference().getDeclaringClass().getClassLoader();
            TypeReference t = ShrikeUtil.makeTypeReference(loader, instruction.getType());
            this.newSites.add(NewSiteReference.make(this.getProgramCounter(), t));
        }

        public void visitGet(IGetInstruction instruction) {
            ClassLoaderReference loader = ShrikeBTMethod.this.getReference().getDeclaringClass().getClassLoader();
            FieldReference f = FieldReference.findOrCreate(loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
            this.fieldsRead.add(f);
        }

        public void visitPut(IPutInstruction instruction) {
            ClassLoaderReference loader = ShrikeBTMethod.this.getReference().getDeclaringClass().getClassLoader();
            FieldReference f = FieldReference.findOrCreate(loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
            this.fieldsWritten.add(f);
        }

        public void visitInvoke(IInvokeInstruction instruction) {
            IClassLoader loader = ShrikeBTMethod.this.getDeclaringClass().getClassLoader();
            MethodReference m = MethodReference.findOrCreate(loader.getLanguage(), loader.getReference(), instruction.getClassType(), instruction.getMethodName(), instruction.getMethodSignature());
            int programCounter = this.getProgramCounter();
            CallSiteReference site = CallSiteReference.make(programCounter, m, instruction.getInvocationCode());
            this.callSites.add(site);
        }

        public void visitArrayLoad(IArrayLoadInstruction instruction) {
            this.arraysRead.add(ShrikeUtil.makeTypeReference(ShrikeBTMethod.this.getDeclaringClass().getClassLoader().getReference(), instruction.getType()));
        }

        public void visitArrayStore(IArrayStoreInstruction instruction) {
            this.arraysWritten.add(ShrikeUtil.makeTypeReference(ShrikeBTMethod.this.getDeclaringClass().getClassLoader().getReference(), instruction.getType()));
        }

        public void visitCheckCast(ITypeTestInstruction instruction) {
            for (String t : instruction.getTypes()) {
                this.castTypes.add(ShrikeUtil.makeTypeReference(ShrikeBTMethod.this.getDeclaringClass().getClassLoader().getReference(), t));
            }
        }
    }

    protected static class BytecodeInfo {
        Decoder decoder;
        CallSiteReference[] callSites;
        FieldReference[] fieldsWritten;
        FieldReference[] fieldsRead;
        NewSiteReference[] newSites;
        TypeReference[] arraysRead;
        TypeReference[] arraysWritten;
        TypeReference[] implicitExceptions;
        TypeReference[] castTypes;
        boolean hasMonitorOp;
        private int[] pcMap;
        protected IMethod.SourcePosition[] positionMap;
        protected IMethod.SourcePosition[] paramPositionMap;
        protected int[] lineNumberMap;
        protected int[][] localVariableMap;
        private TypeReference[] exceptionTypes;

        protected BytecodeInfo() {
        }
    }
}

