/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.SourceModule;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.collections.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompoundModule
implements ModuleEntry,
Module,
SourceModule {
    private final SourceModule[] constituents;
    private final URL name;

    public CompoundModule(URL name, SourceModule[] constituents) {
        this.name = name;
        this.constituents = constituents;
    }

    public SourceModule[] getConstituents() {
        return (SourceModule[])this.constituents.clone();
    }

    public Iterator<ModuleEntry> getEntries() {
        return new NonNullSingletonIterator((Object)this);
    }

    @Override
    public boolean isModuleFile() {
        return false;
    }

    @Override
    public Module asModule() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClassName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public URL getURL() {
        return this.name;
    }

    @Override
    public boolean isClassFile() {
        return false;
    }

    @Override
    public boolean isSourceFile() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        return new InputStream(){
            private int index = 0;
            private InputStream currentStream;

            @Override
            public int read() throws IOException {
                int b;
                if (this.currentStream == null) {
                    if (this.index < CompoundModule.this.constituents.length) {
                        this.currentStream = CompoundModule.this.constituents[this.index++].getInputStream();
                    } else {
                        return -1;
                    }
                }
                if ((b = this.currentStream.read()) == -1) {
                    this.currentStream = null;
                    return this.read();
                }
                return b;
            }
        };
    }

    @Override
    public Reader getInputReader() {
        return new Reader();
    }

    @Override
    public Module getContainer() {
        return null;
    }

    public class Reader
    extends java.io.Reader {
        private final List<Pair<Integer, URL>> locations = new ArrayList<Pair<Integer, URL>>();
        private int line = 0;
        private int index = 0;
        private LineNumberReader currentReader;
        private URL currentName;

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int x;
            if (this.currentReader == null) {
                if (this.index < CompoundModule.this.constituents.length) {
                    this.currentName = CompoundModule.this.constituents[this.index].getURL();
                    this.currentReader = new LineNumberReader(new InputStreamReader(CompoundModule.this.constituents[this.index++].getInputStream()));
                } else {
                    return -1;
                }
            }
            if ((x = this.currentReader.read(cbuf, off, len)) == -1) {
                this.line += this.currentReader.getLineNumber();
                this.locations.add((Pair<Integer, URL>)Pair.make((Object)this.line, (Object)this.currentName));
                this.currentReader.close();
                this.currentReader = null;
                return this.read(cbuf, off, len);
            }
            return x;
        }

        @Override
        public void close() throws IOException {
            if (this.currentReader != null) {
                this.currentReader.close();
                this.currentReader = null;
            }
        }

        public Pair<Integer, URL> getOriginalPosition(int lineNumber) {
            int start = 0;
            for (Pair<Integer, URL> location : this.locations) {
                if ((Integer)location.fst >= lineNumber) {
                    return Pair.make((Object)(lineNumber - start), (Object)((URL)location.snd));
                }
                start = (Integer)location.fst;
            }
            throw new IllegalArgumentException("line number " + lineNumber + " too high");
        }
    }
}

