/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrike.shrikeBT.Constants;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ArrayClass
implements IClass,
Constants {
    private final IClassHierarchy cha;
    private final TypeReference type;
    private final IClassLoader loader;

    ArrayClass(TypeReference type, IClassLoader loader, IClassHierarchy cha) {
        IClass klass;
        this.type = type;
        this.loader = loader;
        this.cha = cha;
        TypeReference elementType = type.getInnermostElementType();
        if (!elementType.isPrimitiveType() && (klass = loader.lookupClass(elementType.getName())) == null) {
            Assertions.UNREACHABLE((String)("caller should not attempt to create an array with type " + type));
        }
    }

    @Override
    public IClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public TypeName getName() {
        return this.getReference().getName();
    }

    public boolean isOfPrimitives() {
        return this.type.getInnermostElementType().isPrimitiveType();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public int getModifiers() {
        return 17;
    }

    public String getQualifiedNameForReflection() {
        return this.type.getName().toString();
    }

    @Override
    public IClass getSuperclass() {
        IClass elt = this.getElementClass();
        assert (this.getReference().getArrayElementType().isPrimitiveType() || elt != null);
        if (elt == null || elt.getReference() == this.getClassLoader().getLanguage().getRootType()) {
            return this.loader.lookupClass(this.getClassLoader().getLanguage().getRootType().getName());
        }
        TypeReference eltSuperRef = elt.getSuperclass().getReference();
        TypeReference superRef = TypeReference.findOrCreateArrayOf(eltSuperRef);
        return elt.getSuperclass().getClassLoader().lookupClass(superRef.getName());
    }

    @Override
    public IMethod getMethod(Selector sig) {
        return this.cha.lookupClass(this.getClassLoader().getLanguage().getRootType()).getMethod(sig);
    }

    @Override
    public IField getField(Atom name) {
        return this.getSuperclass().getField(name);
    }

    @Override
    public IField getField(Atom name, TypeName typeName) {
        return this.getSuperclass().getField(name, typeName);
    }

    public Collection<IMethod> getDeclaredMethods() {
        return Collections.emptySet();
    }

    public int getNumberOfDeclaredMethods() {
        return 0;
    }

    @Override
    public TypeReference getReference() {
        return this.type;
    }

    @Override
    public String getSourceFileName() {
        return null;
    }

    @Override
    public IMethod getClassInitializer() {
        return null;
    }

    @Override
    public boolean isArrayClass() {
        return true;
    }

    public String toString() {
        return this.getReference().toString();
    }

    public IClass getElementClass() {
        TypeReference elementType = this.getReference().getArrayElementType();
        if (elementType.isPrimitiveType()) {
            return null;
        }
        return this.loader.lookupClass(elementType.getName());
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Collection<IClass> getAllImplementedInterfaces() {
        HashSet result = HashSetFactory.make((int)2);
        for (TypeReference ref : this.getClassLoader().getLanguage().getArrayInterfaces()) {
            IClass klass = this.loader.lookupClass(ref.getName());
            if (klass == null) continue;
            result.add(klass);
        }
        return result;
    }

    public Collection<IClass> getAllAncestorInterfaces() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReferenceType() {
        return true;
    }

    public int getDimensionality() {
        return ArrayClass.getArrayTypeDimensionality(this.getReference());
    }

    public static int getArrayTypeDimensionality(TypeReference reference) {
        int mask = reference.getDerivedMask();
        if ((mask & 4) == 4) {
            mask >>= 3;
        }
        int dims = 0;
        while ((mask & 1) == 1) {
            mask >>= 3;
            ++dims;
        }
        assert (dims > 0);
        return dims;
    }

    public IClass getInnermostElementClass() {
        TypeReference elementType = this.getReference().getInnermostElementType();
        if (elementType.isPrimitiveType()) {
            return null;
        }
        return this.loader.lookupClass(elementType.getName());
    }

    public Collection<IClass> getDirectInterfaces() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArrayClass) {
            ArrayClass other = (ArrayClass)obj;
            return this.loader.equals(other.loader) && this.type.equals(other.type);
        }
        return false;
    }

    @Override
    public Collection<IField> getAllInstanceFields() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Collection<IField> getAllStaticFields() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Collection<? extends IMethod> getAllMethods() {
        return this.loader.lookupClass(this.getClassLoader().getLanguage().getRootType().getName()).getAllMethods();
    }

    @Override
    public Collection<IField> getAllFields() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public Reader getSource() {
        return null;
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return Collections.emptySet();
    }
}

