/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.BytecodeCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.BytecodeLanguage;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.util.shrike.ShrikeUtil;
import com.ibm.wala.core.util.warnings.Warning;
import com.ibm.wala.core.util.warnings.Warnings;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrike.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrike.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrike.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ShrikeCFG
extends AbstractCFG<IInstruction, BasicBlock>
implements BytecodeCFG {
    private static final boolean DEBUG = false;
    private int[] instruction2Block;
    private final IBytecodeMethod<IInstruction> method;
    private final int hashBase;
    private final Set<ExceptionHandler> exceptionHandlers = HashSetFactory.make((int)10);

    public static ShrikeCFG make(IBytecodeMethod<IInstruction> m) {
        return new ShrikeCFG(m);
    }

    private ShrikeCFG(IBytecodeMethod<IInstruction> method) throws IllegalArgumentException {
        super(method);
        if (method == null) {
            throw new IllegalArgumentException("method cannot be null");
        }
        this.method = method;
        this.hashBase = method.hashCode() * 9967;
        this.makeBasicBlocks();
        this.init();
        this.computeI2BMapping();
        this.computeEdges();
    }

    @Override
    public IBytecodeMethod<IInstruction> getMethod() {
        return this.method;
    }

    @Override
    public int hashCode() {
        return 9511 * this.getMethod().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ShrikeCFG && this.getMethod().equals(((ShrikeCFG)o).getMethod());
    }

    public IInstruction[] getInstructions() {
        try {
            return this.method.getInstructions();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    private void computeI2BMapping() {
        this.instruction2Block = new int[this.getInstructions().length];
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BasicBlock b = (BasicBlock)iterator.next();
            for (int j = b.getFirstInstructionIndex(); j <= b.getLastInstructionIndex(); ++j) {
                this.instruction2Block[j] = this.getNumber(b);
            }
        }
    }

    private void computeEdges() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BasicBlock b = (BasicBlock)iterator.next();
            if (b.equals(this.exit())) continue;
            if (b.equals(this.entry())) {
                BasicBlock bb0 = this.getBlockForInstruction(0);
                assert (bb0 != null);
                this.addNormalEdge(b, bb0);
                continue;
            }
            b.computeOutgoingEdges();
        }
    }

    private void makeBasicBlocks() {
        ExceptionHandler[][] handlers;
        try {
            handlers = this.method.getHandlers();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            handlers = null;
        }
        boolean[] r = new boolean[this.getInstructions().length];
        boolean[] catchers = new boolean[this.getInstructions().length];
        r[0] = true;
        IInstruction[] instructions = this.getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            int[] targets = instructions[i].getBranchTargets();
            if (!(targets.length <= 0 && instructions[i].isFallThrough() || i + 1 >= instructions.length || r[i + 1])) {
                r[i + 1] = true;
            }
            for (int target : targets) {
                if (r[target]) continue;
                r[target] = true;
            }
            if (!instructions[i].isPEI()) continue;
            ExceptionHandler[] hs = handlers[i];
            if (i + 1 < instructions.length && !r[i + 1]) {
                r[i + 1] = true;
            }
            if (hs == null) continue;
            for (ExceptionHandler h : hs) {
                this.exceptionHandlers.add(h);
                if (!r[h.getHandler()]) {
                    r[h.getHandler()] = true;
                }
                catchers[h.getHandler()] = true;
            }
        }
        BasicBlock entry = new BasicBlock(-1);
        this.addNode(entry);
        int j = 1;
        for (int i = 0; i < r.length; ++i) {
            if (!r[i]) continue;
            BasicBlock b = new BasicBlock(i);
            this.addNode(b);
            if (catchers[i]) {
                this.setCatchBlock(j);
            }
            ++j;
        }
        BasicBlock exit = new BasicBlock(-1);
        this.addNode(exit);
    }

    @Override
    public BasicBlock getBlockForInstruction(int index) {
        return (BasicBlock)this.getNode(this.instruction2Block[index]);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BasicBlock bb = (BasicBlock)iterator.next();
            s.append("BB").append(this.getNumber(bb)).append('\n');
            for (int j = bb.getFirstInstructionIndex(); j <= bb.getLastInstructionIndex(); ++j) {
                s.append("  ").append(j).append("  ").append(this.getInstructions()[j]).append('\n');
            }
            Iterator<BasicBlock> succNodes = this.getSuccNodes(bb);
            while (succNodes.hasNext()) {
                s.append("    -> BB").append(this.getNumber(succNodes.next())).append('\n');
            }
        }
        return s.toString();
    }

    @Override
    public Set<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    @Override
    public int getProgramCounter(int index) {
        try {
            return this.method.getBytecodeIndex(index);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return -1;
        }
    }

    private static class FailedExceptionResolutionWarning
    extends Warning {
        final TypeReference T;

        FailedExceptionResolutionWarning(TypeReference T) {
            super((byte)1);
            this.T = T;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.T;
        }

        public static FailedExceptionResolutionWarning create(TypeReference T) {
            return new FailedExceptionResolutionWarning(T);
        }
    }

    public final class BasicBlock
    extends NodeWithNumber
    implements IBasicBlock<IInstruction> {
        private final int startIndex;

        public BasicBlock(int startIndex) {
            this.startIndex = startIndex;
        }

        @Override
        public boolean isCatchBlock() {
            return ShrikeCFG.this.isCatchBlock(this.getNumber());
        }

        private void computeOutgoingEdges() {
            int[] targets;
            IInstruction last = ShrikeCFG.this.getInstructions()[this.getLastInstructionIndex()];
            for (int target : targets = last.getBranchTargets()) {
                BasicBlock b = ShrikeCFG.this.getBlockForInstruction(target);
                this.addNormalEdgeTo(b);
            }
            this.addExceptionalEdges(last);
            if (last.isFallThrough()) {
                BasicBlock next = (BasicBlock)ShrikeCFG.this.getNode(this.getNumber() + 1);
                this.addNormalEdgeTo(next);
            }
            if (last instanceof ReturnInstruction) {
                BasicBlock exit = (BasicBlock)ShrikeCFG.this.exit();
                this.addNormalEdgeTo(exit);
            }
        }

        private void addExceptionalEdges(IInstruction last) {
            IClassHierarchy cha = this.getMethod().getClassHierarchy();
            if (last.isPEI()) {
                Collection<Object> exceptionTypes = null;
                boolean goToAllHandlers = false;
                ExceptionHandler[] hs = this.getExceptionHandlers();
                if (last instanceof ThrowInstruction) {
                    goToAllHandlers = true;
                } else if (hs != null && hs.length > 0) {
                    IClassLoader loader = this.getMethod().getDeclaringClass().getClassLoader();
                    BytecodeLanguage l = (BytecodeLanguage)loader.getLanguage();
                    exceptionTypes = l.getImplicitExceptionTypes(last);
                    if (last instanceof IInvokeInstruction) {
                        IInvokeInstruction call = (IInvokeInstruction)last;
                        exceptionTypes = HashSetFactory.make((Collection)exceptionTypes);
                        MethodReference target = MethodReference.findOrCreate(l, loader.getReference(), call.getClassType(), call.getMethodName(), call.getMethodSignature());
                        try {
                            exceptionTypes.addAll(l.inferInvokeExceptions(target, cha));
                        }
                        catch (InvalidClassFileException e) {
                            e.printStackTrace();
                            Assertions.UNREACHABLE();
                        }
                        IMethod mTarget = cha.resolveMethod(target);
                        if (mTarget == null) {
                            goToAllHandlers = true;
                        }
                    }
                }
                if (hs != null && hs.length > 0) {
                    if (!goToAllHandlers) {
                        exceptionTypes = HashSetFactory.make(exceptionTypes);
                    }
                    boolean needEdgeToExitForAllHandlers = true;
                    for (ExceptionHandler element : hs) {
                        BasicBlock b = ShrikeCFG.this.getBlockForInstruction(element.getHandler());
                        if (goToAllHandlers) {
                            this.addExceptionalEdgeTo(b);
                            if (element.getCatchClass() != null) continue;
                            needEdgeToExitForAllHandlers = false;
                            break;
                        }
                        TypeReference caughtException = null;
                        if (element.getCatchClass() != null) {
                            ClassLoaderReference loader = element.getCatchClassLoader() == null ? ShrikeCFG.this.getMethod().getDeclaringClass().getReference().getClassLoader() : (ClassLoaderReference)element.getCatchClassLoader();
                            caughtException = ShrikeUtil.makeTypeReference(loader, element.getCatchClass());
                            IClass caughtClass = cha.lookupClass(caughtException);
                            if (caughtClass == null) {
                                this.addExceptionalEdgeTo(b);
                                Warnings.add(FailedExceptionResolutionWarning.create(caughtException));
                                caughtException = null;
                            }
                        } else if (!exceptionTypes.isEmpty()) {
                            this.addExceptionalEdgeTo(b);
                            exceptionTypes.clear();
                            assert (caughtException == null);
                        }
                        if (caughtException == null) continue;
                        IClass caughtClass = cha.lookupClass(caughtException);
                        ArrayList<TypeReference> caught = new ArrayList<TypeReference>(exceptionTypes.size());
                        for (TypeReference typeReference : exceptionTypes) {
                            if (typeReference == null) continue;
                            IClass klass = cha.lookupClass(typeReference);
                            if (klass == null) {
                                Warnings.add(FailedExceptionResolutionWarning.create(caughtException));
                                this.addExceptionalEdgeTo(b);
                                continue;
                            }
                            boolean subtype1 = cha.isSubclassOf(klass, caughtClass);
                            if (!subtype1 && !cha.isSubclassOf(caughtClass, klass)) continue;
                            this.addExceptionalEdgeTo(b);
                            if (!subtype1) continue;
                            caught.add(typeReference);
                        }
                        exceptionTypes.removeAll(caught);
                    }
                    if (exceptionTypes == null && needEdgeToExitForAllHandlers || exceptionTypes != null && !exceptionTypes.isEmpty()) {
                        BasicBlock exit = (BasicBlock)ShrikeCFG.this.exit();
                        this.addExceptionalEdgeTo(exit);
                    }
                } else {
                    BasicBlock exit = (BasicBlock)ShrikeCFG.this.exit();
                    this.addExceptionalEdgeTo(exit);
                }
            }
        }

        private ExceptionHandler[] getExceptionHandlers() {
            ExceptionHandler[][] handlers;
            try {
                handlers = ShrikeCFG.this.method.getHandlers();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
                handlers = null;
            }
            ExceptionHandler[] hs = handlers[this.getLastInstructionIndex()];
            return hs;
        }

        private void addNormalEdgeTo(BasicBlock b) {
            ShrikeCFG.this.addNormalEdge(this, b);
        }

        private void addExceptionalEdgeTo(BasicBlock b) {
            ShrikeCFG.this.addExceptionalEdge(this, b);
        }

        @Override
        public int getLastInstructionIndex() {
            BasicBlock next;
            if (this == ShrikeCFG.this.entry() || this == ShrikeCFG.this.exit()) {
                return -2;
            }
            if (this.getNumber() == ShrikeCFG.this.getMaxNumber() - 1) {
                return ShrikeCFG.this.getInstructions().length - 1;
            }
            int i = 1;
            while ((next = (BasicBlock)ShrikeCFG.this.getNode(this.getNumber() + i)) == null) {
            }
            return next.getFirstInstructionIndex() - 1;
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.startIndex;
        }

        public String toString() {
            return "BB[Shrike]" + this.getNumber() + " - " + ShrikeCFG.this.method.getDeclaringClass().getReference().getName() + "." + ShrikeCFG.this.method.getName();
        }

        @Override
        public boolean isExitBlock() {
            return this == ShrikeCFG.this.exit();
        }

        @Override
        public boolean isEntryBlock() {
            return this == ShrikeCFG.this.entry();
        }

        @Override
        public IMethod getMethod() {
            return ShrikeCFG.this.getMethod();
        }

        public int hashCode() {
            return ShrikeCFG.this.hashBase + this.getNumber();
        }

        public boolean equals(Object o) {
            return o instanceof BasicBlock && ((BasicBlock)o).getMethod().equals(this.getMethod()) && ((BasicBlock)o).getNumber() == this.getNumber();
        }

        @Override
        public int getNumber() {
            return this.getGraphNodeId();
        }

        @Override
        public Iterator<IInstruction> iterator() {
            return new ArrayIterator((Object[])ShrikeCFG.this.getInstructions(), this.getFirstInstructionIndex(), this.getLastInstructionIndex());
        }
    }
}

