/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection.java7;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DelegatingSSAContextInterpreter;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRView;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;

public class MethodHandles {
    private static final IntSet params = IntSetUtil.make((int[])new int[]{1, 2});
    private static final IntSet self = IntSetUtil.make((int[])new int[0]);
    private static final ContextKey METHOD_KEY = new ContextKey(){

        public String toString() {
            return "METHOD_KEY";
        }
    };
    private static final ContextKey CLASS_KEY = new ContextKey(){

        public String toString() {
            return "CLASS_KEY";
        }
    };
    private static final ContextKey NAME_KEY = new ContextKey(){

        public String toString() {
            return "NAME_KEY";
        }
    };

    private static boolean isInvokeExact(MethodReference target) {
        return target.getDeclaringClass().getName().equals(TypeReference.JavaLangInvokeMethodHandle.getName()) && target.getName().toString().equals("invokeExact");
    }

    private static boolean isFindStatic(MethodReference node) {
        return node.getName().toString().startsWith("findStatic");
    }

    private static boolean isFindStatic(IMethod node) {
        return MethodHandles.isFindStatic(node.getReference());
    }

    private static boolean isInvoke(IMethod node) {
        return node.getName().toString().startsWith("invoke");
    }

    private static boolean isType(IMethod node) {
        return node.getName().toString().equals("type");
    }

    private static boolean isInvoke(CGNode node) {
        return MethodHandles.isInvoke(node.getMethod());
    }

    private static boolean isType(CGNode node) {
        return MethodHandles.isType(node.getMethod());
    }

    private static boolean isFindStatic(CGNode node) {
        return MethodHandles.isFindStatic(node.getMethod());
    }

    public static void analyzeMethodHandles(AnalysisOptions options, SSAPropagationCallGraphBuilder builder) {
        options.setSelector(new InvokeExactTargetSelector(options.getMethodTargetSelector()));
        builder.setContextSelector(new ContextSelectorImpl(builder.getContextSelector()));
        builder.setContextInterpreter(new DelegatingSSAContextInterpreter(new InvokeContextInterpreterImpl(), builder.getCFAContextInterpreter()));
        builder.setContextInterpreter(new DelegatingSSAContextInterpreter(new FindContextInterpreterImpl(), builder.getCFAContextInterpreter()));
    }

    private static class InvokeContextInterpreterImpl
    extends HandlersContextInterpreterImpl {
        private InvokeContextInterpreterImpl() {
        }

        @Override
        public boolean understands(CGNode node) {
            return (MethodHandles.isInvoke(node) || MethodHandles.isType(node)) && node.getContext().isA(MethodContext.class);
        }

        @Override
        public IR getIR(CGNode node) {
            if (!this.irs.containsKey(node) || ((SoftReference)this.irs.get(node)).get() == null) {
                MethodSummary code = new MethodSummary(node.getMethod().getReference());
                SummarizedMethod m = new SummarizedMethod(node.getMethod().getReference(), code, node.getMethod().getDeclaringClass());
                SSAInstructionFactory insts = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().instructionFactory();
                assert (node.getContext().isA(MethodContext.class));
                MethodReference ref = ((MethodContext)node.getContext()).method;
                boolean isStatic = node.getClassHierarchy().resolveMethod(ref).isStatic();
                boolean isVoid = ref.getReturnType().equals(TypeReference.Void);
                if (MethodHandles.isInvoke(node)) {
                    String name;
                    switch (name = node.getMethod().getName().toString()) {
                        case "invokeWithArguments": {
                            int nargs = ref.getNumberOfParameters();
                            int[] params = new int[nargs];
                            for (int i = 0; i < nargs; ++i) {
                                code.addConstant(i + nargs + 3, new ConstantValue(i));
                                code.addStatement(insts.ArrayLoadInstruction(code.getNumberOfStatements(), i + 3, 1, i + nargs + 3, TypeReference.JavaLangObject));
                                params[i] = i + 3;
                            }
                            CallSiteReference site = CallSiteReference.make(nargs + 1, ref, (IInvokeInstruction.IDispatch)(isStatic ? IInvokeInstruction.Dispatch.STATIC : IInvokeInstruction.Dispatch.SPECIAL));
                            code.addStatement(insts.InvokeInstruction(code.getNumberOfStatements(), 2 * nargs + 3, params, 2 * nargs + 4, site, null));
                            code.addStatement(insts.ReturnInstruction(code.getNumberOfStatements(), 2 * nargs + 3, false));
                            break;
                        }
                        case "invokeExact": {
                            int nargs = node.getMethod().getReference().getNumberOfParameters();
                            int[] params = new int[nargs];
                            if (nargs != ref.getNumberOfParameters() + (isStatic ? 0 : 1)) break;
                            for (int i = 0; i < nargs; ++i) {
                                params[i] = i + 2;
                            }
                            CallSiteReference site = CallSiteReference.make(0, ref, (IInvokeInstruction.IDispatch)(isStatic ? IInvokeInstruction.Dispatch.STATIC : IInvokeInstruction.Dispatch.SPECIAL));
                            if (isVoid) {
                                code.addStatement(insts.InvokeInstruction(code.getNumberOfStatements(), params, nargs + 2, site, null));
                                break;
                            }
                            code.addStatement(insts.InvokeInstruction(code.getNumberOfStatements(), nargs + 2, params, nargs + 3, site, null));
                            code.addStatement(insts.ReturnInstruction(code.getNumberOfStatements(), nargs + 2, false));
                            break;
                        }
                    }
                } else {
                    assert (MethodHandles.isType(node));
                    code.addStatement(insts.LoadMetadataInstruction(code.getNumberOfStatements(), 2, TypeReference.JavaLangInvokeMethodType, ref.getDescriptor()));
                    code.addStatement(insts.ReturnInstruction(code.getNumberOfStatements(), 2, false));
                }
                this.irs.put(node, new SoftReference<IR>(m.makeIR(node.getContext(), SSAOptions.defaultOptions())));
            }
            return (IR)((SoftReference)this.irs.get(node)).get();
        }
    }

    private static class FindContextInterpreterImpl
    extends HandlersContextInterpreterImpl {
        private FindContextInterpreterImpl() {
        }

        @Override
        public boolean understands(CGNode node) {
            return MethodHandles.isFindStatic(node) && node.getContext().isA(FindContext.class);
        }

        @Override
        public IR getIR(CGNode node) {
            if (!this.irs.containsKey(node) || ((SoftReference)this.irs.get(node)).get() == null) {
                MethodSummary code = new MethodSummary(node.getMethod().getReference());
                SummarizedMethod m = new SummarizedMethod(node.getMethod().getReference(), code, node.getMethod().getDeclaringClass());
                SSAInstructionFactory insts = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().instructionFactory();
                assert (node.getContext().isA(FindContext.class));
                IClass cls = node.getClassHierarchy().lookupClass((TypeReference)((HandlesItem)node.getContext().get((ContextKey)MethodHandles.CLASS_KEY)).item);
                String selector = (String)((HandlesItem)node.getContext().get((ContextKey)MethodHandles.NAME_KEY)).item;
                int vn = 10;
                for (IMethod iMethod : cls.getAllMethods()) {
                    if (!iMethod.getName().toString().contains(selector)) continue;
                    code.addStatement(insts.LoadMetadataInstruction(code.getNumberOfStatements(), vn, TypeReference.JavaLangInvokeMethodHandle, iMethod.getReference()));
                    code.addStatement(insts.ReturnInstruction(code.getNumberOfStatements(), vn, false));
                    ++vn;
                }
                this.irs.put(node, new SoftReference<IR>(m.makeIR(node.getContext(), SSAOptions.defaultOptions())));
            }
            return (IR)((SoftReference)this.irs.get(node)).get();
        }
    }

    private static abstract class HandlersContextInterpreterImpl
    implements SSAContextInterpreter {
        protected final Map<CGNode, SoftReference<IR>> irs = HashMapFactory.make();

        private HandlersContextInterpreterImpl() {
        }

        @Override
        public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
            return this.getIR(node).iterateNewSites();
        }

        public Iterator<FieldReference> iterateFields(CGNode node, Predicate<SSAInstruction> filter) {
            return new MapIterator((Iterator)new FilterIterator(this.getIR(node).iterateNormalInstructions(), filter), object -> ((SSAFieldAccessInstruction)object).getDeclaredField());
        }

        @Override
        public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
            return this.iterateFields(node, SSAGetInstruction.class::isInstance);
        }

        @Override
        public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
            return this.iterateFields(node, SSAPutInstruction.class::isInstance);
        }

        @Override
        public boolean recordFactoryType(CGNode node, IClass klass) {
            return false;
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
            return this.getIR(node).iterateCallSites();
        }

        @Override
        public IRView getIRView(CGNode node) {
            return this.getIR(node);
        }

        @Override
        public DefUse getDU(CGNode node) {
            return new DefUse(this.getIR(node));
        }

        @Override
        public int getNumberOfStatements(CGNode node) {
            return this.getIR(node).getInstructions().length;
        }

        @Override
        public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode n) {
            return this.getIR(n).getControlFlowGraph();
        }
    }

    private static class InvokeExactTargetSelector
    implements MethodTargetSelector {
        private final MethodTargetSelector base;
        private final Map<MethodReference, SyntheticMethod> impls = HashMapFactory.make();

        public InvokeExactTargetSelector(MethodTargetSelector base) {
            this.base = base;
        }

        @Override
        public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass receiver) {
            MethodReference target = site.getDeclaredTarget();
            if (MethodHandles.isInvokeExact(target)) {
                if (!this.impls.containsKey(target)) {
                    SyntheticMethod invokeExactTrampoline = new SyntheticMethod(target, receiver.getClassHierarchy().lookupClass(TypeReference.JavaLangInvokeMethodHandle), false, false){

                        @Override
                        public IR makeIR(Context context, SSAOptions options) throws UnimplementedError {
                            return null;
                        }
                    };
                    this.impls.put(target, invokeExactTrampoline);
                }
                return this.impls.get(target);
            }
            return this.base.getCalleeTarget(caller, site, receiver);
        }
    }

    private static class ContextSelectorImpl
    implements ContextSelector {
        private final ContextSelector base;

        public ContextSelectorImpl(ContextSelector base) {
            this.base = base;
        }

        @Override
        public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] actualParameters) {
            InstanceKey selfKey;
            Context baseContext = this.base.getCalleeTarget(caller, site, callee, actualParameters);
            if ((MethodHandles.isInvoke(callee) || MethodHandles.isType(callee)) && callee.getReference().getDeclaringClass().getName().equals(TypeReference.JavaLangInvokeMethodHandle.getName()) && actualParameters != null && actualParameters.length > 0 && (selfKey = actualParameters[0]) instanceof ConstantKey && ((ConstantKey)selfKey).getConcreteType().getReference().equals(TypeReference.JavaLangInvokeMethodHandle)) {
                MethodReference ref = ((IMethod)((ConstantKey)selfKey).getValue()).getReference();
                return new MethodContext(baseContext, ref);
            }
            if (MethodHandles.isFindStatic(callee) && callee.getDeclaringClass().getReference().equals(TypeReference.JavaLangInvokeMethodHandlesLookup) && actualParameters != null && actualParameters.length > 2) {
                InstanceKey classKey = actualParameters[1];
                InstanceKey nameKey = actualParameters[2];
                if (classKey instanceof ConstantKey && ((ConstantKey)classKey).getConcreteType().getReference().equals(TypeReference.JavaLangClass) && nameKey instanceof ConstantKey && ((ConstantKey)nameKey).getConcreteType().getReference().equals(TypeReference.JavaLangString)) {
                    return new FindContext(baseContext, ((IClass)((ConstantKey)classKey).getValue()).getReference(), (String)((ConstantKey)nameKey).getValue());
                }
            }
            return baseContext;
        }

        @Override
        public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
            MutableIntSet x = IntSetUtil.makeMutableCopy((IntSet)this.base.getRelevantParameters(caller, site));
            x.addAll(MethodHandles.isFindStatic(site.getDeclaredTarget()) ? params : self);
            return x;
        }
    }

    private static class MethodContext
    implements Context {
        private final Context base;
        private final MethodReference method;

        public MethodContext(Context base, MethodReference method) {
            this.base = base;
            this.method = method;
        }

        @Override
        public ContextItem get(ContextKey name) {
            if (METHOD_KEY.equals(name)) {
                return new HandlesItem<MethodReference>(this.method);
            }
            return this.base.get(name);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodContext other = (MethodContext)obj;
            if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
                return false;
            }
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }

        public String toString() {
            return "ctxt:" + this.method.getName();
        }
    }

    public static class FindContext
    implements Context {
        private final Context base;
        private final TypeReference cls;
        private final String selector;

        public FindContext(Context base, TypeReference cls, String methodName) {
            this.base = base;
            this.cls = cls;
            this.selector = methodName;
        }

        @Override
        public ContextItem get(ContextKey name) {
            if (CLASS_KEY.equals(name)) {
                return new HandlesItem<TypeReference>(this.cls);
            }
            if (NAME_KEY.equals(name)) {
                return new HandlesItem<String>(this.selector);
            }
            return this.base.get(name);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
            result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
            result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FindContext other = (FindContext)obj;
            if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
                return false;
            }
            if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
                return false;
            }
            return !(this.selector == null ? other.selector != null : !this.selector.equals(other.selector));
        }
    }

    private static class HandlesItem<T>
    implements ContextItem {
        private final T item;

        public HandlesItem(T method) {
            this.item = method;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HandlesItem other = (HandlesItem)obj;
            return !(this.item == null ? other.item != null : !this.item.equals(other.item));
        }
    }
}

