/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRView;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class JavaLangClassContextInterpreter
implements SSAContextInterpreter {
    public static final MethodReference GET_CONSTRUCTOR = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
    public static final MethodReference GET_CONSTRUCTORS = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getConstructors", "()[Ljava/lang/reflect/Constructor;");
    public static final MethodReference GET_METHOD = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
    public static final MethodReference GET_METHODS = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getMethods", "()[Ljava/lang/reflect/Method;");
    public static final MethodReference GET_DECLARED_CONSTRUCTOR = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
    public static final MethodReference GET_DECLARED_CONSTRUCTORS = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;");
    public static final MethodReference GET_DECLARED_METHOD = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
    public static final MethodReference GET_DECLARED_METHODS = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getDeclaredMethods", "()[Ljava/lang/reflect/Method;");
    private static final boolean DEBUG = false;
    private final Map<String, IR> cache = HashMapFactory.make();

    @Override
    public IR getIR(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        Context context = node.getContext();
        IMethod method = node.getMethod();
        String hashKey = method.toString() + "@" + context.toString();
        IR result = this.cache.get(hashKey);
        if (result == null) {
            result = JavaLangClassContextInterpreter.makeIR(method, context);
            if (result == null) {
                Assertions.UNREACHABLE((String)("Unexpected method " + node));
            }
            this.cache.put(hashKey, result);
        }
        return result;
    }

    @Override
    public IRView getIRView(CGNode node) {
        return this.getIR(node);
    }

    private static IR makeIR(IMethod method, Context context) {
        HashMap constants = HashMapFactory.make();
        if (method.getReference().equals(GET_CONSTRUCTOR)) {
            SSAInstruction[] instrs = JavaLangClassContextInterpreter.makeGetCtorStatements(context, constants);
            return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
        }
        if (method.getReference().equals(GET_CONSTRUCTORS)) {
            SSAInstruction[] instrs = JavaLangClassContextInterpreter.makeGetCtorsStatements(context, constants);
            return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
        }
        if (method.getReference().equals(GET_METHOD)) {
            SSAInstruction[] instrs = JavaLangClassContextInterpreter.makeGetMethodStatements(context, constants);
            return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
        }
        if (method.getReference().equals(GET_METHODS)) {
            SSAInstruction[] instrs = JavaLangClassContextInterpreter.makeGetMethodsStatments(context, constants);
            return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
        }
        if (method.getReference().equals(GET_DECLARED_CONSTRUCTOR)) {
            SSAInstruction[] instrs = JavaLangClassContextInterpreter.makeGetDeclCtorStatements(context, constants);
            return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
        }
        if (method.getReference().equals(GET_DECLARED_CONSTRUCTORS)) {
            SSAInstruction[] instrs = JavaLangClassContextInterpreter.makeGetDeclCtorsStatements(context, constants);
            return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
        }
        if (method.getReference().equals(GET_DECLARED_METHOD)) {
            SSAInstruction[] instrs = JavaLangClassContextInterpreter.makeGetDeclaredMethodStatements(context, constants);
            return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
        }
        if (method.getReference().equals(GET_DECLARED_METHODS)) {
            SSAInstruction[] instrs = JavaLangClassContextInterpreter.makeGetDeclaredMethodsStatements(context, constants);
            return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
        }
        Assertions.UNREACHABLE((String)("Unexpected method " + method));
        return null;
    }

    @Override
    public int getNumberOfStatements(CGNode node) {
        assert (this.understands(node));
        return this.getIR(node).getInstructions().length;
    }

    @Override
    public boolean understands(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!node.getContext().isA(JavaTypeContext.class)) {
            return false;
        }
        MethodReference mRef = node.getMethod().getReference();
        return mRef.equals(GET_CONSTRUCTOR) || mRef.equals(GET_CONSTRUCTORS) || mRef.equals(GET_METHOD) || mRef.equals(GET_METHODS) || mRef.equals(GET_DECLARED_CONSTRUCTOR) || mRef.equals(GET_DECLARED_CONSTRUCTORS) || mRef.equals(GET_DECLARED_METHOD) || mRef.equals(GET_DECLARED_METHODS);
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        Context context = node.getContext();
        TypeReference tr = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getTypeReference();
        if (tr != null) {
            return new NonNullSingletonIterator((Object)NewSiteReference.make(0, tr));
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
        assert (this.understands(node));
        return EmptyIterator.instance();
    }

    private static Collection<IMethod> getDeclaredNormalMethods(IClass cls) {
        HashSet result = HashSetFactory.make();
        for (IMethod iMethod : cls.getDeclaredMethods()) {
            if (iMethod.isInit() || iMethod.isClinit()) continue;
            result.add(iMethod);
        }
        return result;
    }

    private static Collection<IMethod> getAllNormalPublicMethods(IClass cls) {
        HashSet result = HashSetFactory.make();
        Collection<? extends IMethod> allMethods = cls.getAllMethods();
        for (IMethod iMethod : allMethods) {
            if (iMethod.isInit() || iMethod.isClinit() || !iMethod.isPublic()) continue;
            result.add(iMethod);
        }
        return result;
    }

    private static Collection<IMethod> getConstructors(IClass cls) {
        HashSet result = HashSetFactory.make();
        for (IMethod iMethod : cls.getDeclaredMethods()) {
            if (!iMethod.isInit()) continue;
            result.add(iMethod);
        }
        return result;
    }

    private static Collection<IMethod> getPublicConstructors(IClass cls) {
        HashSet result = HashSetFactory.make();
        for (IMethod iMethod : cls.getDeclaredMethods()) {
            if (!iMethod.isInit() || !iMethod.isPublic()) continue;
            result.add(iMethod);
        }
        return result;
    }

    private static SSAInstruction[] getMethodArrayStatements(MethodReference ref, Collection<IMethod> returnValues, Context context, Map<Integer, ConstantValue> constants) {
        ArrayList<SSAInstruction> statements = new ArrayList<SSAInstruction>();
        int nextLocal = ref.getNumberOfParameters() + 2;
        int retValue = nextLocal++;
        IClass cls = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType();
        SSAInstructionFactory insts = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType().getClassLoader().getInstructionFactory();
        if (cls != null) {
            TypeReference arrType = ref.getReturnType();
            NewSiteReference site = new NewSiteReference(retValue, arrType);
            int sizeVn = nextLocal++;
            constants.put(sizeVn, new ConstantValue(returnValues.size()));
            SSANewInstruction allocArr = insts.NewInstruction(statements.size(), retValue, site, new int[]{sizeVn});
            statements.add(allocArr);
            int i = 0;
            for (IMethod m : returnValues) {
                int c = nextLocal++;
                constants.put(c, new ConstantValue(m));
                int index = i++;
                int indexVn = nextLocal++;
                constants.put(indexVn, new ConstantValue(index));
                SSAArrayStoreInstruction store = insts.ArrayStoreInstruction(statements.size(), retValue, indexVn, c, TypeReference.JavaLangReflectConstructor);
                statements.add(store);
            }
            SSAReturnInstruction R = insts.ReturnInstruction(statements.size(), retValue, false);
            statements.add(R);
        }
        return statements.toArray(new SSAInstruction[0]);
    }

    private static SSAInstruction[] getParticularMethodStatements(MethodReference ref, Collection<IMethod> returnValues, Context context, Map<Integer, ConstantValue> constants) {
        ArrayList<SSAReturnInstruction> statements = new ArrayList<SSAReturnInstruction>();
        int nextLocal = ref.getNumberOfParameters() + 2;
        IClass cls = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType();
        SSAInstructionFactory insts = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType().getClassLoader().getInstructionFactory();
        if (cls != null) {
            for (IMethod m : returnValues) {
                int c = nextLocal++;
                constants.put(c, new ConstantValue(m));
                SSAReturnInstruction R = insts.ReturnInstruction(statements.size(), c, false);
                statements.add(R);
            }
        }
        return statements.toArray(new SSAInstruction[0]);
    }

    private static SSAInstruction[] makeGetCtorStatements(Context context, Map<Integer, ConstantValue> constants) {
        IClass cls = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType();
        if (cls == null) {
            return JavaLangClassContextInterpreter.getParticularMethodStatements(GET_CONSTRUCTOR, null, context, constants);
        }
        return JavaLangClassContextInterpreter.getParticularMethodStatements(GET_CONSTRUCTOR, JavaLangClassContextInterpreter.getPublicConstructors(cls), context, constants);
    }

    private static SSAInstruction[] makeGetCtorsStatements(Context context, Map<Integer, ConstantValue> constants) {
        IClass cls = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType();
        if (cls == null) {
            return JavaLangClassContextInterpreter.getMethodArrayStatements(GET_DECLARED_CONSTRUCTORS, null, context, constants);
        }
        return JavaLangClassContextInterpreter.getMethodArrayStatements(GET_DECLARED_CONSTRUCTORS, JavaLangClassContextInterpreter.getPublicConstructors(cls), context, constants);
    }

    private static SSAInstruction[] makeGetMethodStatements(Context context, Map<Integer, ConstantValue> constants) {
        IClass cls = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType();
        if (cls == null) {
            return JavaLangClassContextInterpreter.getParticularMethodStatements(GET_METHOD, null, context, constants);
        }
        return JavaLangClassContextInterpreter.getParticularMethodStatements(GET_METHOD, JavaLangClassContextInterpreter.getAllNormalPublicMethods(cls), context, constants);
    }

    private static SSAInstruction[] makeGetMethodsStatments(Context context, Map<Integer, ConstantValue> constants) {
        IClass cls = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType();
        if (cls == null) {
            return JavaLangClassContextInterpreter.getMethodArrayStatements(GET_METHODS, null, context, constants);
        }
        return JavaLangClassContextInterpreter.getMethodArrayStatements(GET_METHODS, JavaLangClassContextInterpreter.getAllNormalPublicMethods(cls), context, constants);
    }

    private static SSAInstruction[] makeGetDeclCtorStatements(Context context, Map<Integer, ConstantValue> constants) {
        IClass cls = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType();
        if (cls == null) {
            return JavaLangClassContextInterpreter.getParticularMethodStatements(GET_DECLARED_CONSTRUCTOR, null, context, constants);
        }
        return JavaLangClassContextInterpreter.getParticularMethodStatements(GET_DECLARED_CONSTRUCTOR, JavaLangClassContextInterpreter.getConstructors(cls), context, constants);
    }

    private static SSAInstruction[] makeGetDeclCtorsStatements(Context context, Map<Integer, ConstantValue> constants) {
        IClass cls = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType();
        if (cls == null) {
            return JavaLangClassContextInterpreter.getMethodArrayStatements(GET_DECLARED_CONSTRUCTORS, null, context, constants);
        }
        return JavaLangClassContextInterpreter.getMethodArrayStatements(GET_DECLARED_CONSTRUCTORS, JavaLangClassContextInterpreter.getConstructors(cls), context, constants);
    }

    private static SSAInstruction[] makeGetDeclaredMethodStatements(Context context, Map<Integer, ConstantValue> constants) {
        IClass cls = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType();
        if (cls == null) {
            return JavaLangClassContextInterpreter.getParticularMethodStatements(GET_DECLARED_METHOD, null, context, constants);
        }
        return JavaLangClassContextInterpreter.getParticularMethodStatements(GET_DECLARED_METHOD, JavaLangClassContextInterpreter.getDeclaredNormalMethods(cls), context, constants);
    }

    private static SSAInstruction[] makeGetDeclaredMethodsStatements(Context context, Map<Integer, ConstantValue> constants) {
        IClass cls = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType();
        if (cls == null) {
            return JavaLangClassContextInterpreter.getMethodArrayStatements(GET_DECLARED_METHODS, null, context, constants);
        }
        return JavaLangClassContextInterpreter.getMethodArrayStatements(GET_DECLARED_METHODS, JavaLangClassContextInterpreter.getDeclaredNormalMethods(cls), context, constants);
    }

    @Override
    public boolean recordFactoryType(CGNode node, IClass klass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
        return EmptyIterator.instance();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode N) {
        return this.getIR(N).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode node) {
        return new DefUse(this.getIR(node));
    }
}

