/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.ClassFactoryContextSelector;
import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRView;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ClassFactoryContextInterpreter
implements SSAContextInterpreter {
    private static final boolean DEBUG = false;
    private final Map<String, IR> cache = HashMapFactory.make();

    @Override
    public IR getIR(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        Context context = node.getContext();
        IMethod method = node.getMethod();
        String hashKey = method.toString() + "@" + context.toString();
        IR result = this.cache.get(hashKey);
        if (result == null) {
            result = ClassFactoryContextInterpreter.makeIR(method, context);
            this.cache.put(hashKey, result);
        }
        return result;
    }

    @Override
    public IRView getIRView(CGNode node) {
        return this.getIR(node);
    }

    @Override
    public int getNumberOfStatements(CGNode node) {
        assert (this.understands(node));
        return this.getIR(node).getInstructions().length;
    }

    @Override
    public boolean understands(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!node.getContext().isA(JavaTypeContext.class)) {
            return false;
        }
        return ClassFactoryContextSelector.isClassFactory(node.getMethod().getReference());
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        TypeReference tr = ((TypeAbstraction)node.getContext().get(ContextKey.RECEIVER)).getTypeReference();
        if (tr != null) {
            return new NonNullSingletonIterator((Object)NewSiteReference.make(0, tr));
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
        assert (this.understands(node));
        return EmptyIterator.instance();
    }

    private static SSAInstruction[] makeStatements(Context context) {
        SSAInstructionFactory insts = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getType().getClassLoader().getInstructionFactory();
        ArrayList<SSAInstruction> statements = new ArrayList<SSAInstruction>();
        int retValue = 2;
        TypeReference tr = ((TypeAbstraction)context.get(ContextKey.RECEIVER)).getTypeReference();
        if (tr != null) {
            SSALoadMetadataInstruction l = insts.LoadMetadataInstruction(statements.size(), retValue, TypeReference.JavaLangClass, tr);
            statements.add(l);
            SSAReturnInstruction R = insts.ReturnInstruction(statements.size(), retValue, false);
            statements.add(R);
        } else {
            SSAThrowInstruction t = insts.ThrowInstruction(statements.size(), retValue);
            statements.add(t);
        }
        SSAInstruction[] result = new SSAInstruction[statements.size()];
        statements.toArray(result);
        return result;
    }

    private static IR makeIR(IMethod method, Context context) {
        SSAInstruction[] instrs = ClassFactoryContextInterpreter.makeStatements(context);
        return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), null);
    }

    @Override
    public boolean recordFactoryType(CGNode node, IClass klass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
        return EmptyIterator.instance();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode N) {
        return this.getIR(N).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode node) {
        return new DefUse(this.getIR(node));
    }
}

