/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.exceptionanalysis;

import com.ibm.wala.analysis.exceptionanalysis.CGIntraproceduralExceptionAnalysis;
import com.ibm.wala.analysis.exceptionanalysis.Exception2BitvectorTransformer;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorMinusVector;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.BitVectorUnionVector;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.intset.BitVector;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExceptionTransferFunctionProvider
implements ITransferFunctionProvider<CGNode, BitVectorVariable> {
    private final Exception2BitvectorTransformer transformer;
    private final CallGraph cg;
    private final CGIntraproceduralExceptionAnalysis intraResult;

    public ExceptionTransferFunctionProvider(CGIntraproceduralExceptionAnalysis intraResult, CallGraph cg, Exception2BitvectorTransformer transformer) {
        this.cg = cg;
        this.transformer = transformer;
        this.intraResult = intraResult;
    }

    public boolean hasNodeTransferFunctions() {
        return true;
    }

    public boolean hasEdgeTransferFunctions() {
        return true;
    }

    public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
        return BitVectorUnion.instance();
    }

    public UnaryOperator<BitVectorVariable> getNodeTransferFunction(CGNode node) {
        Set<TypeReference> exceptions = this.intraResult.getAnalysis(node).getExceptions();
        BitVector bitVector = this.transformer.computeBitVector(exceptions);
        return new BitVectorUnionVector(bitVector);
    }

    public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(CGNode dst, CGNode src) {
        Iterator<CallSiteReference> callsites = this.cg.getPossibleSites(src, dst);
        BitVector filtered = new BitVector(this.transformer.getValues().getSize());
        if (callsites.hasNext()) {
            CallSiteReference callsite = callsites.next();
            LinkedHashSet<TypeReference> caught = new LinkedHashSet<TypeReference>(this.intraResult.getAnalysis(src).getCaughtExceptions(callsite));
            while (callsites.hasNext()) {
                callsite = callsites.next();
                caught.retainAll(this.intraResult.getAnalysis(src).getCaughtExceptions(callsite));
            }
            filtered = this.transformer.computeBitVector(caught);
            return new BitVectorMinusVector(filtered);
        }
        throw new RuntimeException("Internal Error: Got call graph edge without call site.");
    }
}

