/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.arraybounds.hypergraph.weight;

public class Weight {
    public static final Weight UNLIMITED = new Weight(Type.UNLIMITED, 0);
    public static final Weight NOT_SET = new Weight(Type.NOT_SET, 0);
    public static final Weight ZERO = new Weight(Type.NUMBER, 0);
    private final Type type;
    private final int number;

    public Weight(int number) {
        this.type = Type.NUMBER;
        this.number = number;
    }

    public Weight(Type type, int number) {
        this.type = type;
        this.number = number;
    }

    public Weight add(Weight other) {
        Weight result = null;
        result = this.getType() == Type.NUMBER ? (other.getType() == Type.NUMBER ? new Weight(Type.NUMBER, this.getNumber() + other.getNumber()) : other) : this;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Weight other = (Weight)obj;
        if (this.number != other.number) {
            return false;
        }
        return this.type == other.type;
    }

    public int getNumber() {
        return this.number;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.number;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String toString() {
        if (this.type == Type.NUMBER) {
            return Integer.toString(this.number);
        }
        if (this.type == Type.NOT_SET) {
            return "NOT_SET";
        }
        if (this.type == Type.UNLIMITED) {
            return "UNLIMITED";
        }
        return "Type: " + this.type;
    }

    public static enum Type {
        NUMBER,
        NOT_SET,
        UNLIMITED;

    }
}

