/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.engine;

import java.io.Reader;
import java.util.Map;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.engine.DefaultTemplateEngine;
import org.beetl.core.engine.GrammarCreator;
import org.beetl.core.om.AABuilder;
import org.beetl.core.om.AsmAAFactory;
import org.beetl.core.statement.BlockStatement;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Program;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.VarAttribute;
import org.beetl.core.statement.VarRef;
import org.beetl.core.statement.optimal.BlockStatementOptimal;
import org.beetl.core.statement.optimal.VarRefOptimal;

public class FastRuntimeEngine
extends DefaultTemplateEngine {
    public FastRuntimeEngine() {
        AABuilder.defalutAAFactory = new AsmAAFactory();
    }

    @Override
    public Program createProgram(Resource rs, Reader reader, Map<Integer, String> textMap, String cr, GroupTemplate gt) {
        return super.createProgram(rs, reader, textMap, cr, gt);
    }

    @Override
    protected GrammarCreator getGrammarCreator(GroupTemplate groupTemplate) {
        FastGrammarCreator result = new FastGrammarCreator();
        super.setStrictDisableGrammars(result, groupTemplate);
        return result;
    }

    private static class FastGrammarCreator
    extends GrammarCreator {
        private FastGrammarCreator() {
        }

        @Override
        public VarRef createVarRef(VarAttribute[] attributes, boolean hasSafe, Expression safe, GrammarToken token, GrammarToken firstToken) {
            this.disableSyntaxCheck("VarRefOptimal");
            return attributes.length == 1 && !hasSafe ? new VarRefOptimal(attributes[0], token, firstToken) : new VarRef(attributes, hasSafe, safe, firstToken);
        }

        @Override
        public BlockStatement createBlock(Statement[] nodes, GrammarToken token) {
            return nodes.length == 1 ? new BlockStatementOptimal(nodes, token) : new BlockStatement(nodes, token);
        }
    }
}

