/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.beetl.android.text.TextUtils;
import org.beetl.core.text.HtmlTagConfig;
import org.beetl.core.text.PlaceHolderDelimeter;
import org.beetl.core.text.ScriptDelimeter;
import org.jetbrains.annotations.NotNull;

public class Configuration {
    String charset = "UTF-8";
    String placeholderStart = "${";
    String placeholderEnd = "}";
    String placeholderStart2 = null;
    String placeholderEnd2 = null;
    String statementStart = "<%";
    String statementEnd = "%>";
    String statementStart2 = null;
    String statementEnd2 = null;
    String htmlTagFlag = "#";
    boolean isHtmlTagSupport = false;
    String htmlTagStart;
    String htmlTagEnd;
    boolean nativeCall = false;
    boolean directByteOutput = false;
    boolean isStrict = false;
    boolean isIgnoreClientIOError = true;
    String errorHandlerClass = "org.beetl.core.ConsoleErrorHandler";
    String htmlTagBindingAttribute = "var";
    String htmlTagAttributeConvert = "org.beetl.core.text.DefaultAttributeNameConvert";
    Set<String> pkgList = new HashSet<String>();
    String webAppExt = null;
    boolean hasFunctionLimiter = false;
    String functionLimiterStart = null;
    String functionLimiterEnd = null;
    String engine = "org.beetl.core.FastRuntimeEngine";
    String nativeSecurity = "org.beetl.core.DefaultNativeSecurityManager";
    String resourceLoader = "org.beetl.core.resource.ClasspathResourceLoader";
    Map<String, String> fnMap = new HashMap<String, String>();
    Map<String, String> fnPkgMap = new HashMap<String, String>();
    Map<String, String> formatMap = new HashMap<String, String>();
    Map<String, String> defaultFormatMap = new HashMap<String, String>(0);
    Set<String> generalVirtualAttributeSet = new HashSet<String>();
    Map<String, String> virtualClass = new HashMap<String, String>();
    Map<String, String> tagFactoryMap = new HashMap<String, String>();
    Map<String, String> tagMap = new HashMap<String, String>();
    Map<String, String> resourceMap = new HashMap<String, String>();
    private static final int BUFFER_MIN_SIZE = 256;
    int bufferSize = 4096;
    int bufferNum = 64;
    boolean safeOutput = false;
    public static final String DELIMITER_PLACEHOLDER_START = "DELIMITER_PLACEHOLDER_START";
    public static final String DELIMITER_PLACEHOLDER_END = "DELIMITER_PLACEHOLDER_END";
    public static final String DELIMITER_STATEMENT_START = "DELIMITER_STATEMENT_START";
    public static final String DELIMITER_STATEMENT_END = "DELIMITER_STATEMENT_END";
    public static final String DELIMITER_PLACEHOLDER_START2 = "DELIMITER_PLACEHOLDER_START2";
    public static final String DELIMITER_PLACEHOLDER_END2 = "DELIMITER_PLACEHOLDER_END2";
    public static final String DELIMITER_STATEMENT_START2 = "DELIMITER_STATEMENT_START2";
    public static final String DELIMITER_STATEMENT_END2 = "DELIMITER_STATEMENT_END2";
    public static final String NATIVE_CALL = "NATIVE_CALL";
    public static final String IGNORE_CLIENT_IO_ERROR = "IGNORE_CLIENT_IO_ERROR";
    public static final String DIRECT_BYTE_OUTPUT = "DIRECT_BYTE_OUTPUT";
    public static final String TEMPLATE_ROOT = "TEMPLATE_ROOT";
    public static final String TEMPLATE_CHARSET = "TEMPLATE_CHARSET";
    public static final String ERROR_HANDLER = "ERROR_HANDLER";
    public static final String MVC_STRICT = "MVC_STRICT";
    public static final String WEBAPP_EXT = "WEBAPP_EXT";
    public static final String HTML_TAG_SUPPORT = "HTML_TAG_SUPPORT";
    public static final String HTML_TAG_FLAG = "HTML_TAG_FLAG";
    public static final String HTML_TAG_ATTR_CONVERT = "HTML_TAG_ATTR_CONVERT";
    public static final String IMPORT_PACKAGE = "IMPORT_PACKAGE";
    public static final String ENGINE = "ENGINE";
    public static final String NATIVE_SECUARTY_MANAGER = "NATIVE_SECUARTY_MANAGER";
    public static final String RESOURCE_LOADER = "RESOURCE_LOADER";
    public static final String HTML_TAG_BINDING_ATTRIBUTE = "HTML_TAG_BINDING_ATTRIBUTE";
    public static final String BUFFER_SIZE = "buffer.maxSize";
    public static final String BUFFER_NUM = "buffer.num";
    public static final String SAFE_OUTPUT = "SAFE_OUTPUT";
    Properties ps = null;
    DelimeterHolder pd = null;
    DelimeterHolder sd = null;
    HtmlTagHolder tagConf = null;
    ClassLoader classLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : Configuration.class.getClassLoader();

    public static Configuration defaultConfiguration() throws IOException {
        return new Configuration();
    }

    public Configuration() throws IOException {
        this.initDefault();
    }

    public Configuration(Properties ps) throws IOException {
        this.initDefault();
        this.parseProperties(ps);
    }

    public void build() {
        this.buildDelimeter();
    }

    private void buildDelimeter() {
        if (TextUtils.isBlank(this.placeholderStart) || TextUtils.isBlank(this.placeholderEnd)) {
            throw new IllegalArgumentException("\u5360\u4f4d\u7b26\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.placeholderStart2 != null) {
            if (TextUtils.isBlank(this.placeholderStart2) || TextUtils.isBlank(this.placeholderEnd2)) {
                throw new IllegalArgumentException("\u5b9a\u4e49\u4e862\u5bf9\u5360\u4f4d\u7b26\u914d\u7f6e\uff0c\u4f46\u5360\u4f4d\u7b262\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.pd = new DelimeterHolder(this.placeholderStart.toCharArray(), this.placeholderEnd.toCharArray(), this.placeholderStart2.toCharArray(), this.placeholderEnd2.toCharArray());
        } else {
            this.pd = new DelimeterHolder(this.placeholderStart.toCharArray(), this.placeholderEnd.toCharArray());
        }
        if (TextUtils.isBlank(this.statementStart)) {
            throw new IllegalArgumentException("\u5b9a\u754c\u7b26\u8d77\u59cb\u7b26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.statementStart2 != null) {
            if (TextUtils.isBlank(this.statementStart2)) {
                throw new IllegalArgumentException("\u5b9a\u4e49\u4e862\u5bf9\u5b9a\u754c\u7b26\u914d\u7f6e\uff0c\u4f46\u5b9a\u754c\u7b26\u8d77\u59cb\u7b26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.sd = new DelimeterHolder(this.statementStart.toCharArray(), this.statementEnd != null ? this.statementEnd.toCharArray() : null, this.statementStart2.toCharArray(), this.statementEnd2 != null ? this.statementEnd2.toCharArray() : null);
        } else {
            this.sd = new DelimeterHolder(this.statementStart.toCharArray(), this.statementEnd != null ? this.statementEnd.toCharArray() : null);
        }
        this.tagConf = new HtmlTagHolder(this.htmlTagStart, this.htmlTagEnd, this.htmlTagBindingAttribute, this.isHtmlTagSupport);
    }

    private void initDefault() throws IOException {
        this.resetHtmlTag();
        this.pkgList.add("java.util.");
        this.pkgList.add("java.lang.");
        this.ps = new Properties();
        this.ps.load(Configuration.class.getResourceAsStream("/org/beetl/core/beetl-default.properties"));
        this.parseProperties(this.ps);
        InputStream ins = Configuration.class.getResourceAsStream("/beetl.properties");
        if (ins != null) {
            this.ps.clear();
            this.ps.load(ins);
            this.parseProperties(this.ps);
        }
    }

    private void resetHtmlTag() {
        this.htmlTagStart = "<" + this.htmlTagFlag;
        this.htmlTagEnd = "</" + this.htmlTagFlag;
    }

    public void add(File file) throws IOException {
        Properties ps = new Properties();
        ps.load(new FileReader(file));
        this.parseProperties(ps);
    }

    public void add(String resourceAsStreamPath) throws IOException {
        Properties ps = new Properties();
        ps.load(Configuration.class.getResourceAsStream(resourceAsStreamPath));
        this.parseProperties(ps);
    }

    protected void parseProperties(Properties ps) {
        Set<Map.Entry<Object, Object>> set = ps.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.setValue(key, value == null ? null : value.trim());
        }
    }

    protected void setValue(String key, String value) {
        if (key.equalsIgnoreCase(TEMPLATE_CHARSET)) {
            this.charset = value;
        } else if (key.equalsIgnoreCase(DELIMITER_PLACEHOLDER_START)) {
            this.placeholderStart = value;
        } else if (key.equalsIgnoreCase(DELIMITER_PLACEHOLDER_END)) {
            this.placeholderEnd = value;
        } else if (key.equalsIgnoreCase(DELIMITER_STATEMENT_START)) {
            this.statementStart = value;
        } else if (key.equalsIgnoreCase(DELIMITER_STATEMENT_END)) {
            this.statementEnd = TextUtils.isEmpty(value) || TextUtils.equals(value, "null") ? null : value;
        } else if (key.equalsIgnoreCase(DELIMITER_PLACEHOLDER_START2)) {
            this.placeholderStart2 = value;
        } else if (key.equalsIgnoreCase(DELIMITER_PLACEHOLDER_END2)) {
            this.placeholderEnd2 = value;
        } else if (key.equalsIgnoreCase(DELIMITER_STATEMENT_START2)) {
            this.statementStart2 = value;
        } else if (key.equalsIgnoreCase(DELIMITER_STATEMENT_END2)) {
            this.statementEnd2 = TextUtils.isBlank(value) || TextUtils.equals(value, "null") ? null : value;
        } else if (key.equalsIgnoreCase(NATIVE_CALL)) {
            this.nativeCall = Boolean.parseBoolean(value);
        } else if (key.equalsIgnoreCase(SAFE_OUTPUT)) {
            this.safeOutput = Boolean.parseBoolean(value);
        } else if (key.equalsIgnoreCase(IGNORE_CLIENT_IO_ERROR)) {
            this.isIgnoreClientIOError = Boolean.parseBoolean(value);
        } else if (key.equalsIgnoreCase(DIRECT_BYTE_OUTPUT)) {
            this.directByteOutput = Boolean.parseBoolean(value);
        } else if (key.equalsIgnoreCase(ERROR_HANDLER)) {
            this.errorHandlerClass = TextUtils.isBlank(value) || value.equals("null") ? null : value;
        } else if (key.equalsIgnoreCase(WEBAPP_EXT)) {
            this.webAppExt = TextUtils.isEmpty(value) ? null : value;
        } else if (key.equalsIgnoreCase(MVC_STRICT)) {
            this.isStrict = Boolean.parseBoolean(value);
        } else if (key.equalsIgnoreCase(HTML_TAG_SUPPORT)) {
            this.isHtmlTagSupport = Boolean.parseBoolean(value);
        } else if (key.equalsIgnoreCase(HTML_TAG_ATTR_CONVERT)) {
            if (!TextUtils.isBlank(value)) {
                this.htmlTagAttributeConvert = value;
            }
        } else if (key.equalsIgnoreCase(HTML_TAG_FLAG)) {
            this.htmlTagFlag = value;
            this.resetHtmlTag();
        } else if (key.equalsIgnoreCase(HTML_TAG_BINDING_ATTRIBUTE)) {
            this.htmlTagBindingAttribute = value;
        } else if (key.equalsIgnoreCase(IMPORT_PACKAGE)) {
            String[] strs = value.split(";");
            this.pkgList.addAll(Arrays.asList(TextUtils.split(value, ",")));
        } else if (key.equalsIgnoreCase(ENGINE)) {
            this.engine = value;
        } else if (key.equalsIgnoreCase(NATIVE_SECUARTY_MANAGER)) {
            this.nativeSecurity = value;
        } else if (key.equalsIgnoreCase(RESOURCE_LOADER)) {
            this.resourceLoader = value;
        } else if (key.equalsIgnoreCase(RESOURCE_LOADER)) {
            this.resourceLoader = value;
        } else if (key.equalsIgnoreCase(BUFFER_SIZE)) {
            this.bufferSize = Integer.parseInt(value);
            if (this.bufferSize < 256) {
                throw new IllegalStateException("GLOBAL.buffer.maxSize \u914d\u7f6e\u4e0d\u80fd\u5c0f\u4e8e256");
            }
        } else if (key.equalsIgnoreCase(BUFFER_NUM)) {
            this.bufferNum = Integer.parseInt(value);
        } else if (key.startsWith("fn.") || key.startsWith("FN.")) {
            String fn = this.checkValue(value);
            if (fn != null) {
                this.fnMap.put(Configuration.getExtName(key), fn);
            }
        } else if (key.startsWith("fnp.") || key.startsWith("FNP.")) {
            String fnPkg = this.checkValue(value);
            if (fnPkg != null) {
                this.fnPkgMap.put(Configuration.getExtName(key), fnPkg);
            }
        } else if (key.startsWith("ft.") || key.startsWith("FT.")) {
            String format = this.checkValue(value);
            if (format != null) {
                this.formatMap.put(Configuration.getExtName(key), format);
            }
        } else if (key.startsWith("ftc.") || key.startsWith("FTC.")) {
            String defaultFormat = this.checkValue(value);
            if (value != null) {
                this.defaultFormatMap.put(Configuration.getExtName(key), defaultFormat);
            }
        } else if (key.startsWith("virtual.") || key.startsWith("VIRTUAL.")) {
            String virtual = this.checkValue(value);
            if (virtual != null) {
                this.virtualClass.put(Configuration.getExtName(key), virtual);
            }
        } else if (key.startsWith("general_virtual.") || key.startsWith("GENERAL_VIRTUAL.")) {
            this.generalVirtualAttributeSet.addAll(Arrays.asList(TextUtils.split(value, ";")));
        } else if (key.startsWith("tag.") || key.startsWith("TAG.")) {
            String tag = this.checkValue(value);
            if (tag != null) {
                this.tagMap.put(Configuration.getExtName(key), tag);
            }
        } else if (key.startsWith("tagf.") || key.startsWith("TAGF.")) {
            this.tagFactoryMap.put(Configuration.getExtName(key), value);
        } else if (key.startsWith("resource.") || key.startsWith("RESOURCE.")) {
            this.resourceMap.put(Configuration.getExtName(key), value);
        }
    }

    protected String checkValue(String value) {
        String[] vals = TextUtils.split(value, ",");
        if (vals.length == 1) {
            return value;
        }
        String cls = vals[1];
        try {
            Class.forName(cls, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return vals[0];
    }

    private static String getExtName(@NotNull String key) {
        return key.substring(key.indexOf(".") + 1);
    }

    public String getCharset() {
        return this.charset;
    }

    public String getPlaceholderStart() {
        return this.placeholderStart;
    }

    public void setPlaceholderStart(String placeholderStart) {
        this.placeholderStart = placeholderStart;
    }

    public String getPlaceholderEnd() {
        return this.placeholderEnd;
    }

    public void setPlaceholderEnd(String placeholderEnd) {
        this.placeholderEnd = placeholderEnd;
    }

    public String getStatementStart() {
        return this.statementStart;
    }

    public void setStatementStart(String statementStart) {
        this.statementStart = statementStart;
    }

    public String getStatementEnd() {
        return this.statementEnd;
    }

    public void setStatementEnd(String statementEnd) {
        this.statementEnd = statementEnd;
    }

    public String getPlaceholderStart2() {
        return this.placeholderStart2;
    }

    public void setPlaceholderStart2(String placeholderStart2) {
        this.placeholderStart2 = placeholderStart2;
    }

    public String getPlaceholderEnd2() {
        return this.placeholderEnd2;
    }

    public void setPlaceholderEnd2(String placeholderEnd2) {
        this.placeholderEnd2 = placeholderEnd2;
    }

    public String getStatementStart2() {
        return this.statementStart2;
    }

    public void setStatementStart2(String statementStart2) {
        this.statementStart2 = statementStart2;
    }

    public String getStatementEnd2() {
        return this.statementEnd2;
    }

    public void setStatementEnd2(String statementEnd2) {
        this.statementEnd2 = statementEnd2;
    }

    public String getHtmlTagFlag() {
        return this.htmlTagFlag;
    }

    public void setHtmlTagFlag(String htmlTagFlag) {
        this.htmlTagFlag = htmlTagFlag;
    }

    public DelimeterHolder getPlaceHolderDelimeter() {
        return this.pd;
    }

    public DelimeterHolder getScriptDelimeter() {
        return this.sd;
    }

    public HtmlTagHolder getTagConf() {
        return this.tagConf;
    }

    public void setTagConf(HtmlTagHolder tagConf) {
        this.tagConf = tagConf;
    }

    public boolean isHtmlTagSupport() {
        return this.isHtmlTagSupport;
    }

    public void setHtmlTagSupport(boolean isHtmlTagSupport) {
        this.isHtmlTagSupport = isHtmlTagSupport;
    }

    public boolean isNativeCall() {
        return this.nativeCall;
    }

    public void setNativeCall(boolean nativeCall) {
        this.nativeCall = nativeCall;
    }

    public boolean isDirectByteOutput() {
        return this.directByteOutput;
    }

    public void setDirectByteOutput(boolean directByteOutput) {
        this.directByteOutput = directByteOutput;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean isStrict) {
        this.isStrict = isStrict;
    }

    public String getHtmlTagStart() {
        return this.htmlTagStart;
    }

    public void setHtmlTagStart(String htmlTagStart) {
        this.htmlTagStart = htmlTagStart;
    }

    public String getHtmlTagEnd() {
        return this.htmlTagEnd;
    }

    public void setHtmlTagEnd(String htmlTagEnd) {
        this.htmlTagEnd = htmlTagEnd;
    }

    public String getHtmlTagBindingAttribute() {
        return this.htmlTagBindingAttribute;
    }

    public void setHtmlTagBindingAttribute(String htmlTagBindingAttribute) {
        this.htmlTagBindingAttribute = htmlTagBindingAttribute;
    }

    public String getHtmlTagAttributeConvert() {
        return this.htmlTagAttributeConvert;
    }

    public void setHtmlTagAttributeConvert(String htmlTagAttributeConvert) {
        this.htmlTagAttributeConvert = htmlTagAttributeConvert;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Set<String> getPkgList() {
        return this.pkgList;
    }

    public void addPkg(String pkg) {
        this.pkgList.add(pkg.concat("."));
    }

    public void setPkgList(Set<String> pkgList) {
        this.pkgList = pkgList;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getNativeSecurity() {
        return this.nativeSecurity;
    }

    public void setNativeSecurity(String nativeSecurity) {
        this.nativeSecurity = nativeSecurity;
    }

    public String getWebAppExt() {
        return this.webAppExt;
    }

    public void setWebAppExt(String webAppExt) {
        this.webAppExt = webAppExt;
    }

    public boolean isIgnoreClientIOError() {
        return this.isIgnoreClientIOError;
    }

    public void setIgnoreClientIOError(boolean isIgnoreClientIOError) {
        this.isIgnoreClientIOError = isIgnoreClientIOError;
    }

    public String getErrorHandlerClass() {
        return this.errorHandlerClass;
    }

    public void setErrorHandlerClass(String errorHandlerClass) {
        this.errorHandlerClass = errorHandlerClass;
    }

    public Map<String, String> getFnMap() {
        return this.fnMap;
    }

    public void setFnMap(Map<String, String> fnMap) {
        this.fnMap = fnMap;
    }

    public Map<String, String> getFnPkgMap() {
        return this.fnPkgMap;
    }

    public void setFnPkgMap(Map<String, String> fnPkgMap) {
        this.fnPkgMap = fnPkgMap;
    }

    public Map<String, String> getFormatMap() {
        return this.formatMap;
    }

    public void setFormatMap(Map<String, String> formatMap) {
        this.formatMap = formatMap;
    }

    public Map<String, String> getDefaultFormatMap() {
        return this.defaultFormatMap;
    }

    public void setDefaultFormatMap(Map<String, String> defaultFormatMap) {
        this.defaultFormatMap = defaultFormatMap;
    }

    public Set<String> getGeneralVirtualAttributeSet() {
        return this.generalVirtualAttributeSet;
    }

    public void setGeneralVirtualAttributeSet(Set<String> generalVirtualAttributeSet) {
        this.generalVirtualAttributeSet = generalVirtualAttributeSet;
    }

    public Map<String, String> getVirtualClass() {
        return this.virtualClass;
    }

    public void setVirtualClass(Map<String, String> virtualClass) {
        this.virtualClass = virtualClass;
    }

    public Map<String, String> getTagFactoryMap() {
        return this.tagFactoryMap;
    }

    public void setTagFactoryMap(Map<String, String> tagFactoryMap) {
        this.tagFactoryMap = tagFactoryMap;
    }

    public Map<String, String> getTagMap() {
        return this.tagMap;
    }

    public void setTagMap(Map<String, String> tagMap) {
        this.tagMap = tagMap;
    }

    public String getProperty(String name) {
        return this.ps.getProperty(name);
    }

    public String getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(String resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Map<String, String> getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(Map<String, String> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public Properties getPs() {
        return this.ps;
    }

    public void setPs(Properties ps) {
        this.ps = ps;
    }

    public boolean isSafeOutput() {
        return this.safeOutput;
    }

    public void setSafeOutput(boolean safeOutput) {
        this.safeOutput = safeOutput;
    }

    public static class DelimeterHolder {
        char[] start;
        char[] end;
        char[] start1;
        char[] end1;

        public DelimeterHolder(char[] start, char[] end) {
            this.start = start;
            this.end = end;
        }

        public DelimeterHolder(char[] start, char[] end, char[] start1, char[] end1) {
            this.start = start;
            this.end = end;
            this.start1 = start1;
            this.end1 = end1;
        }

        public PlaceHolderDelimeter createPhd() {
            return this.start1 == null ? new PlaceHolderDelimeter(this.start, this.end) : new PlaceHolderDelimeter(this.start, this.end, this.start1, this.end1);
        }

        public ScriptDelimeter createSd() {
            return this.start1 == null ? new ScriptDelimeter(this.start, this.end) : new ScriptDelimeter(this.start, this.end, this.start1, this.end1);
        }
    }

    public static class HtmlTagHolder {
        String htmlTagStart = "<#";
        String htmlTagEnd = "</#";
        String htmlTagBindingAttribute = "var";
        boolean support = true;

        public HtmlTagHolder() {
        }

        public HtmlTagHolder(String htmlTagStart, String htmlTagEnd, String htmlTagBindingAttribute, boolean support) {
            this.htmlTagStart = htmlTagStart;
            this.htmlTagEnd = htmlTagEnd;
            this.htmlTagBindingAttribute = htmlTagBindingAttribute;
            this.support = support;
        }

        public boolean isSupport() {
            return this.support;
        }

        public HtmlTagConfig create() {
            return new HtmlTagConfig(this.htmlTagStart, this.htmlTagEnd, this.htmlTagBindingAttribute);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PropertiesKey {
    }
}

