/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.users;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.users.SlackUserCore;
import com.hubspot.slack.client.models.users.UserProfile;
import java.util.Optional;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@Value.Immutable
@HubSpotStyle
public interface SlackUserIF
extends SlackUserCore {
    public Optional<UserProfile> getProfile();

    @JsonProperty(value="deleted")
    public Optional<Boolean> isDeleted();

    public Optional<String> getColor();

    public Optional<String> isAdmin();

    public Optional<String> isOwner();

    public Optional<String> getTeamId();

    public Optional<String> getRealName();

    @JsonSetter(value="primaryOwner")
    @JsonProperty(value="is_primary_owner")
    public Optional<Boolean> isPrimaryOwner();

    @JsonSetter(value="restricted")
    @JsonProperty(value="is_restricted")
    public Optional<Boolean> isRestricted();

    @JsonSetter(value="ultra_restricted")
    @JsonProperty(value="is_ultra_restricted")
    public Optional<Boolean> isUltraRestricted();

    @JsonProperty(value="is_bot")
    public Optional<Boolean> isBot();

    @JsonSetter(value="app_user")
    @JsonProperty(value="is_app_user")
    public Optional<Boolean> isAppUser();

    @JsonProperty(value="tz")
    public Optional<String> getTimezone();

    @JsonProperty(value="tz_label")
    public Optional<String> getTimezoneLabel();

    @JsonProperty(value="tz_offset")
    public Optional<String> getTimezoneOffset();

    @JsonProperty(value="updated")
    public Optional<Integer> getRawUpdated();

    public Optional<String> getLocale();

    @Value.Derived
    default public Optional<Long> getUpdatedAt() {
        return this.getRawUpdated().map(updated -> (long)updated.intValue() * 1000L);
    }
}

