/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.users.ProfileFieldIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ProfileFieldIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ProfileField
implements ProfileFieldIF {
    private final String value;
    @Nullable
    private final String alt;

    private ProfileField(String value, @Nullable String alt) {
        this.value = value;
        this.alt = alt;
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty
    public Optional<String> getAlt() {
        return Optional.ofNullable(this.alt);
    }

    public final ProfileField withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ProfileField(newValue, this.alt);
    }

    public final ProfileField withAlt(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.alt, newValue)) {
            return this;
        }
        return new ProfileField(this.value, newValue);
    }

    public final ProfileField withAlt(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.alt, value)) {
            return this;
        }
        return new ProfileField(this.value, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ProfileField && this.equalTo(0, (ProfileField)another);
    }

    private boolean equalTo(int synthetic, ProfileField another) {
        return this.value.equals(another.value) && Objects.equals(this.alt, another.alt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.alt);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ProfileField{");
        builder.append("value=").append(this.value);
        if (this.alt != null) {
            builder.append(", ");
            builder.append("alt=").append(this.alt);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ProfileField fromJson(Json json) {
        Builder builder = ProfileField.builder();
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.alt != null) {
            builder.setAlt(json.alt);
        }
        return builder.build();
    }

    public static ProfileField copyOf(ProfileFieldIF instance) {
        if (instance instanceof ProfileField) {
            return (ProfileField)instance;
        }
        return ProfileField.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProfileFieldIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private String value;
        @Nullable
        private String alt;

        private Builder() {
        }

        public final Builder from(ProfileFieldIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setValue(instance.getValue());
            Optional<String> altOptional = instance.getAlt();
            if (altOptional.isPresent()) {
                this.setAlt(altOptional);
            }
            return this;
        }

        public final Builder setValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setAlt(@Nullable String alt) {
            this.alt = alt;
            return this;
        }

        public final Builder setAlt(Optional<String> alt) {
            this.alt = alt.orElse(null);
            return this;
        }

        public ProfileField build() {
            this.checkRequiredAttributes();
            return new ProfileField(this.value, this.alt);
        }

        private boolean valueIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            return "Cannot build ProfileField, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ProfileFieldIF", generator="Immutables")
    static final class Json
    implements ProfileFieldIF {
        @Nullable
        String value;
        @Nullable
        Optional<String> alt = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty
        public void setAlt(Optional<String> alt) {
            this.alt = alt;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAlt() {
            throw new UnsupportedOperationException();
        }
    }
}

