/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.usergroups.SlackUsergroupIF;
import com.hubspot.slack.client.models.usergroups.UsergroupPreferences;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackUsergroupIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackUsergroup
implements SlackUsergroupIF {
    private final String id;
    private final String teamId;
    private final boolean usergroup;
    private final String name;
    @Nullable
    private final String description;
    private final String handle;
    private final boolean external;
    private final int dateCreatedEpochSeconds;
    private final int dateUpdatedEpochSeconds;
    private final int dateDeletedEpochSeconds;
    @Nullable
    private final String autoType;
    @Nullable
    private final String createdBy;
    @Nullable
    private final String updatedBy;
    @Nullable
    private final String deletedBy;
    private final transient boolean deleted;
    private final UsergroupPreferences preferences;
    private final List<String> userIdsInGroup;
    @Nullable
    private final Integer userCount;

    private SlackUsergroup(String id, String teamId, boolean usergroup, String name, @Nullable String description, String handle, boolean external, int dateCreatedEpochSeconds, int dateUpdatedEpochSeconds, int dateDeletedEpochSeconds, @Nullable String autoType, @Nullable String createdBy, @Nullable String updatedBy, @Nullable String deletedBy, UsergroupPreferences preferences, List<String> userIdsInGroup, @Nullable Integer userCount) {
        this.id = id;
        this.teamId = teamId;
        this.usergroup = usergroup;
        this.name = name;
        this.description = description;
        this.handle = handle;
        this.external = external;
        this.dateCreatedEpochSeconds = dateCreatedEpochSeconds;
        this.dateUpdatedEpochSeconds = dateUpdatedEpochSeconds;
        this.dateDeletedEpochSeconds = dateDeletedEpochSeconds;
        this.autoType = autoType;
        this.createdBy = createdBy;
        this.updatedBy = updatedBy;
        this.deletedBy = deletedBy;
        this.preferences = preferences;
        this.userIdsInGroup = userIdsInGroup;
        this.userCount = userCount;
        this.deleted = SlackUsergroupIF.super.isDeleted();
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getTeamId() {
        return this.teamId;
    }

    @Override
    @JsonProperty(value="is_usergroup")
    public boolean isUsergroup() {
        return this.usergroup;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    public String getHandle() {
        return this.handle;
    }

    @Override
    @JsonProperty(value="is_external")
    public boolean isExternal() {
        return this.external;
    }

    @Override
    @JsonProperty(value="date_create")
    public int getDateCreatedEpochSeconds() {
        return this.dateCreatedEpochSeconds;
    }

    @Override
    @JsonProperty(value="date_update")
    public int getDateUpdatedEpochSeconds() {
        return this.dateUpdatedEpochSeconds;
    }

    @Override
    @JsonProperty(value="date_delete")
    public int getDateDeletedEpochSeconds() {
        return this.dateDeletedEpochSeconds;
    }

    @Override
    @JsonProperty
    public Optional<String> getAutoType() {
        return Optional.ofNullable(this.autoType);
    }

    @Override
    @JsonProperty
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(this.createdBy);
    }

    @Override
    @JsonProperty
    public Optional<String> getUpdatedBy() {
        return Optional.ofNullable(this.updatedBy);
    }

    @Override
    @JsonProperty
    public Optional<String> getDeletedBy() {
        return Optional.ofNullable(this.deletedBy);
    }

    @Override
    @JsonProperty
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="prefs")
    public UsergroupPreferences getPreferences() {
        return this.preferences;
    }

    @Override
    @JsonProperty(value="users")
    public List<String> getUserIdsInGroup() {
        return this.userIdsInGroup;
    }

    @Override
    @JsonProperty
    public Optional<Integer> getUserCount() {
        return Optional.ofNullable(this.userCount);
    }

    public final SlackUsergroup withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new SlackUsergroup(newValue, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withTeamId(String value) {
        String newValue = Objects.requireNonNull(value, "teamId");
        if (this.teamId.equals(newValue)) {
            return this;
        }
        return new SlackUsergroup(this.id, newValue, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withUsergroup(boolean value) {
        if (this.usergroup == value) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, value, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, newValue, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withDescription(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, newValue, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, value, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withHandle(String value) {
        String newValue = Objects.requireNonNull(value, "handle");
        if (this.handle.equals(newValue)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, newValue, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withExternal(boolean value) {
        if (this.external == value) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, value, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withDateCreatedEpochSeconds(int value) {
        if (this.dateCreatedEpochSeconds == value) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, value, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withDateUpdatedEpochSeconds(int value) {
        if (this.dateUpdatedEpochSeconds == value) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, value, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withDateDeletedEpochSeconds(int value) {
        if (this.dateDeletedEpochSeconds == value) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, value, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withAutoType(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.autoType, newValue)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, newValue, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withAutoType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.autoType, value)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, value, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withCreatedBy(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.createdBy, newValue)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, newValue, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withCreatedBy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.createdBy, value)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, value, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withUpdatedBy(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.updatedBy, newValue)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, newValue, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withUpdatedBy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.updatedBy, value)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, value, this.deletedBy, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withDeletedBy(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.deletedBy, newValue)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, newValue, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withDeletedBy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.deletedBy, value)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, value, this.preferences, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withPreferences(UsergroupPreferences value) {
        if (this.preferences == value) {
            return this;
        }
        UsergroupPreferences newValue = Objects.requireNonNull(value, "preferences");
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, newValue, this.userIdsInGroup, this.userCount);
    }

    public final SlackUsergroup withUserIdsInGroup(String ... elements) {
        List<String> newValue = SlackUsergroup.createUnmodifiableList(false, SlackUsergroup.createSafeList(Arrays.asList(elements), true, false));
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, newValue, this.userCount);
    }

    public final SlackUsergroup withUserIdsInGroup(Iterable<String> elements) {
        if (this.userIdsInGroup == elements) {
            return this;
        }
        List<String> newValue = SlackUsergroup.createUnmodifiableList(false, SlackUsergroup.createSafeList(elements, true, false));
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, newValue, this.userCount);
    }

    public final SlackUsergroup withUserCount(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.userCount, newValue)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, newValue);
    }

    public final SlackUsergroup withUserCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.userCount, value)) {
            return this;
        }
        return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, this.userIdsInGroup, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackUsergroup && this.equalTo(0, (SlackUsergroup)another);
    }

    private boolean equalTo(int synthetic, SlackUsergroup another) {
        return this.id.equals(another.id) && this.teamId.equals(another.teamId) && this.usergroup == another.usergroup && this.name.equals(another.name) && Objects.equals(this.description, another.description) && this.handle.equals(another.handle) && this.external == another.external && this.dateCreatedEpochSeconds == another.dateCreatedEpochSeconds && this.dateUpdatedEpochSeconds == another.dateUpdatedEpochSeconds && this.dateDeletedEpochSeconds == another.dateDeletedEpochSeconds && Objects.equals(this.autoType, another.autoType) && Objects.equals(this.createdBy, another.createdBy) && Objects.equals(this.updatedBy, another.updatedBy) && Objects.equals(this.deletedBy, another.deletedBy) && this.deleted == another.deleted && this.preferences.equals(another.preferences) && this.userIdsInGroup.equals(another.userIdsInGroup) && Objects.equals(this.userCount, another.userCount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.teamId.hashCode();
        h += (h << 5) + Boolean.hashCode(this.usergroup);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.handle.hashCode();
        h += (h << 5) + Boolean.hashCode(this.external);
        h += (h << 5) + this.dateCreatedEpochSeconds;
        h += (h << 5) + this.dateUpdatedEpochSeconds;
        h += (h << 5) + this.dateDeletedEpochSeconds;
        h += (h << 5) + Objects.hashCode(this.autoType);
        h += (h << 5) + Objects.hashCode(this.createdBy);
        h += (h << 5) + Objects.hashCode(this.updatedBy);
        h += (h << 5) + Objects.hashCode(this.deletedBy);
        h += (h << 5) + Boolean.hashCode(this.deleted);
        h += (h << 5) + this.preferences.hashCode();
        h += (h << 5) + this.userIdsInGroup.hashCode();
        h += (h << 5) + Objects.hashCode(this.userCount);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackUsergroup{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("teamId=").append(this.teamId);
        builder.append(", ");
        builder.append("usergroup=").append(this.usergroup);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        builder.append(", ");
        builder.append("handle=").append(this.handle);
        builder.append(", ");
        builder.append("external=").append(this.external);
        builder.append(", ");
        builder.append("dateCreatedEpochSeconds=").append(this.dateCreatedEpochSeconds);
        builder.append(", ");
        builder.append("dateUpdatedEpochSeconds=").append(this.dateUpdatedEpochSeconds);
        builder.append(", ");
        builder.append("dateDeletedEpochSeconds=").append(this.dateDeletedEpochSeconds);
        if (this.autoType != null) {
            builder.append(", ");
            builder.append("autoType=").append(this.autoType);
        }
        if (this.createdBy != null) {
            builder.append(", ");
            builder.append("createdBy=").append(this.createdBy);
        }
        if (this.updatedBy != null) {
            builder.append(", ");
            builder.append("updatedBy=").append(this.updatedBy);
        }
        if (this.deletedBy != null) {
            builder.append(", ");
            builder.append("deletedBy=").append(this.deletedBy);
        }
        builder.append(", ");
        builder.append("deleted=").append(this.deleted);
        builder.append(", ");
        builder.append("preferences=").append(this.preferences);
        builder.append(", ");
        builder.append("userIdsInGroup=").append(this.userIdsInGroup);
        if (this.userCount != null) {
            builder.append(", ");
            builder.append("userCount=").append(this.userCount);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackUsergroup fromJson(Json json) {
        Builder builder = SlackUsergroup.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.usergroupIsSet) {
            builder.setUsergroup(json.usergroup);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.description != null) {
            builder.setDescription(json.description);
        }
        if (json.handle != null) {
            builder.setHandle(json.handle);
        }
        if (json.externalIsSet) {
            builder.setExternal(json.external);
        }
        if (json.dateCreatedEpochSecondsIsSet) {
            builder.setDateCreatedEpochSeconds(json.dateCreatedEpochSeconds);
        }
        if (json.dateUpdatedEpochSecondsIsSet) {
            builder.setDateUpdatedEpochSeconds(json.dateUpdatedEpochSeconds);
        }
        if (json.dateDeletedEpochSecondsIsSet) {
            builder.setDateDeletedEpochSeconds(json.dateDeletedEpochSeconds);
        }
        if (json.autoType != null) {
            builder.setAutoType(json.autoType);
        }
        if (json.createdBy != null) {
            builder.setCreatedBy(json.createdBy);
        }
        if (json.updatedBy != null) {
            builder.setUpdatedBy(json.updatedBy);
        }
        if (json.deletedBy != null) {
            builder.setDeletedBy(json.deletedBy);
        }
        if (json.preferences != null) {
            builder.setPreferences(json.preferences);
        }
        if (json.userIdsInGroup != null) {
            builder.addAllUserIdsInGroup(json.userIdsInGroup);
        }
        if (json.userCount != null) {
            builder.setUserCount(json.userCount);
        }
        return builder.build();
    }

    public static SlackUsergroup copyOf(SlackUsergroupIF instance) {
        if (instance instanceof SlackUsergroup) {
            return (SlackUsergroup)instance;
        }
        return SlackUsergroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SlackUsergroupIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TEAM_ID = 2L;
        private static final long INIT_BIT_USERGROUP = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private static final long INIT_BIT_HANDLE = 16L;
        private static final long INIT_BIT_EXTERNAL = 32L;
        private static final long INIT_BIT_DATE_CREATED_EPOCH_SECONDS = 64L;
        private static final long INIT_BIT_DATE_UPDATED_EPOCH_SECONDS = 128L;
        private static final long INIT_BIT_DATE_DELETED_EPOCH_SECONDS = 256L;
        private static final long INIT_BIT_PREFERENCES = 512L;
        private long initBits = 1023L;
        @Nullable
        private String id;
        @Nullable
        private String teamId;
        private boolean usergroup;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String handle;
        private boolean external;
        private int dateCreatedEpochSeconds;
        private int dateUpdatedEpochSeconds;
        private int dateDeletedEpochSeconds;
        @Nullable
        private String autoType;
        @Nullable
        private String createdBy;
        @Nullable
        private String updatedBy;
        @Nullable
        private String deletedBy;
        @Nullable
        private UsergroupPreferences preferences;
        private List<String> userIdsInGroup = new ArrayList<String>();
        @Nullable
        private Integer userCount;

        private Builder() {
        }

        public final Builder from(SlackUsergroupIF instance) {
            Optional<String> deletedByOptional;
            Optional<String> updatedByOptional;
            Optional<String> createdByOptional;
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            this.setTeamId(instance.getTeamId());
            this.setUsergroup(instance.isUsergroup());
            this.setName(instance.getName());
            Optional<String> descriptionOptional = instance.getDescription();
            if (descriptionOptional.isPresent()) {
                this.setDescription(descriptionOptional);
            }
            this.setHandle(instance.getHandle());
            this.setExternal(instance.isExternal());
            this.setDateCreatedEpochSeconds(instance.getDateCreatedEpochSeconds());
            this.setDateUpdatedEpochSeconds(instance.getDateUpdatedEpochSeconds());
            this.setDateDeletedEpochSeconds(instance.getDateDeletedEpochSeconds());
            Optional<String> autoTypeOptional = instance.getAutoType();
            if (autoTypeOptional.isPresent()) {
                this.setAutoType(autoTypeOptional);
            }
            if ((createdByOptional = instance.getCreatedBy()).isPresent()) {
                this.setCreatedBy(createdByOptional);
            }
            if ((updatedByOptional = instance.getUpdatedBy()).isPresent()) {
                this.setUpdatedBy(updatedByOptional);
            }
            if ((deletedByOptional = instance.getDeletedBy()).isPresent()) {
                this.setDeletedBy(deletedByOptional);
            }
            this.setPreferences(instance.getPreferences());
            this.addAllUserIdsInGroup(instance.getUserIdsInGroup());
            Optional<Integer> userCountOptional = instance.getUserCount();
            if (userCountOptional.isPresent()) {
                this.setUserCount(userCountOptional);
            }
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTeamId(String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setUsergroup(boolean usergroup) {
            this.usergroup = usergroup;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder setDescription(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public final Builder setHandle(String handle) {
            this.handle = Objects.requireNonNull(handle, "handle");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setExternal(boolean external) {
            this.external = external;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setDateCreatedEpochSeconds(int dateCreatedEpochSeconds) {
            this.dateCreatedEpochSeconds = dateCreatedEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setDateUpdatedEpochSeconds(int dateUpdatedEpochSeconds) {
            this.dateUpdatedEpochSeconds = dateUpdatedEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setDateDeletedEpochSeconds(int dateDeletedEpochSeconds) {
            this.dateDeletedEpochSeconds = dateDeletedEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder setAutoType(@Nullable String autoType) {
            this.autoType = autoType;
            return this;
        }

        public final Builder setAutoType(Optional<String> autoType) {
            this.autoType = autoType.orElse(null);
            return this;
        }

        public final Builder setCreatedBy(@Nullable String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Builder setCreatedBy(Optional<String> createdBy) {
            this.createdBy = createdBy.orElse(null);
            return this;
        }

        public final Builder setUpdatedBy(@Nullable String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Builder setUpdatedBy(Optional<String> updatedBy) {
            this.updatedBy = updatedBy.orElse(null);
            return this;
        }

        public final Builder setDeletedBy(@Nullable String deletedBy) {
            this.deletedBy = deletedBy;
            return this;
        }

        public final Builder setDeletedBy(Optional<String> deletedBy) {
            this.deletedBy = deletedBy.orElse(null);
            return this;
        }

        public final Builder setPreferences(UsergroupPreferences preferences) {
            this.preferences = Objects.requireNonNull(preferences, "preferences");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder addUserIdsInGroup(String element) {
            this.userIdsInGroup.add(Objects.requireNonNull(element, "userIdsInGroup element"));
            return this;
        }

        public final Builder addUserIdsInGroup(String ... elements) {
            for (String element : elements) {
                this.userIdsInGroup.add(Objects.requireNonNull(element, "userIdsInGroup element"));
            }
            return this;
        }

        public final Builder setUserIdsInGroup(Iterable<String> elements) {
            this.userIdsInGroup.clear();
            return this.addAllUserIdsInGroup(elements);
        }

        public final Builder addAllUserIdsInGroup(Iterable<String> elements) {
            for (String element : elements) {
                this.userIdsInGroup.add(Objects.requireNonNull(element, "userIdsInGroup element"));
            }
            return this;
        }

        public final Builder setUserCount(@Nullable Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final Builder setUserCount(Optional<Integer> userCount) {
            this.userCount = userCount.orElse(null);
            return this;
        }

        public SlackUsergroup build() {
            this.checkRequiredAttributes();
            return new SlackUsergroup(this.id, this.teamId, this.usergroup, this.name, this.description, this.handle, this.external, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.dateDeletedEpochSeconds, this.autoType, this.createdBy, this.updatedBy, this.deletedBy, this.preferences, SlackUsergroup.createUnmodifiableList(true, this.userIdsInGroup), this.userCount);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean teamIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean usergroupIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean handleIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean externalIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean dateCreatedEpochSecondsIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean dateUpdatedEpochSecondsIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean dateDeletedEpochSecondsIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private boolean preferencesIsSet() {
            return (this.initBits & 0x200L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.teamIdIsSet()) {
                attributes.add("teamId");
            }
            if (!this.usergroupIsSet()) {
                attributes.add("usergroup");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.handleIsSet()) {
                attributes.add("handle");
            }
            if (!this.externalIsSet()) {
                attributes.add("external");
            }
            if (!this.dateCreatedEpochSecondsIsSet()) {
                attributes.add("dateCreatedEpochSeconds");
            }
            if (!this.dateUpdatedEpochSecondsIsSet()) {
                attributes.add("dateUpdatedEpochSeconds");
            }
            if (!this.dateDeletedEpochSecondsIsSet()) {
                attributes.add("dateDeletedEpochSeconds");
            }
            if (!this.preferencesIsSet()) {
                attributes.add("preferences");
            }
            return "Cannot build SlackUsergroup, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackUsergroupIF", generator="Immutables")
    static final class Json
    implements SlackUsergroupIF {
        @Nullable
        String id;
        @Nullable
        String teamId;
        boolean usergroup;
        boolean usergroupIsSet;
        @Nullable
        String name;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        String handle;
        boolean external;
        boolean externalIsSet;
        int dateCreatedEpochSeconds;
        boolean dateCreatedEpochSecondsIsSet;
        int dateUpdatedEpochSeconds;
        boolean dateUpdatedEpochSecondsIsSet;
        int dateDeletedEpochSeconds;
        boolean dateDeletedEpochSecondsIsSet;
        @Nullable
        Optional<String> autoType = Optional.empty();
        @Nullable
        Optional<String> createdBy = Optional.empty();
        @Nullable
        Optional<String> updatedBy = Optional.empty();
        @Nullable
        Optional<String> deletedBy = Optional.empty();
        @Nullable
        UsergroupPreferences preferences;
        @Nullable
        List<String> userIdsInGroup = Collections.emptyList();
        @Nullable
        Optional<Integer> userCount = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty(value="is_usergroup")
        public void setUsergroup(boolean usergroup) {
            this.usergroup = usergroup;
            this.usergroupIsSet = true;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setHandle(String handle) {
            this.handle = handle;
        }

        @JsonProperty(value="is_external")
        public void setExternal(boolean external) {
            this.external = external;
            this.externalIsSet = true;
        }

        @JsonProperty(value="date_create")
        public void setDateCreatedEpochSeconds(int dateCreatedEpochSeconds) {
            this.dateCreatedEpochSeconds = dateCreatedEpochSeconds;
            this.dateCreatedEpochSecondsIsSet = true;
        }

        @JsonProperty(value="date_update")
        public void setDateUpdatedEpochSeconds(int dateUpdatedEpochSeconds) {
            this.dateUpdatedEpochSeconds = dateUpdatedEpochSeconds;
            this.dateUpdatedEpochSecondsIsSet = true;
        }

        @JsonProperty(value="date_delete")
        public void setDateDeletedEpochSeconds(int dateDeletedEpochSeconds) {
            this.dateDeletedEpochSeconds = dateDeletedEpochSeconds;
            this.dateDeletedEpochSecondsIsSet = true;
        }

        @JsonProperty
        public void setAutoType(Optional<String> autoType) {
            this.autoType = autoType;
        }

        @JsonProperty
        public void setCreatedBy(Optional<String> createdBy) {
            this.createdBy = createdBy;
        }

        @JsonProperty
        public void setUpdatedBy(Optional<String> updatedBy) {
            this.updatedBy = updatedBy;
        }

        @JsonProperty
        public void setDeletedBy(Optional<String> deletedBy) {
            this.deletedBy = deletedBy;
        }

        @JsonProperty(value="prefs")
        public void setPreferences(UsergroupPreferences preferences) {
            this.preferences = preferences;
        }

        @JsonProperty(value="users")
        public void setUserIdsInGroup(List<String> userIdsInGroup) {
            this.userIdsInGroup = userIdsInGroup;
        }

        @JsonProperty
        public void setUserCount(Optional<Integer> userCount) {
            this.userCount = userCount;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isUsergroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHandle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isExternal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDateCreatedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDateUpdatedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDateDeletedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAutoType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCreatedBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUpdatedBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDeletedBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean isDeleted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UsergroupPreferences getPreferences() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getUserIdsInGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getUserCount() {
            throw new UnsupportedOperationException();
        }
    }
}

