/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.teams;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.teams.SlackTeamIF;
import com.hubspot.slack.client.models.teams.SlackTeamIcon;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackTeamIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackTeam
implements SlackTeamIF {
    private final String id;
    private final String domain;
    @Nullable
    private final String name;
    @Nullable
    private final String enterpriseId;
    @Nullable
    private final String enterpriseName;
    @Nullable
    private final SlackTeamIcon icon;

    private SlackTeam(String id, String domain, @Nullable String name, @Nullable String enterpriseId, @Nullable String enterpriseName, @Nullable SlackTeamIcon icon) {
        this.id = id;
        this.domain = domain;
        this.name = name;
        this.enterpriseId = enterpriseId;
        this.enterpriseName = enterpriseName;
        this.icon = icon;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getDomain() {
        return this.domain;
    }

    @Override
    @JsonProperty
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty
    public Optional<String> getEnterpriseId() {
        return Optional.ofNullable(this.enterpriseId);
    }

    @Override
    @JsonProperty
    public Optional<String> getEnterpriseName() {
        return Optional.ofNullable(this.enterpriseName);
    }

    @Override
    @JsonProperty
    public Optional<SlackTeamIcon> getIcon() {
        return Optional.ofNullable(this.icon);
    }

    public final SlackTeam withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new SlackTeam(newValue, this.domain, this.name, this.enterpriseId, this.enterpriseName, this.icon);
    }

    public final SlackTeam withDomain(String value) {
        String newValue = Objects.requireNonNull(value, "domain");
        if (this.domain.equals(newValue)) {
            return this;
        }
        return new SlackTeam(this.id, newValue, this.name, this.enterpriseId, this.enterpriseName, this.icon);
    }

    public final SlackTeam withName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, newValue, this.enterpriseId, this.enterpriseName, this.icon);
    }

    public final SlackTeam withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, value, this.enterpriseId, this.enterpriseName, this.icon);
    }

    public final SlackTeam withEnterpriseId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.enterpriseId, newValue)) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, this.name, newValue, this.enterpriseName, this.icon);
    }

    public final SlackTeam withEnterpriseId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.enterpriseId, value)) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, this.name, value, this.enterpriseName, this.icon);
    }

    public final SlackTeam withEnterpriseName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.enterpriseName, newValue)) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, this.name, this.enterpriseId, newValue, this.icon);
    }

    public final SlackTeam withEnterpriseName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.enterpriseName, value)) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, this.name, this.enterpriseId, value, this.icon);
    }

    public final SlackTeam withIcon(@Nullable SlackTeamIcon value) {
        SlackTeamIcon newValue = value;
        if (this.icon == newValue) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, this.name, this.enterpriseId, this.enterpriseName, newValue);
    }

    public final SlackTeam withIcon(Optional<? extends SlackTeamIcon> optional) {
        SlackTeamIcon value = optional.orElse(null);
        if (this.icon == value) {
            return this;
        }
        return new SlackTeam(this.id, this.domain, this.name, this.enterpriseId, this.enterpriseName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackTeam && this.equalTo(0, (SlackTeam)another);
    }

    private boolean equalTo(int synthetic, SlackTeam another) {
        return this.id.equals(another.id) && this.domain.equals(another.domain) && Objects.equals(this.name, another.name) && Objects.equals(this.enterpriseId, another.enterpriseId) && Objects.equals(this.enterpriseName, another.enterpriseName) && Objects.equals(this.icon, another.icon);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.domain.hashCode();
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.enterpriseId);
        h += (h << 5) + Objects.hashCode(this.enterpriseName);
        h += (h << 5) + Objects.hashCode(this.icon);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackTeam{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("domain=").append(this.domain);
        if (this.name != null) {
            builder.append(", ");
            builder.append("name=").append(this.name);
        }
        if (this.enterpriseId != null) {
            builder.append(", ");
            builder.append("enterpriseId=").append(this.enterpriseId);
        }
        if (this.enterpriseName != null) {
            builder.append(", ");
            builder.append("enterpriseName=").append(this.enterpriseName);
        }
        if (this.icon != null) {
            builder.append(", ");
            builder.append("icon=").append(this.icon);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackTeam fromJson(Json json) {
        Builder builder = SlackTeam.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.domain != null) {
            builder.setDomain(json.domain);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.enterpriseId != null) {
            builder.setEnterpriseId(json.enterpriseId);
        }
        if (json.enterpriseName != null) {
            builder.setEnterpriseName(json.enterpriseName);
        }
        if (json.icon != null) {
            builder.setIcon(json.icon);
        }
        return builder.build();
    }

    public static SlackTeam copyOf(SlackTeamIF instance) {
        if (instance instanceof SlackTeam) {
            return (SlackTeam)instance;
        }
        return SlackTeam.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackTeamIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_DOMAIN = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String domain;
        @Nullable
        private String name;
        @Nullable
        private String enterpriseId;
        @Nullable
        private String enterpriseName;
        @Nullable
        private SlackTeamIcon icon;

        private Builder() {
        }

        public final Builder from(SlackTeamIF instance) {
            Optional<SlackTeamIcon> iconOptional;
            Optional<String> enterpriseNameOptional;
            Optional<String> enterpriseIdOptional;
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            this.setDomain(instance.getDomain());
            Optional<String> nameOptional = instance.getName();
            if (nameOptional.isPresent()) {
                this.setName(nameOptional);
            }
            if ((enterpriseIdOptional = instance.getEnterpriseId()).isPresent()) {
                this.setEnterpriseId(enterpriseIdOptional);
            }
            if ((enterpriseNameOptional = instance.getEnterpriseName()).isPresent()) {
                this.setEnterpriseName(enterpriseNameOptional);
            }
            if ((iconOptional = instance.getIcon()).isPresent()) {
                this.setIcon(iconOptional);
            }
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDomain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder setName(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public final Builder setEnterpriseId(@Nullable String enterpriseId) {
            this.enterpriseId = enterpriseId;
            return this;
        }

        public final Builder setEnterpriseId(Optional<String> enterpriseId) {
            this.enterpriseId = enterpriseId.orElse(null);
            return this;
        }

        public final Builder setEnterpriseName(@Nullable String enterpriseName) {
            this.enterpriseName = enterpriseName;
            return this;
        }

        public final Builder setEnterpriseName(Optional<String> enterpriseName) {
            this.enterpriseName = enterpriseName.orElse(null);
            return this;
        }

        public final Builder setIcon(@Nullable SlackTeamIcon icon) {
            this.icon = icon;
            return this;
        }

        public final Builder setIcon(Optional<? extends SlackTeamIcon> icon) {
            this.icon = icon.orElse(null);
            return this;
        }

        public SlackTeam build() {
            this.checkRequiredAttributes();
            return new SlackTeam(this.id, this.domain, this.name, this.enterpriseId, this.enterpriseName, this.icon);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean domainIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.domainIsSet()) {
                attributes.add("domain");
            }
            return "Cannot build SlackTeam, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackTeamIF", generator="Immutables")
    static final class Json
    implements SlackTeamIF {
        @Nullable
        String id;
        @Nullable
        String domain;
        @Nullable
        Optional<String> name = Optional.empty();
        @Nullable
        Optional<String> enterpriseId = Optional.empty();
        @Nullable
        Optional<String> enterpriseName = Optional.empty();
        @Nullable
        Optional<SlackTeamIcon> icon = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setDomain(String domain) {
            this.domain = domain;
        }

        @JsonProperty
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty
        public void setEnterpriseId(Optional<String> enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @JsonProperty
        public void setEnterpriseName(Optional<String> enterpriseName) {
            this.enterpriseName = enterpriseName;
        }

        @JsonProperty
        public void setIcon(Optional<SlackTeamIcon> icon) {
            this.icon = icon;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEnterpriseId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEnterpriseName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackTeamIcon> getIcon() {
            throw new UnsupportedOperationException();
        }
    }
}

