/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.views.StateActionValueIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="StateActionValueIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class StateActionValue
implements StateActionValueIF {
    private final String blockElementType;
    @Nullable
    private final Object blockElementValue;

    private StateActionValue(String blockElementType, @Nullable Object blockElementValue) {
        this.blockElementType = blockElementType;
        this.blockElementValue = blockElementValue;
    }

    @Override
    @JsonProperty
    public String getBlockElementType() {
        return this.blockElementType;
    }

    @Override
    @JsonProperty
    public Optional<Object> getBlockElementValue() {
        return Optional.ofNullable(this.blockElementValue);
    }

    public final StateActionValue withBlockElementType(String value) {
        String newValue = Objects.requireNonNull(value, "blockElementType");
        if (this.blockElementType.equals(newValue)) {
            return this;
        }
        return new StateActionValue(newValue, this.blockElementValue);
    }

    public final StateActionValue withBlockElementValue(@Nullable Object value) {
        Object newValue = value;
        if (this.blockElementValue == newValue) {
            return this;
        }
        return new StateActionValue(this.blockElementType, newValue);
    }

    public final StateActionValue withBlockElementValue(Optional<? extends Object> optional) {
        Object value = optional.orElse(null);
        if (this.blockElementValue == value) {
            return this;
        }
        return new StateActionValue(this.blockElementType, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StateActionValue && this.equalTo(0, (StateActionValue)another);
    }

    private boolean equalTo(int synthetic, StateActionValue another) {
        return this.blockElementType.equals(another.blockElementType) && Objects.equals(this.blockElementValue, another.blockElementValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.blockElementType.hashCode();
        h += (h << 5) + Objects.hashCode(this.blockElementValue);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StateActionValue{");
        builder.append("blockElementType=").append(this.blockElementType);
        if (this.blockElementValue != null) {
            builder.append(", ");
            builder.append("blockElementValue=").append(this.blockElementValue);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static StateActionValue fromJson(Json json) {
        Builder builder = StateActionValue.builder();
        if (json.blockElementType != null) {
            builder.setBlockElementType(json.blockElementType);
        }
        if (json.blockElementValue != null) {
            builder.setBlockElementValue(json.blockElementValue);
        }
        return builder.build();
    }

    public static StateActionValue copyOf(StateActionValueIF instance) {
        if (instance instanceof StateActionValue) {
            return (StateActionValue)instance;
        }
        return StateActionValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StateActionValueIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BLOCK_ELEMENT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String blockElementType;
        @Nullable
        private Object blockElementValue;

        private Builder() {
        }

        public final Builder from(StateActionValueIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setBlockElementType(instance.getBlockElementType());
            Optional<Object> blockElementValueOptional = instance.getBlockElementValue();
            if (blockElementValueOptional.isPresent()) {
                this.setBlockElementValue(blockElementValueOptional);
            }
            return this;
        }

        @JsonProperty
        public final Builder setBlockElementType(String blockElementType) {
            this.blockElementType = Objects.requireNonNull(blockElementType, "blockElementType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setBlockElementValue(@Nullable Object blockElementValue) {
            this.blockElementValue = blockElementValue;
            return this;
        }

        @JsonProperty
        public final Builder setBlockElementValue(Optional<? extends Object> blockElementValue) {
            this.blockElementValue = blockElementValue.orElse(null);
            return this;
        }

        public StateActionValue build() {
            this.checkRequiredAttributes();
            return new StateActionValue(this.blockElementType, this.blockElementValue);
        }

        private boolean blockElementTypeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.blockElementTypeIsSet()) {
                attributes.add("blockElementType");
            }
            return "Cannot build StateActionValue, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StateActionValueIF", generator="Immutables")
    static final class Json
    implements StateActionValueIF {
        @Nullable
        String blockElementType;
        @Nullable
        Optional<Object> blockElementValue = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setBlockElementType(String blockElementType) {
            this.blockElementType = blockElementType;
        }

        @JsonProperty
        public void setBlockElementValue(Optional<Object> blockElementValue) {
            this.blockElementValue = blockElementValue;
        }

        @Override
        public String getBlockElementType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Object> getBlockElementValue() {
            throw new UnsupportedOperationException();
        }
    }
}

