/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.response.views.HomeTabViewResponseIF;
import com.hubspot.slack.client.models.response.views.StateBlock;
import com.hubspot.slack.client.models.response.views.ViewResponseBase;
import com.hubspot.slack.client.models.response.views.json.StateBlockDeserializer;
import com.hubspot.slack.client.models.response.views.json.StateBlockSerializer;
import com.hubspot.slack.client.models.views.HomeTabViewPayloadBase;
import com.hubspot.slack.client.models.views.ViewPayloadBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="HomeTabViewResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class HomeTabViewResponse
implements HomeTabViewResponseIF {
    private final List<Block> blocks;
    @Nullable
    private final String privateMetadata;
    @Nullable
    private final String callbackId;
    @Nullable
    private final String externalId;
    private final transient String type;
    private final String appId;
    private final String botId;
    private final String currentViewId;
    private final String rootViewId;
    private final String teamId;
    private final StateBlock stateValues;
    private final String hash;
    @Nullable
    private final String previousViewId;

    private HomeTabViewResponse(List<Block> blocks, @Nullable String privateMetadata, @Nullable String callbackId, @Nullable String externalId, String appId, String botId, String currentViewId, String rootViewId, String teamId, StateBlock stateValues, String hash, @Nullable String previousViewId) {
        this.blocks = blocks;
        this.privateMetadata = privateMetadata;
        this.callbackId = callbackId;
        this.externalId = externalId;
        this.appId = appId;
        this.botId = botId;
        this.currentViewId = currentViewId;
        this.rootViewId = rootViewId;
        this.teamId = teamId;
        this.stateValues = stateValues;
        this.hash = hash;
        this.previousViewId = previousViewId;
        this.type = Objects.requireNonNull(HomeTabViewResponseIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    @JsonProperty
    public Optional<String> getPrivateMetadata() {
        return Optional.ofNullable(this.privateMetadata);
    }

    @Override
    @JsonProperty
    public Optional<String> getCallbackId() {
        return Optional.ofNullable(this.callbackId);
    }

    @Override
    @JsonProperty
    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.externalId);
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getAppId() {
        return this.appId;
    }

    @Override
    @JsonProperty
    public String getBotId() {
        return this.botId;
    }

    @Override
    @JsonProperty(value="id")
    public String getCurrentViewId() {
        return this.currentViewId;
    }

    @Override
    @JsonProperty
    public String getRootViewId() {
        return this.rootViewId;
    }

    @Override
    @JsonProperty
    public String getTeamId() {
        return this.teamId;
    }

    @Override
    @JsonProperty(value="state")
    @JsonDeserialize(using=StateBlockDeserializer.class)
    @JsonSerialize(using=StateBlockSerializer.class)
    public StateBlock getStateValues() {
        return this.stateValues;
    }

    @Override
    @JsonProperty
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty
    public Optional<String> getPreviousViewId() {
        return Optional.ofNullable(this.previousViewId);
    }

    public final HomeTabViewResponse withBlocks(Block ... elements) {
        List<Block> newValue = HomeTabViewResponse.createUnmodifiableList(false, HomeTabViewResponse.createSafeList(Arrays.asList(elements), true, false));
        return new HomeTabViewResponse(newValue, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = HomeTabViewResponse.createUnmodifiableList(false, HomeTabViewResponse.createSafeList(elements, true, false));
        return new HomeTabViewResponse(newValue, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withPrivateMetadata(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.privateMetadata, newValue)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, newValue, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withPrivateMetadata(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.privateMetadata, value)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, value, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withCallbackId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.callbackId, newValue)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, newValue, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withCallbackId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.callbackId, value)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, value, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withExternalId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.externalId, newValue)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, newValue, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withExternalId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, value, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withAppId(String value) {
        String newValue = Objects.requireNonNull(value, "appId");
        if (this.appId.equals(newValue)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, this.externalId, newValue, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withBotId(String value) {
        String newValue = Objects.requireNonNull(value, "botId");
        if (this.botId.equals(newValue)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, newValue, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withCurrentViewId(String value) {
        String newValue = Objects.requireNonNull(value, "currentViewId");
        if (this.currentViewId.equals(newValue)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, newValue, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withRootViewId(String value) {
        String newValue = Objects.requireNonNull(value, "rootViewId");
        if (this.rootViewId.equals(newValue)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, newValue, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withTeamId(String value) {
        String newValue = Objects.requireNonNull(value, "teamId");
        if (this.teamId.equals(newValue)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, newValue, this.stateValues, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withStateValues(StateBlock value) {
        if (this.stateValues == value) {
            return this;
        }
        StateBlock newValue = Objects.requireNonNull(value, "stateValues");
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, newValue, this.hash, this.previousViewId);
    }

    public final HomeTabViewResponse withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, newValue, this.previousViewId);
    }

    public final HomeTabViewResponse withPreviousViewId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.previousViewId, newValue)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, newValue);
    }

    public final HomeTabViewResponse withPreviousViewId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.previousViewId, value)) {
            return this;
        }
        return new HomeTabViewResponse(this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HomeTabViewResponse && this.equalTo(0, (HomeTabViewResponse)another);
    }

    private boolean equalTo(int synthetic, HomeTabViewResponse another) {
        return this.blocks.equals(another.blocks) && Objects.equals(this.privateMetadata, another.privateMetadata) && Objects.equals(this.callbackId, another.callbackId) && Objects.equals(this.externalId, another.externalId) && this.type.equals(another.type) && this.appId.equals(another.appId) && this.botId.equals(another.botId) && this.currentViewId.equals(another.currentViewId) && this.rootViewId.equals(another.rootViewId) && this.teamId.equals(another.teamId) && this.stateValues.equals(another.stateValues) && this.hash.equals(another.hash) && Objects.equals(this.previousViewId, another.previousViewId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.blocks.hashCode();
        h += (h << 5) + Objects.hashCode(this.privateMetadata);
        h += (h << 5) + Objects.hashCode(this.callbackId);
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.appId.hashCode();
        h += (h << 5) + this.botId.hashCode();
        h += (h << 5) + this.currentViewId.hashCode();
        h += (h << 5) + this.rootViewId.hashCode();
        h += (h << 5) + this.teamId.hashCode();
        h += (h << 5) + this.stateValues.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + Objects.hashCode(this.previousViewId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HomeTabViewResponse{");
        builder.append("blocks=").append(this.blocks);
        if (this.privateMetadata != null) {
            builder.append(", ");
            builder.append("privateMetadata=").append(this.privateMetadata);
        }
        if (this.callbackId != null) {
            builder.append(", ");
            builder.append("callbackId=").append(this.callbackId);
        }
        if (this.externalId != null) {
            builder.append(", ");
            builder.append("externalId=").append(this.externalId);
        }
        builder.append(", ");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("appId=").append(this.appId);
        builder.append(", ");
        builder.append("botId=").append(this.botId);
        builder.append(", ");
        builder.append("currentViewId=").append(this.currentViewId);
        builder.append(", ");
        builder.append("rootViewId=").append(this.rootViewId);
        builder.append(", ");
        builder.append("teamId=").append(this.teamId);
        builder.append(", ");
        builder.append("stateValues=").append(this.stateValues);
        builder.append(", ");
        builder.append("hash=").append(this.hash);
        if (this.previousViewId != null) {
            builder.append(", ");
            builder.append("previousViewId=").append(this.previousViewId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static HomeTabViewResponse fromJson(Json json) {
        Builder builder = HomeTabViewResponse.builder();
        if (json.blocks != null) {
            builder.addAllBlocks(json.blocks);
        }
        if (json.privateMetadata != null) {
            builder.setPrivateMetadata(json.privateMetadata);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.externalId != null) {
            builder.setExternalId(json.externalId);
        }
        if (json.appId != null) {
            builder.setAppId(json.appId);
        }
        if (json.botId != null) {
            builder.setBotId(json.botId);
        }
        if (json.currentViewId != null) {
            builder.setCurrentViewId(json.currentViewId);
        }
        if (json.rootViewId != null) {
            builder.setRootViewId(json.rootViewId);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.stateValues != null) {
            builder.setStateValues(json.stateValues);
        }
        if (json.hash != null) {
            builder.setHash(json.hash);
        }
        if (json.previousViewId != null) {
            builder.setPreviousViewId(json.previousViewId);
        }
        return builder.build();
    }

    public static HomeTabViewResponse copyOf(HomeTabViewResponseIF instance) {
        if (instance instanceof HomeTabViewResponse) {
            return (HomeTabViewResponse)instance;
        }
        return HomeTabViewResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="HomeTabViewResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_APP_ID = 1L;
        private static final long INIT_BIT_BOT_ID = 2L;
        private static final long INIT_BIT_CURRENT_VIEW_ID = 4L;
        private static final long INIT_BIT_ROOT_VIEW_ID = 8L;
        private static final long INIT_BIT_TEAM_ID = 16L;
        private static final long INIT_BIT_STATE_VALUES = 32L;
        private static final long INIT_BIT_HASH = 64L;
        private long initBits = 127L;
        private List<Block> blocks = new ArrayList<Block>();
        @Nullable
        private String privateMetadata;
        @Nullable
        private String callbackId;
        @Nullable
        private String externalId;
        @Nullable
        private String appId;
        @Nullable
        private String botId;
        @Nullable
        private String currentViewId;
        @Nullable
        private String rootViewId;
        @Nullable
        private String teamId;
        @Nullable
        private StateBlock stateValues;
        @Nullable
        private String hash;
        @Nullable
        private String previousViewId;

        private Builder() {
        }

        public final Builder from(HomeTabViewResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HomeTabViewPayloadBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewPayloadBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewResponseBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> previousViewIdOptional;
            Optional<String> privateMetadataOptional;
            Optional<String> externalIdOptional;
            Optional<String> callbackIdOptional;
            ViewPayloadBase instance;
            long bits = 0L;
            if (object instanceof HomeTabViewResponseIF) {
                instance = (HomeTabViewResponseIF)object;
                if ((bits & 0x80L) == 0L) {
                    callbackIdOptional = instance.getCallbackId();
                    if (callbackIdOptional.isPresent()) {
                        this.setCallbackId(callbackIdOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.setAppId(instance.getAppId());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.setTeamId(instance.getTeamId());
                    bits |= 0x200L;
                }
                if ((bits & 2L) == 0L) {
                    externalIdOptional = instance.getExternalId();
                    if (externalIdOptional.isPresent()) {
                        this.setExternalId(externalIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    privateMetadataOptional = instance.getPrivateMetadata();
                    if (privateMetadataOptional.isPresent()) {
                        this.setPrivateMetadata(privateMetadataOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setStateValues(instance.getStateValues());
                    bits |= 8L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.setBotId(instance.getBotId());
                    bits |= 0x400L;
                }
                if ((bits & 0x10L) == 0L) {
                    previousViewIdOptional = instance.getPreviousViewId();
                    if (previousViewIdOptional.isPresent()) {
                        this.setPreviousViewId(previousViewIdOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setCurrentViewId(instance.getCurrentViewId());
                    bits |= 0x20L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.setHash(instance.getHash());
                    bits |= 0x800L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.setRootViewId(instance.getRootViewId());
                    bits |= 0x40L;
                }
            }
            if (object instanceof HomeTabViewPayloadBase) {
                instance = (HomeTabViewPayloadBase)object;
                if ((bits & 2L) == 0L) {
                    externalIdOptional = instance.getExternalId();
                    if (externalIdOptional.isPresent()) {
                        this.setExternalId(externalIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    privateMetadataOptional = instance.getPrivateMetadata();
                    if (privateMetadataOptional.isPresent()) {
                        this.setPrivateMetadata(privateMetadataOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x80L) == 0L) {
                    callbackIdOptional = instance.getCallbackId();
                    if (callbackIdOptional.isPresent()) {
                        this.setCallbackId(callbackIdOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
            }
            if (object instanceof ViewPayloadBase) {
                instance = (ViewPayloadBase)object;
                if ((bits & 2L) == 0L) {
                    externalIdOptional = instance.getExternalId();
                    if (externalIdOptional.isPresent()) {
                        this.setExternalId(externalIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    privateMetadataOptional = instance.getPrivateMetadata();
                    if (privateMetadataOptional.isPresent()) {
                        this.setPrivateMetadata(privateMetadataOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x80L) == 0L) {
                    callbackIdOptional = instance.getCallbackId();
                    if (callbackIdOptional.isPresent()) {
                        this.setCallbackId(callbackIdOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
            }
            if (object instanceof ViewResponseBase) {
                instance = (ViewResponseBase)object;
                if ((bits & 0x80L) == 0L) {
                    callbackIdOptional = instance.getCallbackId();
                    if (callbackIdOptional.isPresent()) {
                        this.setCallbackId(callbackIdOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.setAppId(instance.getAppId());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.setTeamId(instance.getTeamId());
                    bits |= 0x200L;
                }
                if ((bits & 2L) == 0L) {
                    externalIdOptional = instance.getExternalId();
                    if (externalIdOptional.isPresent()) {
                        this.setExternalId(externalIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    privateMetadataOptional = instance.getPrivateMetadata();
                    if (privateMetadataOptional.isPresent()) {
                        this.setPrivateMetadata(privateMetadataOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setStateValues(instance.getStateValues());
                    bits |= 8L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.setBotId(instance.getBotId());
                    bits |= 0x400L;
                }
                if ((bits & 0x10L) == 0L) {
                    previousViewIdOptional = instance.getPreviousViewId();
                    if (previousViewIdOptional.isPresent()) {
                        this.setPreviousViewId(previousViewIdOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setCurrentViewId(instance.getCurrentViewId());
                    bits |= 0x20L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.setHash(instance.getHash());
                    bits |= 0x800L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.setRootViewId(instance.getRootViewId());
                    bits |= 0x40L;
                }
            }
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            return this;
        }

        public final Builder setPrivateMetadata(@Nullable String privateMetadata) {
            this.privateMetadata = privateMetadata;
            return this;
        }

        public final Builder setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata.orElse(null);
            return this;
        }

        public final Builder setCallbackId(@Nullable String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final Builder setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId.orElse(null);
            return this;
        }

        public final Builder setExternalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Builder setExternalId(Optional<String> externalId) {
            this.externalId = externalId.orElse(null);
            return this;
        }

        public final Builder setAppId(String appId) {
            this.appId = Objects.requireNonNull(appId, "appId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setBotId(String botId) {
            this.botId = Objects.requireNonNull(botId, "botId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setCurrentViewId(String currentViewId) {
            this.currentViewId = Objects.requireNonNull(currentViewId, "currentViewId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setRootViewId(String rootViewId) {
            this.rootViewId = Objects.requireNonNull(rootViewId, "rootViewId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setTeamId(String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setStateValues(StateBlock stateValues) {
            this.stateValues = Objects.requireNonNull(stateValues, "stateValues");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setHash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setPreviousViewId(@Nullable String previousViewId) {
            this.previousViewId = previousViewId;
            return this;
        }

        public final Builder setPreviousViewId(Optional<String> previousViewId) {
            this.previousViewId = previousViewId.orElse(null);
            return this;
        }

        public HomeTabViewResponse build() {
            this.checkRequiredAttributes();
            return new HomeTabViewResponse(HomeTabViewResponse.createUnmodifiableList(true, this.blocks), this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
        }

        private boolean appIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean botIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean currentViewIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean rootViewIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean teamIdIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean stateValuesIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean hashIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.appIdIsSet()) {
                attributes.add("appId");
            }
            if (!this.botIdIsSet()) {
                attributes.add("botId");
            }
            if (!this.currentViewIdIsSet()) {
                attributes.add("currentViewId");
            }
            if (!this.rootViewIdIsSet()) {
                attributes.add("rootViewId");
            }
            if (!this.teamIdIsSet()) {
                attributes.add("teamId");
            }
            if (!this.stateValuesIsSet()) {
                attributes.add("stateValues");
            }
            if (!this.hashIsSet()) {
                attributes.add("hash");
            }
            return "Cannot build HomeTabViewResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HomeTabViewResponseIF", generator="Immutables")
    static final class Json
    implements HomeTabViewResponseIF {
        @Nullable
        List<Block> blocks = Collections.emptyList();
        @Nullable
        Optional<String> privateMetadata = Optional.empty();
        @Nullable
        Optional<String> callbackId = Optional.empty();
        @Nullable
        Optional<String> externalId = Optional.empty();
        @Nullable
        String appId;
        @Nullable
        String botId;
        @Nullable
        String currentViewId;
        @Nullable
        String rootViewId;
        @Nullable
        String teamId;
        @Nullable
        StateBlock stateValues;
        @Nullable
        String hash;
        @Nullable
        Optional<String> previousViewId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
        }

        @JsonProperty
        public void setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata;
        }

        @JsonProperty
        public void setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setExternalId(Optional<String> externalId) {
            this.externalId = externalId;
        }

        @JsonProperty
        public void setAppId(String appId) {
            this.appId = appId;
        }

        @JsonProperty
        public void setBotId(String botId) {
            this.botId = botId;
        }

        @JsonProperty(value="id")
        public void setCurrentViewId(String currentViewId) {
            this.currentViewId = currentViewId;
        }

        @JsonProperty
        public void setRootViewId(String rootViewId) {
            this.rootViewId = rootViewId;
        }

        @JsonProperty
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty(value="state")
        @JsonDeserialize(using=StateBlockDeserializer.class)
        @JsonSerialize(using=StateBlockSerializer.class)
        public void setStateValues(StateBlock stateValues) {
            this.stateValues = stateValues;
        }

        @JsonProperty
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty
        public void setPreviousViewId(Optional<String> previousViewId) {
            this.previousViewId = previousViewId;
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPrivateMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAppId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBotId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCurrentViewId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRootViewId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StateBlock getStateValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPreviousViewId() {
            throw new UnsupportedOperationException();
        }
    }
}

