/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.usergroups.UsergroupListResponseIF;
import com.hubspot.slack.client.models.usergroups.SlackUsergroup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UsergroupListResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class UsergroupListResponse
implements UsergroupListResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final List<SlackUsergroup> usergroups;

    private UsergroupListResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, List<SlackUsergroup> usergroups) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.usergroups = usergroups;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public List<SlackUsergroup> getUsergroups() {
        return this.usergroups;
    }

    public final UsergroupListResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new UsergroupListResponse(value, this.responseMetadata, this.usergroups);
    }

    public final UsergroupListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new UsergroupListResponse(this.ok, newValue, this.usergroups);
    }

    public final UsergroupListResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new UsergroupListResponse(this.ok, value, this.usergroups);
    }

    public final UsergroupListResponse withUsergroups(SlackUsergroup ... elements) {
        List<SlackUsergroup> newValue = UsergroupListResponse.createUnmodifiableList(false, UsergroupListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new UsergroupListResponse(this.ok, this.responseMetadata, newValue);
    }

    public final UsergroupListResponse withUsergroups(Iterable<? extends SlackUsergroup> elements) {
        if (this.usergroups == elements) {
            return this;
        }
        List<SlackUsergroup> newValue = UsergroupListResponse.createUnmodifiableList(false, UsergroupListResponse.createSafeList(elements, true, false));
        return new UsergroupListResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsergroupListResponse && this.equalTo(0, (UsergroupListResponse)another);
    }

    private boolean equalTo(int synthetic, UsergroupListResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.usergroups.equals(another.usergroups);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.usergroups.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsergroupListResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("usergroups=").append(this.usergroups);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UsergroupListResponse fromJson(Json json) {
        Builder builder = UsergroupListResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.usergroups != null) {
            builder.addAllUsergroups(json.usergroups);
        }
        return builder.build();
    }

    public static UsergroupListResponse copyOf(UsergroupListResponseIF instance) {
        if (instance instanceof UsergroupListResponse) {
            return (UsergroupListResponse)instance;
        }
        return UsergroupListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="UsergroupListResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private List<SlackUsergroup> usergroups = new ArrayList<SlackUsergroup>();

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(UsergroupListResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof UsergroupListResponseIF) {
                instance = (UsergroupListResponseIF)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.addAllUsergroups(instance.getUsergroups());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder addUsergroups(SlackUsergroup element) {
            this.usergroups.add(Objects.requireNonNull(element, "usergroups element"));
            return this;
        }

        public final Builder addUsergroups(SlackUsergroup ... elements) {
            for (SlackUsergroup element : elements) {
                this.usergroups.add(Objects.requireNonNull(element, "usergroups element"));
            }
            return this;
        }

        public final Builder setUsergroups(Iterable<? extends SlackUsergroup> elements) {
            this.usergroups.clear();
            return this.addAllUsergroups(elements);
        }

        public final Builder addAllUsergroups(Iterable<? extends SlackUsergroup> elements) {
            for (SlackUsergroup slackUsergroup : elements) {
                this.usergroups.add(Objects.requireNonNull(slackUsergroup, "usergroups element"));
            }
            return this;
        }

        public UsergroupListResponse build() {
            this.checkRequiredAttributes();
            return new UsergroupListResponse(this.ok, this.responseMetadata, UsergroupListResponse.createUnmodifiableList(true, this.usergroups));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build UsergroupListResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UsergroupListResponseIF", generator="Immutables")
    static final class Json
    implements UsergroupListResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        List<SlackUsergroup> usergroups = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setUsergroups(List<SlackUsergroup> usergroups) {
            this.usergroups = usergroups;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackUsergroup> getUsergroups() {
            throw new UnsupportedOperationException();
        }
    }
}

