/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.group;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.group.SlackGroup;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.group.GroupsListResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="GroupsListResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class GroupsListResponse
implements GroupsListResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final List<SlackGroup> groups;

    private GroupsListResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, List<SlackGroup> groups) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.groups = groups;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public List<SlackGroup> getGroups() {
        return this.groups;
    }

    public final GroupsListResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new GroupsListResponse(value, this.responseMetadata, this.groups);
    }

    public final GroupsListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new GroupsListResponse(this.ok, newValue, this.groups);
    }

    public final GroupsListResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new GroupsListResponse(this.ok, value, this.groups);
    }

    public final GroupsListResponse withGroups(SlackGroup ... elements) {
        List<SlackGroup> newValue = GroupsListResponse.createUnmodifiableList(false, GroupsListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new GroupsListResponse(this.ok, this.responseMetadata, newValue);
    }

    public final GroupsListResponse withGroups(Iterable<? extends SlackGroup> elements) {
        if (this.groups == elements) {
            return this;
        }
        List<SlackGroup> newValue = GroupsListResponse.createUnmodifiableList(false, GroupsListResponse.createSafeList(elements, true, false));
        return new GroupsListResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupsListResponse && this.equalTo(0, (GroupsListResponse)another);
    }

    private boolean equalTo(int synthetic, GroupsListResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.groups.equals(another.groups);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.groups.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GroupsListResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("groups=").append(this.groups);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GroupsListResponse fromJson(Json json) {
        Builder builder = GroupsListResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.groups != null) {
            builder.addAllGroups(json.groups);
        }
        return builder.build();
    }

    public static GroupsListResponse copyOf(GroupsListResponseIF instance) {
        if (instance instanceof GroupsListResponse) {
            return (GroupsListResponse)instance;
        }
        return GroupsListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GroupsListResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private List<SlackGroup> groups = new ArrayList<SlackGroup>();

        private Builder() {
        }

        public final Builder from(GroupsListResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof GroupsListResponseIF) {
                instance = (GroupsListResponseIF)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.addAllGroups(instance.getGroups());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder addGroups(SlackGroup element) {
            this.groups.add(Objects.requireNonNull(element, "groups element"));
            return this;
        }

        public final Builder addGroups(SlackGroup ... elements) {
            for (SlackGroup element : elements) {
                this.groups.add(Objects.requireNonNull(element, "groups element"));
            }
            return this;
        }

        public final Builder setGroups(Iterable<? extends SlackGroup> elements) {
            this.groups.clear();
            return this.addAllGroups(elements);
        }

        public final Builder addAllGroups(Iterable<? extends SlackGroup> elements) {
            for (SlackGroup slackGroup : elements) {
                this.groups.add(Objects.requireNonNull(slackGroup, "groups element"));
            }
            return this;
        }

        public GroupsListResponse build() {
            this.checkRequiredAttributes();
            return new GroupsListResponse(this.ok, this.responseMetadata, GroupsListResponse.createUnmodifiableList(true, this.groups));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build GroupsListResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GroupsListResponseIF", generator="Immutables")
    static final class Json
    implements GroupsListResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        List<SlackGroup> groups = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setGroups(List<SlackGroup> groups) {
            this.groups = groups;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackGroup> getGroups() {
            throw new UnsupportedOperationException();
        }
    }
}

