/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsRepliesResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConversationsRepliesResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ConversationsRepliesResponse
implements ConversationsRepliesResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final List<LiteMessage> messages;
    private final boolean hasMore;

    private ConversationsRepliesResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, List<LiteMessage> messages, boolean hasMore) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.messages = messages;
        this.hasMore = hasMore;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public List<LiteMessage> getMessages() {
        return this.messages;
    }

    @Override
    @JsonProperty(value="has_more")
    public boolean hasMore() {
        return this.hasMore;
    }

    public final ConversationsRepliesResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ConversationsRepliesResponse(value, this.responseMetadata, this.messages, this.hasMore);
    }

    public final ConversationsRepliesResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ConversationsRepliesResponse(this.ok, newValue, this.messages, this.hasMore);
    }

    public final ConversationsRepliesResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ConversationsRepliesResponse(this.ok, value, this.messages, this.hasMore);
    }

    public final ConversationsRepliesResponse withMessages(LiteMessage ... elements) {
        List<LiteMessage> newValue = ConversationsRepliesResponse.createUnmodifiableList(false, ConversationsRepliesResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ConversationsRepliesResponse(this.ok, this.responseMetadata, newValue, this.hasMore);
    }

    public final ConversationsRepliesResponse withMessages(Iterable<? extends LiteMessage> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<LiteMessage> newValue = ConversationsRepliesResponse.createUnmodifiableList(false, ConversationsRepliesResponse.createSafeList(elements, true, false));
        return new ConversationsRepliesResponse(this.ok, this.responseMetadata, newValue, this.hasMore);
    }

    public final ConversationsRepliesResponse withHasMore(boolean value) {
        if (this.hasMore == value) {
            return this;
        }
        return new ConversationsRepliesResponse(this.ok, this.responseMetadata, this.messages, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsRepliesResponse && this.equalTo(0, (ConversationsRepliesResponse)another);
    }

    private boolean equalTo(int synthetic, ConversationsRepliesResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.messages.equals(another.messages) && this.hasMore == another.hasMore;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + Boolean.hashCode(this.hasMore);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationsRepliesResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("messages=").append(this.messages);
        builder.append(", ");
        builder.append("hasMore=").append(this.hasMore);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ConversationsRepliesResponse fromJson(Json json) {
        Builder builder = ConversationsRepliesResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.messages != null) {
            builder.addAllMessages(json.messages);
        }
        if (json.hasMoreIsSet) {
            builder.setHasMore(json.hasMore);
        }
        return builder.build();
    }

    public static ConversationsRepliesResponse copyOf(ConversationsRepliesResponseIF instance) {
        if (instance instanceof ConversationsRepliesResponse) {
            return (ConversationsRepliesResponse)instance;
        }
        return ConversationsRepliesResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ConversationsRepliesResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_HAS_MORE = 2L;
        private long initBits = 3L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private List<LiteMessage> messages = new ArrayList<LiteMessage>();
        private boolean hasMore;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ConversationsRepliesResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ConversationsRepliesResponseIF) {
                instance = (ConversationsRepliesResponseIF)object;
                this.setHasMore(instance.hasMore());
                this.addAllMessages(instance.getMessages());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder addMessages(LiteMessage element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(LiteMessage ... elements) {
            for (LiteMessage element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder setMessages(Iterable<? extends LiteMessage> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends LiteMessage> elements) {
            for (LiteMessage liteMessage : elements) {
                this.messages.add(Objects.requireNonNull(liteMessage, "messages element"));
            }
            return this;
        }

        public final Builder setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ConversationsRepliesResponse build() {
            this.checkRequiredAttributes();
            return new ConversationsRepliesResponse(this.ok, this.responseMetadata, ConversationsRepliesResponse.createUnmodifiableList(true, this.messages), this.hasMore);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean hasMoreIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.hasMoreIsSet()) {
                attributes.add("hasMore");
            }
            return "Cannot build ConversationsRepliesResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConversationsRepliesResponseIF", generator="Immutables")
    static final class Json
    implements ConversationsRepliesResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        List<LiteMessage> messages = Collections.emptyList();
        boolean hasMore;
        boolean hasMoreIsSet;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setMessages(List<LiteMessage> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="has_more")
        public void setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.hasMoreIsSet = true;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<LiteMessage> getMessages() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasMore() {
            throw new UnsupportedOperationException();
        }
    }
}

