/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.conversations.Conversation;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsInfoResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConversationsInfoResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ConversationsInfoResponse
implements ConversationsInfoResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final Conversation conversation;

    private ConversationsInfoResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, Conversation conversation) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.conversation = conversation;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty(value="channel")
    public Conversation getConversation() {
        return this.conversation;
    }

    public final ConversationsInfoResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ConversationsInfoResponse(value, this.responseMetadata, this.conversation);
    }

    public final ConversationsInfoResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ConversationsInfoResponse(this.ok, newValue, this.conversation);
    }

    public final ConversationsInfoResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ConversationsInfoResponse(this.ok, value, this.conversation);
    }

    public final ConversationsInfoResponse withConversation(Conversation value) {
        if (this.conversation == value) {
            return this;
        }
        Conversation newValue = Objects.requireNonNull(value, "conversation");
        return new ConversationsInfoResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsInfoResponse && this.equalTo(0, (ConversationsInfoResponse)another);
    }

    private boolean equalTo(int synthetic, ConversationsInfoResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.conversation.equals(another.conversation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.conversation.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationsInfoResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("conversation=").append(this.conversation);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ConversationsInfoResponse fromJson(Json json) {
        Builder builder = ConversationsInfoResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.conversation != null) {
            builder.setConversation(json.conversation);
        }
        return builder.build();
    }

    public static ConversationsInfoResponse copyOf(ConversationsInfoResponseIF instance) {
        if (instance instanceof ConversationsInfoResponse) {
            return (ConversationsInfoResponse)instance;
        }
        return ConversationsInfoResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConversationsInfoResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_CONVERSATION = 2L;
        private long initBits = 3L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private Conversation conversation;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ConversationsInfoResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ConversationsInfoResponseIF) {
                instance = (ConversationsInfoResponseIF)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.setConversation(instance.getConversation());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setConversation(Conversation conversation) {
            this.conversation = Objects.requireNonNull(conversation, "conversation");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ConversationsInfoResponse build() {
            this.checkRequiredAttributes();
            return new ConversationsInfoResponse(this.ok, this.responseMetadata, this.conversation);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean conversationIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.conversationIsSet()) {
                attributes.add("conversation");
            }
            return "Cannot build ConversationsInfoResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConversationsInfoResponseIF", generator="Immutables")
    static final class Json
    implements ConversationsInfoResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        Conversation conversation;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty(value="channel")
        public void setConversation(Conversation conversation) {
            this.conversation = conversation;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Conversation getConversation() {
            throw new UnsupportedOperationException();
        }
    }
}

